/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.htmlparser.Parser;
import org.htmlparser.beans.StringBean;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.opencms.util.CmsStringUtil;

public final class CmsHtmlExtractor {
    private CmsHtmlExtractor() {
    }

    public static String extractText(InputStream in, String encoding) throws ParserException, UnsupportedEncodingException {
        Parser parser = new Parser();
        Lexer lexer = new Lexer();
        Page page = new Page(in, encoding);
        lexer.setPage(page);
        parser.setLexer(lexer);
        StringBean stringBean = new StringBean();
        parser.visitAllNodesWith((NodeVisitor)stringBean);
        String result = stringBean.getStrings();
        return result == null ? "" : result;
    }

    public static String extractText(String content, String encoding) throws ParserException, UnsupportedEncodingException {
        if (CmsStringUtil.isEmpty(content)) {
            return content;
        }
        StringBuffer newContent = new StringBuffer(content.length() + 32);
        newContent.append("<html><body>");
        newContent.append(content);
        newContent.append("</body></html>");
        ByteArrayInputStream in = new ByteArrayInputStream(newContent.toString().getBytes(encoding));
        return CmsHtmlExtractor.extractText(in, encoding);
    }
}

