/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.htmlparser.NodeFactory;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.Div;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.opencms.jsp.parse.DivTag;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsHtmlNodeVisitor;

public class CmsHtmlParser
extends NodeVisitor
implements I_CmsHtmlNodeVisitor {
    protected List m_noAutoCloseTags;
    protected static final String[] TAG_ARRAY = new String[]{"H1", "H2", "H3", "H4", "H5", "H6", "P", "DIV", "SPAN", "BR", "OL", "UL", "LI", "TABLE", "TD", "TR", "TH", "THEAD", "TBODY", "TFOOT"};
    protected static final List TAG_LIST = Arrays.asList(TAG_ARRAY);
    protected boolean m_echo;
    protected StringBuffer m_result = new StringBuffer(1024);
    private String m_configuration = "";

    public CmsHtmlParser() {
        this(false);
    }

    public CmsHtmlParser(boolean echo) {
        this.m_echo = echo;
        this.m_noAutoCloseTags = new ArrayList(32);
    }

    protected PrototypicalNodeFactory configureNoAutoCorrectionTags() {
        PrototypicalNodeFactory factory = new PrototypicalNodeFactory();
        Iterator it = this.m_noAutoCloseTags.iterator();
        Div div = new Div();
        List<String> divNames = Arrays.asList(div.getIds());
        while (it.hasNext()) {
            String tagName = (String)it.next();
            if (!divNames.contains(tagName)) continue;
            factory.unregisterTag((Tag)new Div());
            factory.registerTag((Tag)new DivTag());
        }
        return factory;
    }

    public String getConfiguration() {
        return this.m_configuration;
    }

    public String getResult() {
        return this.m_result.toString();
    }

    public String getTagHtml(Tag tag) {
        StringBuffer result = new StringBuffer(32);
        result.append('<');
        result.append(tag.getText());
        result.append('>');
        return result.toString();
    }

    public String process(String html, String encoding) throws ParserException {
        this.m_result = new StringBuffer();
        Parser parser = new Parser();
        Lexer lexer = new Lexer();
        Page page = new Page(html, encoding);
        lexer.setPage(page);
        parser.setLexer(lexer);
        if (this.m_noAutoCloseTags != null && this.m_noAutoCloseTags.size() > 0) {
            PrototypicalNodeFactory factory = this.configureNoAutoCorrectionTags();
            lexer.setNodeFactory((NodeFactory)factory);
        }
        parser.visitAllNodesWith((NodeVisitor)this);
        return this.getResult();
    }

    public void setConfiguration(String configuration) {
        if (CmsStringUtil.isNotEmpty(configuration)) {
            this.m_configuration = configuration;
        }
    }

    public void visitEndTag(Tag tag) {
        if (this.m_echo) {
            this.m_result.append(this.getTagHtml(tag));
        }
    }

    public void visitRemarkNode(Remark remark) {
        if (this.m_echo) {
            this.m_result.append(remark.toHtml(true));
        }
    }

    public void visitStringNode(Text text) {
        if (this.m_echo) {
            this.m_result.append(text.getText());
        }
    }

    public void visitTag(Tag tag) {
        if (this.m_echo) {
            this.m_result.append(this.getTagHtml(tag));
        }
    }

    protected String collapse(String string) {
        int len = string.length();
        StringBuffer result = new StringBuffer(len);
        int state = 0;
        block3: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u200b': {
                    if (false == state) continue block3;
                    state = 1;
                    continue block3;
                }
                default: {
                    if (1 == state) {
                        result.append(' ');
                    }
                    state = 2;
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public List getNoAutoCloseTags() {
        return this.m_noAutoCloseTags;
    }

    public void setNoAutoCloseTags(List noAutoCloseTagList) {
        this.m_noAutoCloseTags.clear();
        if (noAutoCloseTagList != null) {
            Iterator it = noAutoCloseTagList.iterator();
            while (it.hasNext()) {
                this.m_noAutoCloseTags.add(((String)it.next()).toUpperCase());
            }
        }
    }
}

