/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUriSplitter;
import org.opencms.util.Messages;

public final class CmsRequestUtil {
    public static final String ATTRIBUTE_ERRORCODE = "org.opencms.util.CmsErrorCode";
    public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_CONNECTION = "Connection";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_JSESSIONID = "JSESSIONID";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_OPENCMS_EXPORT = "OpenCms-Export";
    public static final String HEADER_PRAGMA = "Pragma";
    public static final String HEADER_SERVER = "Server";
    public static final String HEADER_USER_AGENT = "user-agent";
    public static final String HEADER_VALUE_MAX_AGE = "max-age=";
    public static final String HEADER_VALUE_MUST_REVALIDATE = "must-revalidate";
    public static final String HEADER_VALUE_NO_CACHE = "no-cache";
    public static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HEADER_X_FORWARDED_FOR = "x-forwarded-for";
    public static final String PARAMETER_ASSIGNMENT = "=";
    public static final String PARAMETER_DELIMITER = "&";
    public static final String URL_DELIMITER = "?";
    private static final String AMP = "amp;";
    private static final Log LOG = CmsLog.getLog(CmsRequestUtil.class);

    private CmsRequestUtil() {
    }

    public static String appendParameter(String url, String paramName, String paramValue) {
        if (CmsStringUtil.isEmpty(url)) {
            return null;
        }
        int pos = url.indexOf(URL_DELIMITER);
        StringBuffer result = new StringBuffer(256);
        result.append(url);
        if (pos >= 0) {
            result.append(PARAMETER_DELIMITER);
        } else {
            result.append(URL_DELIMITER);
        }
        result.append(paramName);
        result.append(PARAMETER_ASSIGNMENT);
        result.append(paramValue);
        return result.toString();
    }

    public static String appendParameters(String url, Map params, boolean encode) {
        if (CmsStringUtil.isEmpty(url)) {
            return null;
        }
        if (params == null || params.isEmpty()) {
            return url;
        }
        int pos = url.indexOf(URL_DELIMITER);
        StringBuffer result = new StringBuffer(256);
        result.append(url);
        if (pos >= 0) {
            result.append(PARAMETER_DELIMITER);
        } else {
            result.append(URL_DELIMITER);
        }
        Map newParams = CmsRequestUtil.createParameterMap(params);
        Iterator i = newParams.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String[] values = (String[])value;
            for (int j = 0; j < values.length; ++j) {
                String strValue = values[j];
                if (encode) {
                    strValue = CmsEncoder.encode(strValue);
                }
                result.append(key);
                result.append(PARAMETER_ASSIGNMENT);
                result.append(strValue);
                if (j + 1 >= values.length) continue;
                result.append(PARAMETER_DELIMITER);
            }
            if (!i.hasNext()) continue;
            result.append(PARAMETER_DELIMITER);
        }
        return result.toString();
    }

    public static Map createParameterMap(Map params) {
        if (params == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Object values = entry.getValue();
            if (values instanceof String[]) {
                result.put(key, values);
                continue;
            }
            if (values == null) continue;
            result.put(key, new String[]{values.toString()});
        }
        return result;
    }

    public static Map createParameterMap(String query) {
        if (CmsStringUtil.isEmpty(query)) {
            return new HashMap();
        }
        if (query.charAt(0) == URL_DELIMITER.charAt(0)) {
            query = query.substring(1);
        }
        String[] params = CmsStringUtil.splitAsArray(query, PARAMETER_DELIMITER);
        HashMap<String, String[]> parameters = new HashMap<String, String[]>(params.length);
        for (int i = 0; i < params.length; ++i) {
            String key = null;
            String value = null;
            int pos = params[i].indexOf(PARAMETER_ASSIGNMENT);
            if (pos > 0) {
                key = params[i].substring(0, pos);
                value = params[i].substring(pos + 1);
            } else if (pos < 0) {
                key = params[i];
                value = "";
            }
            if (key != null && key.startsWith(AMP)) {
                key = key.substring(AMP.length());
            }
            if (key == null) continue;
            String[] values = (String[])parameters.get(key);
            if (values == null) {
                values = new String[]{value};
            } else {
                String[] copy = new String[values.length + 1];
                System.arraycopy(values, 0, copy, 0, values.length);
                copy[copy.length - 1] = value;
                values = copy;
            }
            parameters.put(key, values);
        }
        return parameters;
    }

    public static String encodeParams(HttpServletRequest req) {
        StringBuffer result = new StringBuffer(512);
        Map params = req.getParameterMap();
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String param = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            for (int j = 0; j < values.length; ++j) {
                result.append(param);
                result.append(PARAMETER_ASSIGNMENT);
                result.append(CmsEncoder.encode(values[j]));
                if (j + 1 >= values.length) continue;
                result.append(PARAMETER_DELIMITER);
            }
            if (!i.hasNext()) continue;
            result.append(PARAMETER_DELIMITER);
        }
        return CmsEncoder.encode(result.toString());
    }

    public static String encodeParamsWithUri(String uri, HttpServletRequest req) {
        String params = CmsRequestUtil.encodeParams(req);
        String result = CmsStringUtil.isNotEmpty(params) ? CmsEncoder.encode(uri + URL_DELIMITER) + params : CmsEncoder.encode(uri);
        return result;
    }

    public static void forwardRequest(String target, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CmsUriSplitter uri = new CmsUriSplitter(target);
        Map params = CmsRequestUtil.createParameterMap(uri.getQuery());
        CmsRequestUtil.forwardRequest(uri.getPrefix(), params, req, res);
    }

    public static void forwardRequest(String target, Map params, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CmsFlexRequest f_req = (CmsFlexRequest)req;
        f_req.setParameterMap(params);
        String vfsPrefix = OpenCms.getStaticExportManager().getVfsPrefix();
        if (target.startsWith(vfsPrefix)) {
            target = target.substring(vfsPrefix.length());
            target = OpenCms.getSystemInfo().getServletPath() + target;
        }
        f_req.getRequestDispatcher(target).forward((ServletRequest)f_req, (ServletResponse)res);
    }

    public static String getCookieValue(CmsJspActionElement jsp, String name) {
        Cookie[] cookies = jsp.getRequest().getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public static String getNotEmptyDecodedParameter(HttpServletRequest request, String paramName) {
        String result = CmsRequestUtil.getNotEmptyParameter(request, paramName);
        if (result != null) {
            result = CmsEncoder.decode(result.trim());
        }
        return result;
    }

    public static String getNotEmptyParameter(HttpServletRequest request, String paramName) {
        String result = request.getParameter(paramName);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = null;
        }
        return result;
    }

    public static Object getSessionValue(HttpServletRequest request, String key) {
        HttpSession session = request.getSession(true);
        return session.getAttribute(key);
    }

    public static List readMultipartFileItems(HttpServletRequest request) {
        if (!FileUploadBase.isMultipartContent((HttpServletRequest)request)) {
            return null;
        }
        DiskFileUpload fu = new DiskFileUpload();
        fu.setHeaderEncoding(request.getCharacterEncoding());
        fu.setSizeThreshold(4096);
        fu.setRepositoryPath(OpenCms.getSystemInfo().getPackagesRfsPath());
        List result = new ArrayList();
        try {
            List items = fu.parseRequest(request);
            if (items != null) {
                result = items;
            }
        }
        catch (FileUploadException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_MULIPART_REQ_FAILED_0"), (Throwable)e);
        }
        return result;
    }

    public static Map readParameterMapFromMultiPart(String encoding, List multiPartFileItems) {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        Iterator i = multiPartFileItems.iterator();
        while (i.hasNext()) {
            FileItem item = (FileItem)i.next();
            String name = item.getFieldName();
            String value = null;
            if (name == null || item.getName() != null) continue;
            try {
                value = item.getString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ENC_MULTIPART_REQ_ERROR_0"), (Throwable)e);
                value = item.getString();
            }
            if (parameterMap.containsKey(name)) {
                String[] oldValues = (String[])parameterMap.get(name);
                String[] newValues = new String[oldValues.length + 1];
                System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                newValues[oldValues.length] = value;
                parameterMap.put(name, newValues);
                continue;
            }
            parameterMap.put(name, new String[]{value});
        }
        return parameterMap;
    }

    public static void redirectPermanently(CmsJspActionElement jsp, String target) {
        String newTarget = OpenCms.getLinkManager().substituteLink(jsp.getCmsObject(), target, null, true);
        jsp.getRequest().setAttribute(ATTRIBUTE_ERRORCODE, (Object)new Integer(301));
        jsp.getResponse().setHeader(HEADER_LOCATION, newTarget);
        jsp.getResponse().setHeader(HEADER_CONNECTION, "close");
    }

    public static void redirectRequestSecure(CmsJspActionElement jsp, String target) throws IOException {
        jsp.getResponse().sendRedirect(OpenCms.getLinkManager().substituteLink(jsp.getCmsObject(), target, null, true));
    }

    public static void removeSessionValue(HttpServletRequest request, String key) {
        HttpSession session = request.getSession(true);
        session.removeAttribute(key);
    }

    public static void setCookieValue(CmsJspActionElement jsp, String name, String value) {
        Cookie[] cookies = jsp.getRequest().getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
            cookies[i].setValue(value);
            return;
        }
        Cookie cookie = new Cookie(name, value);
        jsp.getResponse().addCookie(cookie);
    }

    public static void setNoCacheHeaders(HttpServletResponse res) {
        res.setHeader(HEADER_CACHE_CONTROL, "max-age=0");
        res.addHeader(HEADER_CACHE_CONTROL, HEADER_VALUE_MUST_REVALIDATE);
        res.setHeader(HEADER_PRAGMA, HEADER_VALUE_NO_CACHE);
    }

    public static void setSessionValue(HttpServletRequest request, String key, Object value) {
        HttpSession session = request.getSession(true);
        session.setAttribute(key, value);
    }
}

