/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.net.URI;
import java.net.URISyntaxException;

public class CmsUriSplitter {
    private static final StringBuffer EMPTY_BUFFER = new StringBuffer(0);
    private String m_anchor;
    private boolean m_errorFree;
    private boolean m_isStrict;
    private String m_prefix;
    private String m_query;
    private String m_uri;

    public CmsUriSplitter(String uri) {
        this(uri, false);
    }

    public CmsUriSplitter(String uri, boolean strict) {
        this.m_uri = uri;
        this.m_errorFree = true;
        this.m_isStrict = strict;
        if (strict) {
            try {
                int i;
                URI u = new URI(uri);
                this.m_prefix = (u.getScheme() != null ? u.getScheme() + ":" : "") + u.getRawSchemeSpecificPart();
                this.m_anchor = u.getRawFragment();
                this.m_query = u.getRawQuery();
                if (this.m_prefix != null && (i = this.m_prefix.indexOf(63)) != -1) {
                    this.m_query = this.m_prefix.substring(i + 1);
                    this.m_prefix = this.m_prefix.substring(0, i);
                }
                if (this.m_anchor != null && (i = this.m_anchor.indexOf(63)) != -1) {
                    this.m_query = this.m_anchor.substring(i + 1);
                    this.m_anchor = this.m_anchor.substring(0, i);
                }
            }
            catch (Exception exc) {
                strict = false;
                this.m_errorFree = false;
            }
        }
        if (!strict && uri != null) {
            StringBuffer prefix = new StringBuffer(uri.length());
            StringBuffer anchor = EMPTY_BUFFER;
            StringBuffer query = EMPTY_BUFFER;
            int len = uri.length();
            int cur = 0;
            block6: for (int i = 0; i < len; ++i) {
                char c = uri.charAt(i);
                if (c == '#') {
                    cur = 1;
                    anchor = new StringBuffer(uri.length());
                    continue;
                }
                if (c == '?') {
                    cur = 2;
                    query = new StringBuffer(uri.length());
                    continue;
                }
                switch (cur) {
                    case 1: {
                        anchor.append(c);
                        continue block6;
                    }
                    case 2: {
                        query.append(c);
                        continue block6;
                    }
                    default: {
                        prefix.append(c);
                    }
                }
            }
            if (prefix.length() > 0) {
                this.m_prefix = prefix.toString();
            }
            if (anchor.length() > 0) {
                this.m_anchor = anchor.toString();
            }
            if (query.length() > 0) {
                this.m_query = query.toString();
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsUriSplitter) {
            CmsUriSplitter other = (CmsUriSplitter)obj;
            if (this.m_prefix == null && other.m_prefix != null && !other.m_prefix.equals(this.m_prefix)) {
                return false;
            }
            if (this.m_anchor == null && other.m_anchor != null && !other.m_anchor.equals(this.m_anchor)) {
                return false;
            }
            return this.m_query != null || other.m_query == null || other.m_query.equals(this.m_query);
        }
        return false;
    }

    public String getAnchor() {
        return this.m_anchor;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getUri() {
        return this.m_uri;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.m_prefix != null) {
            hashCode += this.m_prefix.hashCode();
        }
        if (this.m_anchor != null) {
            hashCode += this.m_anchor.hashCode();
        }
        if (this.m_query != null) {
            hashCode += this.m_query.hashCode();
        }
        return hashCode;
    }

    public boolean isErrorFree() {
        return this.m_errorFree;
    }

    public URI toURI() throws URISyntaxException {
        if (this.m_isStrict && this.m_errorFree) {
            return new URI(this.m_uri);
        }
        return new URI(null, this.m_prefix + (this.m_query != null ? "?" + this.m_query : ""), this.m_anchor);
    }
}

