/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.Messages;
import org.opencms.xml.CmsXmlException;

public final class CmsXsltUtil {
    public static final String TAG_END_DELIMITER = ">";
    public static final String TAG_START_DELIMITER = "<";
    public static final char TEXT_DELIMITER = '\"';
    static final String[] DELIMITERS = new String[]{";", ",", "\t"};

    private CmsXsltUtil() {
    }

    public static String getPreferredDelimiter(String csvData) {
        String bestMatch = "";
        int bestMatchCount = 0;
        for (int i = 0; i < DELIMITERS.length; ++i) {
            int currentCount = csvData.split(DELIMITERS[i]).length;
            if (currentCount <= bestMatchCount) continue;
            bestMatch = DELIMITERS[i];
            bestMatchCount = currentCount;
        }
        return bestMatch;
    }

    public static String transformCsvContent(CmsObject cms, String xsltFile, String csvContent, String delimiter) throws CmsException, CmsXmlException {
        String xmlContent = "";
        try {
            xmlContent = CmsXsltUtil.getTableHtml(csvContent, delimiter);
        }
        catch (IOException e) {
            throw new CmsXmlException(Messages.get().container("ERR_CSV_XML_TRANSFORMATION_FAILED_0"));
        }
        if (xsltFile != null) {
            xmlContent = CmsXsltUtil.transformXmlContent(cms, xsltFile, xmlContent);
        }
        return xmlContent;
    }

    public static String transformXmlContent(CmsObject cms, String xsltFile, String xmlContent) throws CmsException, CmsXmlException {
        StreamSource xmlSource = new StreamSource(new StringReader(xmlContent));
        String xsltString = new String(cms.readFile(xsltFile).getContents());
        StreamSource xsltSource = new StreamSource(new StringReader(xsltString));
        String result = null;
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            StringWriter writer = new StringWriter();
            trans.transform(xmlSource, new StreamResult(writer));
            result = writer.toString();
        }
        catch (Exception exc) {
            throw new CmsXmlException(Messages.get().container("ERR_CSV_XML_TRANSFORMATION_FAILED_0"));
        }
        if (result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            return result.substring(38);
        }
        return result;
    }

    private static String getColGroup(String formatString, String delimiter) {
        StringBuffer colgroup = new StringBuffer(128);
        String[] formatStrings = formatString.split(delimiter);
        colgroup.append("<colgroup>");
        for (int i = 0; i < formatStrings.length; ++i) {
            colgroup.append("<col align=\"");
            char align = formatStrings[i].trim().charAt(0);
            switch (align) {
                case 'l': {
                    colgroup.append("left");
                    break;
                }
                case 'c': {
                    colgroup.append("center");
                    break;
                }
                case 'r': {
                    colgroup.append("right");
                    break;
                }
                default: {
                    throw new RuntimeException("invalid format option");
                }
            }
            colgroup.append("\"/>");
        }
        return colgroup.append("</colgroup>").toString();
    }

    private static String getTableHtml(String csvData, String delimiter) throws IOException {
        String line;
        String lineSeparator = System.getProperty("line.separator");
        String formatString = csvData.substring(0, csvData.indexOf(lineSeparator));
        if (delimiter == null) {
            delimiter = CmsXsltUtil.getPreferredDelimiter(csvData);
        }
        StringBuffer xml = new StringBuffer("<table>");
        if (CmsXsltUtil.isFormattingInformation(formatString, delimiter)) {
            xml.append(CmsXsltUtil.getColGroup(formatString, delimiter));
            csvData = csvData.substring(formatString.length() + lineSeparator.length());
        }
        BufferedReader br = new BufferedReader(new StringReader(csvData));
        while ((line = br.readLine()) != null) {
            xml.append("<tr>\n");
            StringTokenizer t = new StringTokenizer(line, delimiter, true);
            boolean hasValue = false;
            while (t.hasMoreElements()) {
                String item = (String)t.nextElement();
                if (!hasValue) {
                    xml.append("\t<td>");
                    hasValue = true;
                }
                if (!item.equals(delimiter)) {
                    if ((item = CmsXsltUtil.removeStringDelimiters(item)).startsWith(TAG_START_DELIMITER) && item.endsWith(TAG_END_DELIMITER)) {
                        xml.append(item);
                        continue;
                    }
                    xml.append(CmsStringUtil.escapeHtml(item));
                    continue;
                }
                xml.append("</td>\n");
                hasValue = false;
            }
            if (hasValue) {
                xml.append("</td>\n");
            } else {
                xml.append("<td></td>\n");
            }
            xml.append("</tr>\n");
        }
        return xml.append("</table>").toString();
    }

    private static boolean isFormattingInformation(String formatString, String delimiter) {
        String[] formatStrings = formatString.split(delimiter);
        for (int i = 0; i < formatStrings.length; ++i) {
            if (formatStrings[i].trim().matches("[lcr]")) continue;
            return false;
        }
        return true;
    }

    private static String removeStringDelimiters(String key) {
        String k = key.trim();
        if (CmsStringUtil.isNotEmpty(k)) {
            if (k.charAt(0) == '\"') {
                k = k.substring(1);
            }
            if (k.charAt(k.length() - 1) == '\"') {
                k = k.substring(0, k.length() - 1);
            }
        }
        k = CmsStringUtil.substitute(k, "\"\"", "\"");
        return k;
    }
}

