/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.webdav;

import java.util.Hashtable;

public final class CmsWebdavStatus {
    public static final int SC_ACCEPTED = 202;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_CONFLICT = 409;
    public static final int SC_CONTINUE = 100;
    public static final int SC_CREATED = 201;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_INSUFFICIENT_SPACE_ON_RESOURCE = 419;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_LOCKED = 423;
    public static final int SC_METHOD_FAILURE = 420;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_MULTI_STATUS = 207;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_OK = 200;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_TOO_LONG = 413;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_UNPROCESSABLE_ENTITY = 418;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    private static Hashtable mapStatusCodes = new Hashtable();

    private CmsWebdavStatus() {
    }

    public static String getStatusText(int nHttpStatusCode) {
        Integer intKey = new Integer(nHttpStatusCode);
        if (!mapStatusCodes.containsKey(intKey)) {
            return "";
        }
        return (String)mapStatusCodes.get(intKey);
    }

    private static void addStatusCodeMap(int nKey, String strVal) {
        mapStatusCodes.put(new Integer(nKey), strVal);
    }

    static {
        CmsWebdavStatus.addStatusCodeMap(200, "OK");
        CmsWebdavStatus.addStatusCodeMap(201, "Created");
        CmsWebdavStatus.addStatusCodeMap(202, "Accepted");
        CmsWebdavStatus.addStatusCodeMap(204, "No Content");
        CmsWebdavStatus.addStatusCodeMap(301, "Moved Permanently");
        CmsWebdavStatus.addStatusCodeMap(302, "Moved Temporarily");
        CmsWebdavStatus.addStatusCodeMap(304, "Not Modified");
        CmsWebdavStatus.addStatusCodeMap(400, "Bad Request");
        CmsWebdavStatus.addStatusCodeMap(401, "Unauthorized");
        CmsWebdavStatus.addStatusCodeMap(403, "Forbidden");
        CmsWebdavStatus.addStatusCodeMap(404, "Not Found");
        CmsWebdavStatus.addStatusCodeMap(500, "Internal Server Error");
        CmsWebdavStatus.addStatusCodeMap(501, "Not Implemented");
        CmsWebdavStatus.addStatusCodeMap(502, "Bad Gateway");
        CmsWebdavStatus.addStatusCodeMap(503, "Service Unavailable");
        CmsWebdavStatus.addStatusCodeMap(100, "Continue");
        CmsWebdavStatus.addStatusCodeMap(405, "Method Not Allowed");
        CmsWebdavStatus.addStatusCodeMap(409, "Conflict");
        CmsWebdavStatus.addStatusCodeMap(412, "Precondition Failed");
        CmsWebdavStatus.addStatusCodeMap(413, "Request Too Long");
        CmsWebdavStatus.addStatusCodeMap(415, "Unsupported Media Type");
        CmsWebdavStatus.addStatusCodeMap(207, "Multi-Status");
        CmsWebdavStatus.addStatusCodeMap(418, "Unprocessable Entity");
        CmsWebdavStatus.addStatusCodeMap(419, "Insufficient Space On Resource");
        CmsWebdavStatus.addStatusCodeMap(420, "Method Failure");
        CmsWebdavStatus.addStatusCodeMap(423, "Locked");
    }
}

