/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplace;

public class CmsCalendarWidget
extends A_CmsWidget {
    private static final Log LOG = CmsLog.getLog(CmsCalendarWidget.class);

    public CmsCalendarWidget() {
        this("");
    }

    public CmsCalendarWidget(String configuration) {
        super(configuration);
    }

    public static String calendarIncludes(Locale locale) {
        return CmsCalendarWidget.calendarIncludes(locale, "opencms");
    }

    public static String calendarIncludes(Locale locale, String style) {
        StringBuffer result = new StringBuffer(512);
        String calendarPath = CmsWorkplace.getSkinUri() + "components/js_calendar/";
        if (CmsStringUtil.isEmpty(style)) {
            style = "system";
        }
        result.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        result.append(calendarPath);
        result.append("calendar-");
        result.append(style);
        result.append(".css\">\n");
        result.append("<script type=\"text/javascript\" src=\"");
        result.append(calendarPath);
        result.append("calendar.js\"></script>\n");
        result.append("<script type=\"text/javascript\" src=\"");
        result.append(calendarPath);
        result.append("lang/calendar-");
        result.append(locale.getLanguage());
        result.append(".js\"></script>\n");
        result.append("<script type=\"text/javascript\" src=\"");
        result.append(calendarPath);
        result.append("calendar-setup.js\"></script>\n");
        return result.toString();
    }

    public static String calendarInit(CmsMessages messages, String inputFieldId, String triggerButtonId, String align, boolean singleClick, boolean weekNumbers, boolean mondayFirst, String dateStatusFunc, boolean showTime) {
        StringBuffer result = new StringBuffer(512);
        if (CmsStringUtil.isEmpty(align)) {
            align = "Bc";
        }
        result.append("<script type=\"text/javascript\">\n");
        result.append("<!--\n");
        result.append("\tCalendar.setup({\n");
        result.append("\t\tinputField     :    \"");
        result.append(inputFieldId);
        result.append("\",\n");
        result.append("\t\tifFormat       :    \"");
        result.append(messages.key("GUI_CALENDAR_DATE_FORMAT_0"));
        if (showTime) {
            result.append(" ");
            result.append(messages.key("GUI_CALENDAR_TIME_FORMAT_0"));
        }
        result.append("\",\n");
        result.append("\t\tbutton         :    \"");
        result.append(triggerButtonId);
        result.append("\",\n");
        result.append("\t\talign          :    \"");
        result.append(align);
        result.append("\",\n");
        result.append("\t\tsingleClick    :    ");
        result.append(singleClick);
        result.append(",\n");
        result.append("\t\tweekNumbers    :    ");
        result.append(weekNumbers);
        result.append(",\n");
        result.append("\t\tmondayFirst    :    ");
        result.append(mondayFirst);
        result.append(",\n");
        result.append("\t\tshowsTime      :    " + showTime);
        if (showTime && messages.key("GUI_CALENDAR_TIMEFORMAT_0").toLowerCase().indexOf("p") != -1) {
            result.append(",\n\t\ttimeFormat     :    \"12\"");
        }
        if (CmsStringUtil.isNotEmpty(dateStatusFunc)) {
            result.append(",\n\t\tdateStatusFunc :    ");
            result.append(dateStatusFunc);
        }
        result.append("\n\t});\n");
        result.append("//-->\n");
        result.append("</script>\n");
        return result.toString();
    }

    public static long getCalendarDate(CmsMessages messages, String dateString, boolean useTime) throws ParseException {
        long dateLong = 0L;
        String dateFormat = messages.key("GUI_CALENDAR_DATE_FORMAT_0");
        if (useTime) {
            dateFormat = dateFormat + " " + messages.key("GUI_CALENDAR_TIME_FORMAT_0");
        }
        dateFormat = CmsCalendarWidget.getCalendarJavaDateFormat(dateFormat);
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        dateLong = df.parse(dateString).getTime();
        return dateLong;
    }

    public static String getCalendarJavaDateFormat(String dateFormat) {
        dateFormat = CmsStringUtil.substitute(dateFormat, "%", "");
        dateFormat = CmsStringUtil.substitute(dateFormat, "m", "${month}");
        dateFormat = CmsStringUtil.substitute(dateFormat, "H", "${hour}");
        dateFormat = CmsStringUtil.substitute(dateFormat, "Y", "${4anno}");
        dateFormat = dateFormat.toLowerCase();
        dateFormat = CmsStringUtil.substitute(dateFormat, "${month}", "M");
        dateFormat = CmsStringUtil.substitute(dateFormat, "${hour}", "H");
        dateFormat = CmsStringUtil.substitute(dateFormat, "y", "yy");
        dateFormat = CmsStringUtil.substitute(dateFormat, "${4anno}", "yyyy");
        dateFormat = CmsStringUtil.substitute(dateFormat, "m", "mm");
        dateFormat = dateFormat.replace('e', 'd');
        dateFormat = dateFormat.replace('i', 'h');
        dateFormat = dateFormat.replace('p', 'a');
        return dateFormat;
    }

    public static String getCalendarLocalizedTime(Locale locale, CmsMessages messages, long timestamp) {
        TimeZone zone = TimeZone.getDefault();
        GregorianCalendar cal = new GregorianCalendar(zone, locale);
        cal.setTimeInMillis(timestamp);
        SimpleDateFormat df = new SimpleDateFormat(CmsCalendarWidget.getCalendarJavaDateFormat(messages.key("GUI_CALENDAR_DATE_FORMAT_0") + " " + messages.key("GUI_CALENDAR_TIME_FORMAT_0")));
        return df.format(cal.getTime());
    }

    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return CmsCalendarWidget.calendarIncludes(widgetDialog.getLocale());
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(16);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
        result.append("<input class=\"xmlInputSmall");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        String dateTimeValue = this.getWidgetStringValue(cms, widgetDialog, param);
        result.append(dateTimeValue);
        String id = param.getId();
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td>");
        result.append("<table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" id=\"");
        result.append(id);
        result.append(".calendar\"><tr>");
        result.append(widgetDialog.button("#", null, "calendar", "GUI_CALENDAR_CHOOSE_DATE_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append(CmsCalendarWidget.calendarInit(widgetDialog.getMessages(), id, id + ".calendar", "cR", false, false, true, null, true));
        result.append("</td>");
        return result.toString();
    }

    public String getWidgetStringValue(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String result = param.getStringValue(cms);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(result) && !"0".equals(result)) {
            try {
                result = CmsCalendarWidget.getCalendarLocalizedTime(widgetDialog.getLocale(), widgetDialog.getMessages(), Long.parseLong(result));
            }
            catch (NumberFormatException e) {
                if (!CmsMacroResolver.isMacro(result, "currenttime")) {
                    result = "";
                }
            }
        } else {
            result = "";
        }
        return result;
    }

    public I_CmsWidget newInstance() {
        return new CmsCalendarWidget(this.getConfiguration());
    }

    public void setEditorValue(CmsObject cms, Map formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = (String[])formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            String dateTimeValue = values[0].trim();
            if (CmsMacroResolver.isMacro(dateTimeValue, "currenttime")) {
                param.setStringValue(cms, dateTimeValue);
            } else {
                long dateTime;
                try {
                    dateTime = Long.valueOf(param.getStringValue(cms));
                }
                catch (NumberFormatException e) {
                    dateTime = 0L;
                }
                if (CmsStringUtil.isNotEmpty(dateTimeValue)) {
                    try {
                        dateTime = CmsCalendarWidget.getCalendarDate(widgetDialog.getMessages(), dateTimeValue, true);
                    }
                    catch (ParseException e) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)Messages.get().getBundle().key("ERR_PARSE_DATETIME_1", dateTimeValue), (Throwable)e);
                        }
                    }
                } else {
                    dateTime = 0L;
                }
                param.setStringValue(cms, String.valueOf(dateTime));
            }
        }
    }
}

