/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategoryService;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCategoryWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.editors.CmsXmlContentWidgetVisitor;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsCategoryXmlContentHandler
extends CmsDefaultXmlContentHandler {
    private static final Log LOG = CmsLog.getLog(CmsCategoryXmlContentHandler.class);

    public static Locale getDefaultLocale(CmsObject cms, String resource) {
        Locale locale = OpenCms.getLocaleManager().getDefaultLocale(cms, resource);
        if (locale == null) {
            List locales = OpenCms.getLocaleManager().getAvailableLocales();
            locale = locales.size() > 0 ? (Locale)locales.get(0) : Locale.ENGLISH;
        }
        return locale;
    }

    public CmsFile prepareForWrite(CmsObject cms, CmsXmlContent content, CmsFile file) throws CmsException {
        super.prepareForWrite(cms, content, file);
        if (!CmsWorkplace.isTemporaryFile(file)) {
            String folderPath = cms.getRequestContext().removeSiteRoot(CmsResource.getFolderPath(file.getRootPath()));
            String tmpName = CmsWorkplace.getTemporaryFileName(file.getName());
            if (cms.existsResource(folderPath + tmpName, CmsResourceFilter.ALL)) {
                List listsib = cms.readSiblings(cms.getSitePath(file), CmsResourceFilter.ALL);
                for (int i = 0; i < listsib.size(); ++i) {
                    CmsResource resource = (CmsResource)listsib.get(i);
                    try {
                        Locale locale = CmsCategoryXmlContentHandler.getDefaultLocale(cms, cms.getSitePath(resource));
                        this.resetCategories(cms, resource);
                        this.setCategories(cms, content, resource, locale);
                        continue;
                    }
                    catch (CmsException ex) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
            }
        }
        return file;
    }

    public CmsXmlContentErrorHandler resolveValidation(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        CmsXmlContentErrorHandler handler;
        block10: {
            I_CmsWidget widget;
            block9: {
                handler = super.resolveValidation(cms, value, errorHandler);
                if (!value.isSimpleType()) {
                    return handler;
                }
                widget = null;
                try {
                    widget = value.getContentDefinition().getContentHandler().getWidget(value);
                }
                catch (CmsXmlException e) {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (widget instanceof CmsCategoryWidget) {
                String stringValue = value.getStringValue(cms);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(stringValue)) {
                    errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_CATEGORY_CHECK_EMPTY_ERROR_0"));
                    return handler;
                }
                if (((CmsCategoryWidget)widget).isOnlyLeafs()) {
                    try {
                        if (!cms.getSubFolders(stringValue).isEmpty()) {
                            errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_CATEGORY_CHECK_NOLEAF_ERROR_0"));
                        }
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block10;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
        return handler;
    }

    protected List getCategories(CmsXmlContent content, Locale locale) {
        ArrayList categories = new ArrayList();
        CmsXmlContentWidgetVisitor widgetCollector = new CmsXmlContentWidgetVisitor(locale);
        content.visitAllValuesWith(widgetCollector);
        Iterator itWidgets = widgetCollector.getValues().entrySet().iterator();
        while (itWidgets.hasNext()) {
            Map.Entry entry = itWidgets.next();
            String xpath = (String)entry.getKey();
            I_CmsWidget widget = (I_CmsWidget)widgetCollector.getWidgets().get(xpath);
            if (!(widget instanceof CmsCategoryWidget)) continue;
            categories.add(entry.getValue());
        }
        return categories;
    }

    protected void resetCategories(CmsObject cms, CmsResource resource) throws CmsException {
        CmsRelationFilter filter = CmsRelationFilter.TARGETS;
        filter = filter.filterType(CmsRelationType.CATEGORY);
        filter = filter.filterResource(cms.readResource("/system/categories/"));
        filter = filter.filterIncludeChildren();
        cms.deleteRelationsFromResource(cms.getSitePath(resource), filter);
    }

    protected void setCategories(CmsObject cms, CmsXmlContent content, CmsResource resource, Locale locale) throws CmsException {
        Iterator itCats = this.getCategories(content, locale).iterator();
        while (itCats.hasNext()) {
            I_CmsXmlContentValue value = (I_CmsXmlContentValue)itCats.next();
            String category = value.getStringValue(cms);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(category)) continue;
            CmsCategoryService.getInstance().addResourceToCategory(cms, cms.getSitePath(resource), value.getStringValue(cms).substring("/system/categories".length()));
        }
    }
}

