/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.types.CmsXmlColorValue;

public class CmsColorpickerWidget
extends A_CmsWidget {
    public CmsColorpickerWidget() {
        this("");
    }

    public CmsColorpickerWidget(String configuration) {
        super(configuration);
    }

    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/colorpicker.js");
    }

    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "\tinitColorPicker();\n";
    }

    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(128);
        result.append("function initColorPicker() {\n");
        result.append("\tcolorPicker.title = \"");
        result.append(Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_DIALOG_COLOR_TITLE_0"));
        result.append("\";\n");
        result.append("\tcolorPicker.url=\"");
        result.append(CmsWorkplace.getSkinUri());
        result.append("components/js_colorpicker/index.html\";\n");
        result.append("}\n");
        return result.toString();
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(16);
        result.append("<td class=\"xmlTd\">");
        String colorValue = param.getStringValue(cms);
        String id = param.getId();
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
        result.append("<input type=\"text\"");
        result.append(" class=\"xmlInputSmall\" name=\"");
        result.append(id);
        result.append("\" value=\"");
        result.append(colorValue);
        result.append("\" maxlength=\"19\" onkeyup=\"previewColor('");
        result.append(id);
        result.append("');\"");
        result.append(" style=\"background-color: ");
        result.append(this.checkColor(colorValue));
        result.append("; color: ");
        result.append(this.getInputFontColor(colorValue));
        result.append(";\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button("javascript:showColorPicker('" + id + "');", null, "color_fill", "GUI_BUTTON_COLOR_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        return result.toString();
    }

    public I_CmsWidget newInstance() {
        return new CmsColorpickerWidget(this.getConfiguration());
    }

    public void setEditorValue(CmsObject cms, Map formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = (String[])formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            CmsXmlColorValue castValue = (CmsXmlColorValue)param;
            String castColorValue = castValue.getStringValue(cms);
            String colorValue = values[0].trim();
            if (CmsStringUtil.isNotEmpty(colorValue)) {
                castColorValue = colorValue;
            }
            param.setStringValue(cms, String.valueOf(castColorValue));
        }
    }

    private String checkColor(String color) {
        if (color != null) {
            int colLength;
            if (color.indexOf("#") == -1) {
                color = "#" + color;
            }
            if ((colLength = color.length()) == 4 || colLength == 7) {
                return color;
            }
        }
        return "#FFFFFF";
    }

    private String getInputFontColor(String backgroundColor) {
        if (backgroundColor != null && backgroundColor.indexOf("#") == 0) {
            backgroundColor = backgroundColor.substring(1);
            int colorValue = 50001;
            try {
                colorValue = Integer.parseInt(backgroundColor, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (colorValue < 50000) {
                return "#FFFFFF";
            }
            return "#000000";
        }
        return "#000000";
    }
}

