/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsHtmlWidget;
import org.opencms.widgets.CmsHtmlWidgetOption;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;

public class CmsHtmlWidget
extends A_CmsHtmlWidget {
    private static final Log LOG = CmsLog.getLog(CmsHtmlWidget.class);
    private I_CmsWidget m_editorWidget;

    public CmsHtmlWidget() {
        this("");
    }

    public CmsHtmlWidget(CmsHtmlWidgetOption configuration) {
        super(configuration);
    }

    public CmsHtmlWidget(String configuration) {
        super(configuration);
    }

    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogIncludes(cms, widgetDialog);
    }

    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogInitCall(cms, widgetDialog);
    }

    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return this.getEditorWidget(cms, widgetDialog).getDialogInitMethod(cms, widgetDialog);
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        return this.getEditorWidget(cms, widgetDialog).getDialogWidget(cms, widgetDialog, param);
    }

    public I_CmsWidget newInstance() {
        return new CmsHtmlWidget(this.getConfiguration());
    }

    public void setEditorValue(CmsObject cms, Map formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = (String[])formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            String val = CmsEncoder.decode(values[0], "UTF-8");
            param.setStringValue(cms, val);
        }
    }

    private I_CmsWidget getEditorWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        if (this.m_editorWidget == null) {
            String widgetClassName = OpenCms.getWorkplaceManager().getWorkplaceEditorManager().getWidgetEditor(cms.getRequestContext(), widgetDialog.getUserAgent());
            boolean foundWidget = true;
            if (CmsStringUtil.isEmpty(widgetClassName)) {
                widgetClassName = CmsTextareaWidget.class.getName();
                foundWidget = false;
            }
            try {
                if (foundWidget) {
                    Class<?> widgetClass = Class.forName(widgetClassName);
                    A_CmsHtmlWidget editorWidget = (A_CmsHtmlWidget)widgetClass.newInstance();
                    editorWidget.setHtmlWidgetOption(this.getHtmlWidgetOption());
                    this.m_editorWidget = editorWidget;
                } else {
                    Class<?> widgetClass = Class.forName(widgetClassName);
                    I_CmsWidget editorWidget = (I_CmsWidget)widgetClass.newInstance();
                    editorWidget.setConfiguration("15");
                    this.m_editorWidget = editorWidget;
                }
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().container("LOG_CREATE_HTMLWIDGET_INSTANCE_FAILED_1", widgetClassName).key());
            }
        }
        return this.m_editorWidget;
    }
}

