/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsHtmlWidgetOption {
    public static final String EDITOR_DEFAULTHEIGHT = "260px";
    public static final String OPTION_ANCHOR = "anchor";
    public static final String OPTION_CSS = "css:";
    public static final String OPTION_DELIMITER = ",";
    public static final String OPTION_FORMATSELECT = "formatselect";
    public static final String OPTION_FULLPAGE = "fullpage";
    public static final String OPTION_HEIGHT = "height:";
    public static final String OPTION_IMAGE = "image";
    public static final String OPTION_LINK = "link";
    public static final String OPTION_SOURCE = "source";
    public static final String OPTION_STYLES = "stylesxml:";
    public static final String OPTION_TABLE = "table";
    private String m_cssPath;
    private List m_displayGalleries = new ArrayList();
    private String m_editorHeight = "260px";
    private boolean m_fullPage;
    private boolean m_showAnchorDialog;
    private boolean m_showFormatSelect;
    private boolean m_showImageDialog;
    private boolean m_showLinkDialog;
    private boolean m_showSourceEditor;
    private boolean m_showTableDialog;
    private String m_stylesXmlPath;

    public CmsHtmlWidgetOption() {
    }

    public CmsHtmlWidgetOption(String configuration) {
        this.parseOptions(configuration);
    }

    public static String createConfigurationString(CmsHtmlWidgetOption option) {
        StringBuffer result = new StringBuffer(512);
        boolean added = false;
        if (!option.getEditorHeight().equals(EDITOR_DEFAULTHEIGHT)) {
            result.append(OPTION_HEIGHT);
            result.append(option.getEditorHeight());
            added = true;
        }
        if (option.showAnchorDialog()) {
            if (added) {
                result.append(OPTION_DELIMITER);
            }
            result.append(OPTION_ANCHOR);
            added = true;
        }
        if (option.showLinkDialog()) {
            if (added) {
                result.append(OPTION_DELIMITER);
            }
            result.append(OPTION_LINK);
            added = true;
        }
        if (option.showFormatSelect()) {
            if (added) {
                result.append(OPTION_DELIMITER);
            }
            result.append(OPTION_FORMATSELECT);
            added = true;
        }
        if (option.showSourceEditor()) {
            if (added) {
                result.append(OPTION_DELIMITER);
            }
            result.append(OPTION_SOURCE);
            added = true;
        }
        if (option.showTableDialog()) {
            if (added) {
                result.append(OPTION_DELIMITER);
            }
            result.append(OPTION_TABLE);
            added = true;
        }
        if (option.showImageDialog()) {
            if (added) {
                result.append(OPTION_DELIMITER);
            }
            result.append(OPTION_IMAGE);
            added = true;
        }
        if (option.useCss()) {
            if (added) {
                result.append(OPTION_DELIMITER);
            }
            result.append(OPTION_CSS);
            result.append(option.getCssPath());
            added = true;
        }
        if (option.showStylesXml()) {
            if (added) {
                result.append(OPTION_DELIMITER);
            }
            result.append(OPTION_STYLES);
            result.append(option.getStylesXmlPath());
            added = true;
        }
        boolean isFirst = true;
        for (int i = 0; i < option.getDisplayGalleries().size(); ++i) {
            String gallery = (String)option.getDisplayGalleries().get(i);
            if (added || !isFirst) {
                result.append(OPTION_DELIMITER);
            }
            result.append(gallery);
            isFirst = false;
        }
        return result.toString();
    }

    public String getCssPath() {
        return this.m_cssPath;
    }

    public List getDisplayGalleries() {
        return this.m_displayGalleries;
    }

    public String getEditorHeight() {
        return this.m_editorHeight;
    }

    public String getStylesXmlPath() {
        return this.m_stylesXmlPath;
    }

    public boolean isFullPage() {
        return this.m_fullPage;
    }

    public void setCssPath(String cssPath) {
        this.m_cssPath = cssPath;
    }

    public void setDisplayGalleries(List displayGalleries) {
        this.m_displayGalleries = displayGalleries;
    }

    public void setEditorHeight(String editorHeight) {
        this.m_editorHeight = editorHeight;
    }

    public void setFullPage(boolean fullPage) {
        this.m_fullPage = fullPage;
    }

    public void setShowAnchorDialog(boolean showAnchorDialog) {
        this.m_showAnchorDialog = showAnchorDialog;
    }

    public void setShowFormatSelect(boolean showFormatSelect) {
        this.m_showFormatSelect = showFormatSelect;
    }

    public void setShowImageDialog(boolean showImageDialog) {
        this.m_showImageDialog = showImageDialog;
    }

    public void setShowLinkDialog(boolean showLinkDialog) {
        this.m_showLinkDialog = showLinkDialog;
    }

    public void setShowSourceEditor(boolean showSourceEditor) {
        this.m_showSourceEditor = showSourceEditor;
    }

    public void setShowTableDialog(boolean showTableDialog) {
        this.m_showTableDialog = showTableDialog;
    }

    public void setStylesXmlPath(String stylesXmlPath) {
        this.m_stylesXmlPath = stylesXmlPath;
    }

    public boolean showAnchorDialog() {
        return this.m_showAnchorDialog;
    }

    public boolean showFormatSelect() {
        return this.m_showFormatSelect;
    }

    public boolean showGalleryDialog(String galleryType) {
        return this.getDisplayGalleries().contains(galleryType);
    }

    public boolean showImageDialog() {
        return this.m_showImageDialog;
    }

    public boolean showLinkDialog() {
        return this.m_showLinkDialog;
    }

    public boolean showSourceEditor() {
        return this.m_showSourceEditor;
    }

    public boolean showStylesXml() {
        return CmsStringUtil.isNotEmpty(this.getStylesXmlPath());
    }

    public boolean showTableDialog() {
        return this.m_showTableDialog;
    }

    public boolean useCss() {
        return CmsStringUtil.isNotEmpty(this.getCssPath());
    }

    protected void parseOptions(String configuration) {
        if (CmsStringUtil.isNotEmpty(configuration)) {
            List options = CmsStringUtil.splitAsList(configuration, OPTION_DELIMITER, true);
            Iterator i = options.iterator();
            while (i.hasNext()) {
                String option = (String)i.next();
                if (OPTION_LINK.equals(option)) {
                    this.setShowLinkDialog(true);
                    continue;
                }
                if (OPTION_ANCHOR.equals(option)) {
                    this.setShowAnchorDialog(true);
                    continue;
                }
                if (OPTION_SOURCE.equals(option)) {
                    this.setShowSourceEditor(true);
                    continue;
                }
                if (OPTION_FORMATSELECT.equals(option)) {
                    this.setShowFormatSelect(true);
                    continue;
                }
                if (OPTION_FULLPAGE.equals(option)) {
                    this.setFullPage(true);
                    continue;
                }
                if (OPTION_IMAGE.equals(option)) {
                    this.setShowImageDialog(true);
                    continue;
                }
                if (OPTION_TABLE.equals(option)) {
                    this.setShowTableDialog(true);
                    continue;
                }
                if (option.startsWith(OPTION_HEIGHT)) {
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(option = option.substring(OPTION_HEIGHT.length()))) continue;
                    this.setEditorHeight(option);
                    continue;
                }
                if (option.startsWith(OPTION_CSS)) {
                    option = option.substring(OPTION_CSS.length());
                    this.setCssPath(option);
                    continue;
                }
                if (option.startsWith(OPTION_STYLES)) {
                    option = option.substring(OPTION_STYLES.length());
                    this.setStylesXmlPath(option);
                    continue;
                }
                if (OpenCms.getWorkplaceManager().getGalleries().get(option) == null) continue;
                this.m_displayGalleries.add(option);
            }
        }
    }
}

