/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.widgets.A_CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

public class CmsMultiSelectWidget
extends A_CmsSelectWidget {
    private boolean m_asCheckBoxes;

    public CmsMultiSelectWidget() {
    }

    public CmsMultiSelectWidget(List configuration) {
        this(configuration, false);
    }

    public CmsMultiSelectWidget(List configuration, boolean asCheckboxes) {
        super(configuration);
        this.m_asCheckBoxes = asCheckboxes;
    }

    public CmsMultiSelectWidget(String configuration) {
        super(configuration);
    }

    public void setEditorValue(CmsObject cms, Map formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = (String[])formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            StringBuffer value = new StringBuffer(128);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    value.append(',');
                }
                value.append(values[i]);
            }
            param.setStringValue(cms, value.toString());
        }
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        List options = this.parseSelectOptions(cms, widgetDialog, param);
        result.append("<td class=\"xmlTd\">");
        if (!this.m_asCheckBoxes) {
            result.append("<select multiple size='");
            result.append(options.size());
            result.append("' class=\"xmlInput");
            if (param.hasError()) {
                result.append(" xmlInputError");
            }
            result.append("\" name=\"");
            result.append(id);
            result.append("\" id=\"");
            result.append(id);
            result.append("\">");
        }
        List selected = this.getSelectedValues(cms, param);
        Iterator i = options.iterator();
        while (i.hasNext()) {
            CmsSelectWidgetOption option = (CmsSelectWidgetOption)i.next();
            if (!this.m_asCheckBoxes) {
                result.append("<option value=\"");
                result.append(option.getValue());
                result.append("\"");
                if (selected.contains(option.getValue())) {
                    result.append(" selected=\"selected\"");
                }
                result.append(">");
                result.append(option.getOption());
                result.append("</option>");
                continue;
            }
            result.append("<input type='checkbox' name='");
            result.append(id);
            result.append("' value='");
            result.append(option.getValue());
            result.append("'");
            if (selected.contains(option.getValue())) {
                result.append(" checked");
            }
            result.append(">");
            result.append(option.getOption());
            result.append("<br>");
        }
        if (!this.m_asCheckBoxes) {
            result.append("</select>");
        }
        result.append("</td>");
        return result.toString();
    }

    public I_CmsWidget newInstance() {
        return new CmsMultiSelectWidget(this.getConfiguration());
    }
}

