/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;

public class CmsVfsFileWidget
extends A_CmsWidget {
    public static final String CONFIGURATION_EXCLUDEFILES = "excludefiles";
    public static final String CONFIGURATION_HIDESITESELECTOR = "hidesiteselector";
    public static final String CONFIGURATION_INCLUDEFILES = "includefiles";
    public static final String CONFIGURATION_NOTPROJECTAWARE = "notprojectaware";
    public static final String CONFIGURATION_PROJECTAWARE = "projectaware";
    public static final String CONFIGURATION_SHOWSITESELECTOR = "showsiteselector";
    public static final String CONFIGURATION_STARTSITE = "startsite";
    private boolean m_includeFiles;
    private boolean m_projectAware;
    private boolean m_showSiteSelector;
    private String m_startSite;

    public CmsVfsFileWidget() {
        this("");
    }

    public CmsVfsFileWidget(boolean showSiteSelector, String startSite) {
        this(showSiteSelector, startSite, true);
    }

    public CmsVfsFileWidget(boolean showSiteSelector, String startSite, boolean includeFiles) {
        this(showSiteSelector, startSite, includeFiles, true);
    }

    public CmsVfsFileWidget(boolean showSiteSelector, String startSite, boolean includeFiles, boolean projectAware) {
        this.m_showSiteSelector = showSiteSelector;
        this.m_startSite = startSite;
        this.m_includeFiles = includeFiles;
        this.m_projectAware = projectAware;
    }

    public CmsVfsFileWidget(String configuration) {
        super(configuration);
    }

    public String getConfiguration() {
        StringBuffer result = new StringBuffer(8);
        if (this.m_showSiteSelector) {
            result.append(CONFIGURATION_SHOWSITESELECTOR);
        } else {
            result.append(CONFIGURATION_HIDESITESELECTOR);
        }
        if (this.m_startSite != null) {
            result.append("|");
            result.append(CONFIGURATION_STARTSITE);
            result.append("=");
            result.append(this.m_startSite);
        }
        result.append("|");
        if (this.m_includeFiles) {
            result.append(CONFIGURATION_INCLUDEFILES);
        } else {
            result.append(CONFIGURATION_EXCLUDEFILES);
        }
        result.append("|");
        if (this.m_projectAware) {
            result.append(CONFIGURATION_PROJECTAWARE);
        } else {
            result.append(CONFIGURATION_NOTPROJECTAWARE);
        }
        return result.toString();
    }

    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "commons/tree.js"));
        result.append("\n");
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/fileselector.js"));
        return result.toString();
    }

    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "\tinitVfsFileSelector();\n";
    }

    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append("function initVfsFileSelector() {\n");
        result.append("\tinitResources(\"");
        result.append(OpenCms.getWorkplaceManager().getEncoding());
        result.append("\", \"");
        result.append("/system/workplace/");
        result.append("\", \"");
        result.append(CmsWorkplace.getSkinUri());
        result.append("\", \"");
        result.append(OpenCms.getSystemInfo().getOpenCmsContext());
        result.append("\");\n");
        result.append("}\n");
        return result.toString();
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(128);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\"><tr><td style=\"width: 100%;\">");
        result.append("<input style=\"width: 99%;\" class=\"xmlInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        result.append(param.getStringValue(cms));
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        StringBuffer buttonJs = new StringBuffer(8);
        buttonJs.append("javascript:openTreeWin('EDITOR',  '");
        buttonJs.append(id);
        buttonJs.append("', document, ");
        buttonJs.append(this.m_showSiteSelector);
        buttonJs.append(", '");
        if (this.m_startSite != null) {
            buttonJs.append(this.m_startSite);
        } else {
            buttonJs.append(cms.getRequestContext().getSiteRoot());
        }
        buttonJs.append("', ");
        buttonJs.append(this.m_includeFiles);
        buttonJs.append(", ");
        buttonJs.append(this.m_projectAware);
        buttonJs.append(");return false;");
        result.append(widgetDialog.button(buttonJs.toString(), null, "folder", "GUI_DIALOG_BUTTON_SEARCH_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        return result.toString();
    }

    public String getStartSite() {
        return this.m_startSite;
    }

    public boolean isShowingSiteSelector() {
        return this.m_showSiteSelector;
    }

    public I_CmsWidget newInstance() {
        return new CmsVfsFileWidget(this.getConfiguration());
    }

    public void setConfiguration(String configuration) {
        this.m_showSiteSelector = true;
        this.m_includeFiles = true;
        this.m_projectAware = true;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            int siteIndex;
            if (configuration.indexOf(CONFIGURATION_HIDESITESELECTOR) != -1) {
                this.m_showSiteSelector = false;
            }
            if ((siteIndex = configuration.indexOf(CONFIGURATION_STARTSITE)) != -1) {
                String site = configuration.substring(CONFIGURATION_STARTSITE.length() + 1);
                if (site.indexOf(124) != -1) {
                    site = site.substring(0, site.indexOf(124));
                }
                this.m_startSite = site;
            }
            if (configuration.indexOf(CONFIGURATION_EXCLUDEFILES) != -1) {
                this.m_includeFiles = false;
            }
            if (configuration.indexOf(CONFIGURATION_NOTPROJECTAWARE) != -1) {
                this.m_projectAware = false;
            }
        }
        super.setConfiguration(configuration);
    }
}

