/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplace;

public class CmsWorkplaceMessages
extends CmsMultiMessages {
    public static final String GUI_NEW_RESOURCE_TITLE_PREFIX = "title.new";
    public static final String GUI_RESOURCE_TYPE_PREFIX = "fileicon.";
    public static final String PREFIX_BUNDLE_MESSAGES = ".messages";
    public static final String PREFIX_BUNDLE_WORKPLACE = ".workplace";
    public static final String WORKPLACE_BUNDLE_NAME = CmsWorkplaceMessages.class.getName();

    public CmsWorkplaceMessages(Locale locale) {
        super(locale);
        this.setBundleName(WORKPLACE_BUNDLE_NAME);
        this.addMessages(CmsWorkplaceMessages.collectModuleMessages(locale));
    }

    public static String getNewResourceTitle(CmsWorkplace wp, String name) {
        String title = wp.key(GUI_NEW_RESOURCE_TITLE_PREFIX + name.toLowerCase());
        if (CmsMessages.isUnknownKey(title)) {
            title = wp.key("GUI_TITLE_NEWFILEOTHER_0");
        }
        return title;
    }

    public static String getResourceName(CmsWorkplace wp, String name) {
        return wp.keyDefault(GUI_RESOURCE_TYPE_PREFIX + name, name);
    }

    private static List collectModuleMessages(Locale locale) {
        ArrayList<CmsMessages> result = new ArrayList<CmsMessages>();
        Set names = OpenCms.getModuleManager().getModuleNames();
        if (names != null) {
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String modName = (String)i.next();
                String bundleName = modName + PREFIX_BUNDLE_WORKPLACE;
                CmsMessages msg = new CmsMessages(bundleName, locale);
                if (msg.isInitialized()) {
                    result.add(msg);
                }
                if (!(msg = new CmsMessages(bundleName = modName + PREFIX_BUNDLE_MESSAGES, locale)).isInitialized()) continue;
                result.add(msg);
            }
        }
        I_CmsMessageBundle[] coreMsgs = A_CmsMessageBundle.getOpenCmsMessageBundles();
        for (int i = 0; i < coreMsgs.length; ++i) {
            I_CmsMessageBundle bundle = coreMsgs[i];
            result.add(bundle.getBundle(locale));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsWorkplaceMessages) {
            CmsMessages other = (CmsMessages)obj;
            return other.getLocale().equals(this.getLocale());
        }
        return false;
    }

    public int hashCode() {
        return this.getLocale().hashCode();
    }
}

