/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.lang.reflect.Constructor;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.I_CmsWidget;

public final class CmsWorkplaceUserInfoEntry {
    private final String m_key;
    private final String m_optional;
    private final String m_widget;
    private String m_type;
    private String m_params;

    public CmsWorkplaceUserInfoEntry(String key, String type, String widget, String params, String optional) {
        this.m_key = key;
        this.m_type = type;
        this.m_widget = widget;
        this.m_params = params;
        this.m_optional = optional;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getWidget() {
        return this.m_widget;
    }

    public I_CmsWidget getWidgetObject() {
        if (this.getWidget() == null) {
            if (this.m_params == null) {
                return new CmsInputWidget();
            }
            return new CmsInputWidget(this.m_params);
        }
        try {
            if (this.m_params == null) {
                return (I_CmsWidget)Class.forName(this.getWidget()).newInstance();
            }
            Class<?> clazz = Class.forName(this.getWidget());
            Constructor<?> ctor = clazz.getConstructor(String.class);
            return (I_CmsWidget)ctor.newInstance(this.m_params);
        }
        catch (Exception e) {
            return new CmsInputWidget();
        }
    }

    public String getOptional() {
        return this.m_optional;
    }

    public boolean isOptional() {
        return Boolean.valueOf(this.m_optional);
    }

    public String getParams() {
        return this.m_params;
    }

    public String getType() {
        return this.m_type;
    }

    public Class getClassType() {
        if (this.m_type == null) {
            return String.class;
        }
        try {
            return Class.forName(this.m_type);
        }
        catch (ClassNotFoundException e) {
            return String.class;
        }
    }
}

