/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsAvailability
extends CmsMultiDialog {
    public static final String DIALOG_TYPE = "availability";
    public static final String PARAM_ENABLE_NOTIFICATION = "enablenotification";
    public static final String PARAM_EXPIREDATE = "expiredate";
    public static final String PARAM_LEAVEEXPIRE = "leaveexpire";
    public static final String PARAM_LEAVERELEASE = "leaverelease";
    public static final String PARAM_MODIFY_SIBLINGS = "modifysiblings";
    public static final String PARAM_NOTIFICATION_INTERVAL = "notificationinterval";
    public static final String PARAM_RECURSIVE = "recursive";
    public static final String PARAM_RELEASEDATE = "releasedate";
    public static final String PARAM_RESETEXPIRE = "resetexpire";
    public static final String PARAM_RESETRELEASE = "resetrelease";
    private static final Log LOG = CmsLog.getLog(CmsAvailability.class);
    private String m_paramEnablenotification;
    private String m_paramExpiredate;
    private String m_paramLeaveexpire;
    private String m_paramModifysiblings;
    private String m_paramNotificationinterval;
    private String m_paramRecursive;
    private String m_paramReleasedate;
    private String m_paramResetexpire;
    private String m_paramResetrelease;

    public CmsAvailability(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsAvailability(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCloseDialog() throws JspException {
        this.getSettings().getFrameUris().put("body", "/system/workplace/views/explorer/explorer_fs.jsp");
        super.actionCloseDialog();
    }

    public void actionUpdate() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            if (this.performDialogOperation()) {
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public String buildCheckboxEnableNotification() {
        String propVal;
        block5: {
            propVal = null;
            if (!this.isMultiOperation()) {
                try {
                    propVal = this.getCms().readPropertyObject(this.getParamResource(), "enable-notification", false).getValue();
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block5;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
        }
        if (CmsStringUtil.isEmpty(propVal)) {
            propVal = CmsStringUtil.FALSE;
        }
        StringBuffer result = new StringBuffer(512);
        result.append("<input type=\"checkbox\" style=\"text-align:left\" name=\"");
        result.append(PARAM_ENABLE_NOTIFICATION);
        if (Boolean.valueOf(propVal).booleanValue()) {
            result.append("\" checked=\"checked");
        }
        result.append("\" value=\"true\">");
        return result.toString();
    }

    public String buildCheckboxModifySiblings() {
        StringBuffer result;
        block3: {
            result = new StringBuffer(254);
            try {
                if (this.isMultiOperation() || this.getCms().readSiblings(this.getParamResource(), CmsResourceFilter.ALL).size() > 1) {
                    result.append("<tr>\n<td style=\"white-space:nowrap;\">");
                    result.append(this.key("GUI_AVAILABILITY_MODIFY_SIBLINGS_0"));
                    result.append("</td>\n<td class=\"maxwidth\" style=\"padding-left: 5px;\">\n");
                    result.append("<input type=\"checkbox\" name=\"");
                    result.append(PARAM_MODIFY_SIBLINGS);
                    result.append("\" value=\"true\" style=\"text-align:left\">\n</td>\n<td>&nbsp</td></tr>");
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block3;
                LOG.info((Object)e);
            }
        }
        return result.toString();
    }

    public String buildCheckRecursive() {
        StringBuffer result = new StringBuffer(256);
        if (this.isOperationOnFolder()) {
            result.append(this.dialogBlockStart(this.key("GUI_AVAILABILITY_NOTIFICATION_SUBRES_0")));
            result.append("<table border=\"0\">");
            result.append("<tr>\n\t<td style=\"white-space:nowrap;\">");
            result.append(this.key("GUI_TOUCH_MODIFY_SUBRESOURCES_0"));
            result.append("</td><td class=\"maxwidth\" style=\"padding-left: 5px;\"><input type=\"checkbox\" style=\"text-align:left\" name=\"");
            result.append(PARAM_RECURSIVE);
            result.append("\" value=\"true\">&nbsp;</td>\n<td>&nbsp</td></tr>\n");
            result.append("</table>");
            result.append(this.dialogBlockEnd());
            result.append(this.dialogSpacer());
        }
        return result.toString();
    }

    public String buildInputNotificationInterval() {
        String propVal;
        block4: {
            propVal = null;
            if (!this.isMultiOperation()) {
                try {
                    propVal = this.getCms().readPropertyObject(this.getParamResource(), "notification-interval", false).getValue();
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block4;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
        }
        if (CmsStringUtil.isEmpty(propVal)) {
            propVal = "";
        }
        StringBuffer result = new StringBuffer();
        result.append("<input class=\"maxwidth\" type=\"text\" name=\"");
        result.append(PARAM_NOTIFICATION_INTERVAL);
        result.append("\" value=\"");
        result.append(propVal);
        result.append("\">");
        return result.toString();
    }

    public String buildResponsibleList() {
        I_CmsPrincipal principal;
        String resourceSitePath;
        CmsObject cms;
        HashMap<I_CmsPrincipal, String> responsibles;
        List parentResources;
        StringBuffer result;
        block13: {
            if (this.isMultiOperation()) {
                return "";
            }
            result = new StringBuffer(512);
            result.append("<tr><td colspan=\"3\">");
            parentResources = new ArrayList();
            responsibles = new HashMap<I_CmsPrincipal, String>();
            cms = this.getCms();
            resourceSitePath = cms.getRequestContext().removeSiteRoot(this.getParamResource());
            try {
                parentResources = cms.readPath(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block13;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        Iterator i = parentResources.iterator();
        while (i.hasNext()) {
            CmsResource resource = (CmsResource)i.next();
            try {
                String sitePath = cms.getRequestContext().removeSiteRoot(resource.getRootPath());
                Iterator entries = cms.getAccessControlEntries(sitePath, false).iterator();
                while (entries.hasNext()) {
                    CmsAccessControlEntry ace = (CmsAccessControlEntry)entries.next();
                    if (!ace.isResponsible() || (principal = cms.lookupPrincipal(ace.getPrincipal())) == null) continue;
                    responsibles.put(principal, resourceSitePath.equals(sitePath) ? null : sitePath);
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        if (responsibles.size() == 0) {
            result.append(this.key("GUI_AVAILABILITY_NO_RESPONSIBLES_0"));
        } else {
            result.append(this.dialogToggleStart(this.key("GUI_AVAILABILITY_RESPONSIBLES_0"), "responsibles", false));
            ArrayList parentFolders = new ArrayList(responsibles.values());
            parentFolders.remove(null);
            if (parentFolders.size() > 0) {
                result.append("<table border=\"0\">\n<tr>\n\t<td>");
                result.append(this.key("GUI_PERMISSION_SELECT_VIEW_0"));
                result.append("</td>\n<td><input type=\"button\" onclick=\"toggleInheritInfo();\" value=\"");
                result.append(this.key("GUI_LABEL_DETAILS_0"));
                result.append("\" id=\"button\"/></td></tr></table>");
            }
            result.append(this.dialogWhiteBoxStart());
            Iterator it = responsibles.entrySet().iterator();
            int j = 0;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                principal = (I_CmsPrincipal)entry.getKey();
                String image = "user.png";
                String localizedType = this.getLocalizedType(16);
                if (principal instanceof CmsGroup) {
                    image = "group.png";
                    localizedType = this.getLocalizedType(32);
                }
                result.append("<div class=\"dialogrow\"><img src=\"");
                result.append(CmsAvailability.getSkinUri());
                result.append("commons/");
                result.append(image);
                result.append("\" class=\"noborder\" width=\"16\" height=\"16\" alt=\"");
                result.append(localizedType);
                result.append("\" title=\"");
                result.append(localizedType);
                result.append("\">&nbsp;<span class=\"textbold\">");
                result.append(principal.getName());
                result.append("</span><div class=\"hide\" id=\"inheritinfo");
                result.append(j);
                result.append("\"><div class=\"dialogpermissioninherit\">");
                String resourceName = (String)entry.getValue();
                if (CmsStringUtil.isNotEmpty(resourceName)) {
                    result.append(this.key("GUI_PERMISSION_INHERITED_FROM_1", new Object[]{resourceName}));
                }
                result.append("</div></div></div>\n");
                ++j;
            }
            result.append(this.dialogWhiteBoxEnd());
            result.append("</div>\n");
            result.append("</td></tr>");
        }
        return result.toString();
    }

    public String getCurrentDateTime() {
        return CmsCalendarWidget.getCalendarLocalizedTime(this.getLocale(), this.getMessages(), System.currentTimeMillis());
    }

    public String getCurrentExpireDate() {
        if (this.isMultiOperation()) {
            return "-";
        }
        try {
            CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
            if (res.getDateExpired() == Long.MAX_VALUE) {
                return "-";
            }
            return CmsCalendarWidget.getCalendarLocalizedTime(this.getLocale(), this.getMessages(), res.getDateExpired());
        }
        catch (CmsException e) {
            return CmsCalendarWidget.getCalendarLocalizedTime(this.getLocale(), this.getMessages(), System.currentTimeMillis());
        }
    }

    public String getCurrentReleaseDate() {
        if (this.isMultiOperation()) {
            return "-";
        }
        try {
            CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
            if (res.getDateReleased() == 0L) {
                return "-";
            }
            return CmsCalendarWidget.getCalendarLocalizedTime(this.getLocale(), this.getMessages(), res.getDateReleased());
        }
        catch (CmsException e) {
            return CmsCalendarWidget.getCalendarLocalizedTime(this.getLocale(), this.getMessages(), System.currentTimeMillis());
        }
    }

    public String getParamEnablenotification() {
        return this.m_paramEnablenotification;
    }

    public String getParamExpiredate() {
        return this.m_paramExpiredate;
    }

    public String getParamLeaveexpire() {
        return this.m_paramLeaveexpire;
    }

    public String getParamModifysiblings() {
        return this.m_paramModifysiblings;
    }

    public String getParamNotificationinterval() {
        return this.m_paramNotificationinterval;
    }

    public String getParamRecursive() {
        return this.m_paramRecursive;
    }

    public String getParamReleasedate() {
        return this.m_paramReleasedate;
    }

    public String getParamResetexpire() {
        return this.m_paramResetexpire;
    }

    public String getParamResetrelease() {
        return this.m_paramResetrelease;
    }

    public void setParamEnablenotification(String value) {
        this.m_paramEnablenotification = value;
    }

    public void setParamExpiredate(String value) {
        this.m_paramExpiredate = value;
    }

    public void setParamLeaveexpire(String paramLeaveexpire) {
        this.m_paramLeaveexpire = paramLeaveexpire;
    }

    public void setParamModifysiblings(String value) {
        this.m_paramModifysiblings = value;
    }

    public void setParamNotificationinterval(String value) {
        this.m_paramNotificationinterval = value;
    }

    public void setParamRecursive(String value) {
        this.m_paramRecursive = value;
    }

    public void setParamReleasedate(String value) {
        this.m_paramReleasedate = value;
    }

    public void setParamResetexpire(String paramResetexpire) {
        this.m_paramResetexpire = paramResetexpire;
    }

    public void setParamResetrelease(String paramResetrelease) {
        this.m_paramResetrelease = paramResetrelease;
    }

    protected String getLocalizedType(int flags) {
        if ((flags & 0x10) > 0) {
            return this.key("GUI_LABEL_USER_0");
        }
        return this.key("GUI_LABEL_GROUP_0");
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setDialogTitle("GUI_AVAILABILITY_NOTIFICATION_SETTINGS_1", "GUI_AVAILABILITY_NOTIFICATION_MULTI_2");
        }
    }

    protected boolean performDialogOperation() throws CmsException {
        boolean isFolder = this.isOperationOnFolder();
        if ((this.isMultiOperation() || isFolder) && !"wait".equals(this.getParamAction())) {
            return false;
        }
        long releaseDate = 0L;
        boolean resetReleaseDate = Boolean.valueOf(this.getParamResetrelease());
        boolean leaveReleaseDate = false;
        if (!resetReleaseDate) {
            try {
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamReleasedate()) && !this.getParamReleasedate().startsWith("-")) {
                    releaseDate = CmsCalendarWidget.getCalendarDate(this.getMessages(), this.getParamReleasedate(), true);
                } else {
                    leaveReleaseDate = true;
                }
            }
            catch (ParseException e) {
                throw new CmsException(Messages.get().container("ERR_PARSE_RELEASEDATE_1", this.getParamReleasedate()), (Throwable)e);
            }
        }
        long expireDate = Long.MAX_VALUE;
        boolean resetExpireDate = Boolean.valueOf(this.getParamResetexpire());
        boolean leaveExpireDate = false;
        if (!resetExpireDate) {
            try {
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamExpiredate()) && !this.getParamExpiredate().startsWith("-")) {
                    expireDate = CmsCalendarWidget.getCalendarDate(this.getMessages(), this.getParamExpiredate(), true);
                } else {
                    leaveExpireDate = true;
                }
            }
            catch (ParseException e) {
                throw new CmsException(Messages.get().container("ERR_PARSE_EXPIREDATE_1", this.getParamExpiredate()), (Throwable)e);
            }
        }
        boolean modifyRecursive = Boolean.valueOf(this.getParamRecursive());
        Iterator i = this.getResourceList().iterator();
        while (i.hasNext()) {
            String resName = (String)i.next();
            try {
                this.performSingleResourceAvailability(resName, releaseDate, expireDate, leaveReleaseDate, leaveExpireDate, modifyRecursive);
            }
            catch (CmsException e) {
                this.addMultiOperationException(e);
            }
        }
        boolean notificationEnabled = Boolean.valueOf(this.getParamEnablenotification());
        int notificationInterval = 0;
        try {
            notificationInterval = Integer.parseInt(this.getParamNotificationinterval());
        }
        catch (Throwable e) {
            // empty catch block
        }
        boolean modifySiblings = Boolean.valueOf(this.getParamModifysiblings());
        i = this.getResourceList().iterator();
        while (i.hasNext()) {
            String resName = (String)i.next();
            try {
                this.performSingleResourceNotification(resName, notificationEnabled, notificationInterval, modifySiblings);
            }
            catch (CmsException e) {
                this.addMultiOperationException(e);
            }
        }
        this.checkMultiOperationException(Messages.get(), "ERR_AVAILABILITY_MULTI_0");
        return true;
    }

    protected void performSingleResourceAvailability(String resName, long releaseDate, long expireDate, boolean leaveRelease, boolean leaveExpire, boolean modifyRecursive) throws CmsException {
        CmsResource resource = this.getCms().readResource(resName, CmsResourceFilter.IGNORE_EXPIRATION);
        if (leaveRelease) {
            releaseDate = resource.getDateReleased();
        }
        if (leaveExpire) {
            expireDate = resource.getDateExpired();
        }
        if (expireDate < releaseDate) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_AVAILABILITY_BAD_TIMEWINDOW_0"));
        }
        String resourcePath = this.getCms().getSitePath(resource);
        this.checkLock(resourcePath);
        if (!leaveRelease) {
            this.getCms().setDateReleased(resourcePath, releaseDate, modifyRecursive);
        }
        if (!leaveExpire) {
            this.getCms().setDateExpired(resourcePath, expireDate, modifyRecursive);
        }
    }

    protected void performSingleResourceNotification(String resName, boolean enableNotification, int notificationInterval, boolean modifySiblings) throws CmsException {
        List resources = new ArrayList<CmsResource>();
        if (modifySiblings) {
            resources = this.getCms().readSiblings(resName, CmsResourceFilter.IGNORE_EXPIRATION);
        } else {
            resources.add(this.getCms().readResource(resName, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            CmsResource resource = (CmsResource)i.next();
            String resourcePath = this.getCms().getRequestContext().removeSiteRoot(resource.getRootPath());
            this.checkLock(resourcePath);
            this.writeProperty(resourcePath, "notification-interval", String.valueOf(notificationInterval));
            this.writeProperty(resourcePath, "enable-notification", String.valueOf(enableNotification));
        }
    }

    protected void writeProperty(String resourcePath, String propertyName, String propertyValue) throws CmsException {
        if (CmsStringUtil.isEmpty(propertyValue)) {
            propertyValue = "";
        }
        CmsProperty newProp = new CmsProperty();
        newProp.setName(propertyName);
        CmsProperty oldProp = this.getCms().readPropertyObject(resourcePath, propertyName, false);
        if (oldProp.isNullProperty()) {
            if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                newProp.setStructureValue(propertyValue);
            } else {
                newProp.setResourceValue(propertyValue);
            }
        } else if (oldProp.getStructureValue() != null) {
            newProp.setStructureValue(propertyValue);
            newProp.setResourceValue(oldProp.getResourceValue());
        } else {
            newProp.setResourceValue(propertyValue);
        }
        newProp.setAutoCreatePropertyDefinition(true);
        String oldStructureValue = oldProp.getStructureValue();
        String newStructureValue = newProp.getStructureValue();
        if (CmsStringUtil.isEmpty(oldStructureValue)) {
            oldStructureValue = "";
        }
        if (CmsStringUtil.isEmpty(newStructureValue)) {
            newStructureValue = "";
        }
        String oldResourceValue = oldProp.getResourceValue();
        String newResourceValue = newProp.getResourceValue();
        if (CmsStringUtil.isEmpty(oldResourceValue)) {
            oldResourceValue = "";
        }
        if (CmsStringUtil.isEmpty(newResourceValue)) {
            newResourceValue = "";
        }
        if (!oldResourceValue.equals(newResourceValue) || !oldStructureValue.equals(newStructureValue)) {
            this.getCms().writePropertyObject(resourcePath, newProp);
        }
    }
}

