/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsLog;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListResourceCollector;
import org.opencms.workplace.list.CmsListItem;

public class CmsLockedResourcesCollector
extends A_CmsListResourceCollector {
    public static final String COLLECTOR_NAME = "lockedResources";
    private static final int FLAG_RELATED_RESOURCE = 8192;
    private static final Log LOG = CmsLog.getLog(CmsLockedResourcesCollector.class);

    public CmsLockedResourcesCollector(A_CmsListExplorerDialog wp, List resources) {
        super(wp);
        this.setResourcesParam(resources);
    }

    public List getCollectorNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(COLLECTOR_NAME);
        return names;
    }

    public List getResources(CmsObject cms, Map params) {
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        Iterator itResourceNames = this.getResourceNamesFromParam(params).iterator();
        while (itResourceNames.hasNext()) {
            String resName = (String)itResourceNames.next();
            boolean relatedResource = resName.endsWith("*");
            if (relatedResource) {
                resName = resName.substring(0, resName.length() - 1);
            }
            try {
                CmsResource resource = cms.readResource(resName, CmsResourceFilter.ALL);
                if (relatedResource) {
                    resource = new CmsResource(resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), resource.getTypeId(), resource.isFolder(), resource.getFlags() | 0x2000, resource.getProjectLastModified(), resource.getState(), resource.getDateCreated(), resource.getUserCreated(), resource.getDateLastModified(), resource.getUserLastModified(), resource.getDateReleased(), resource.getDateExpired(), resource.getSiblingCount(), resource.getLength(), resource.getDateContent(), resource.getVersion());
                }
                resources.add(resource);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return resources;
    }

    protected void setAdditionalColumns(CmsListItem item, CmsResourceUtil resUtil) {
        item.set("ecir", (resUtil.getResource().getFlags() & 0x2000) == 8192);
    }
}

