/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.opencms.db.CmsDbSqlException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsReplace
extends CmsDialog {
    public static final String DIALOG_TYPE = "replace";
    public static final String PARAM_UPLOADFILE = "uploadfile";

    public CmsReplace(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsReplace(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionReplace() throws JspException {
        try {
            Iterator i = this.getMultiPartFileItems().iterator();
            FileItem fi = null;
            while (i.hasNext() && (fi = (FileItem)i.next()).getName() == null) {
            }
            if (fi != null) {
                long size = fi.getSize();
                long maxFileSizeBytes = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCms());
                if (maxFileSizeBytes > 0L && size > maxFileSizeBytes) {
                    throw new CmsException(Messages.get().container("ERR_FILE_SIZE_TOO_LARGE_1", new Long(maxFileSizeBytes / 1024L)));
                }
                byte[] content = fi.get();
                fi.delete();
                CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
                CmsFile file = this.getCms().readFile(res);
                byte[] contents = file.getContents();
                int resTypeId = res.getTypeId();
                this.checkLock(this.getParamResource());
                try {
                    this.getCms().replaceResource(this.getParamResource(), resTypeId, content, null);
                }
                catch (CmsDbSqlException sqlExc) {
                    file.setContents(contents);
                    this.getCms().writeFile(file);
                    throw sqlExc;
                }
            } else {
                throw new CmsException(Messages.get().container("ERR_UPLOAD_FILE_NOT_FOUND_0"));
            }
            this.actionCloseDialog();
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_REPLACE_FILE_1", new Object[]{CmsResource.getName(this.getParamResource())}));
        }
    }
}

