/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.relations.CmsCategory;
import org.opencms.workplace.commons.A_CmsResourceCategoriesList;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;

public class CmsResourceCategoriesList
extends A_CmsResourceCategoriesList {
    public static final String LIST_ACTION_REMOVE = "ar";
    public static final String LIST_ID = "lrc";
    public static final String LIST_MACTION_REMOVE = "mr";

    public CmsResourceCategoriesList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsResourceCategoriesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsResourceCategoriesList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_RESOURCECATEGORIES_LIST_NAME_0"), true);
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_ACTION_REMOVE)) {
            try {
                this.checkLock(this.getParamResource());
                CmsListItem listItem = this.getSelectedItem();
                String categoryPath = listItem.getId();
                this.getCategoryService().removeResourceFromCategory(this.getCms(), this.getParamResource(), categoryPath);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected String defaultActionHtmlStart() {
        return this.getList().listJs() + this.dialogContentStart(this.getParamTitle());
    }

    protected List getCategories() throws CmsException {
        return this.getResourceCategories();
    }

    protected void setStateActionCol(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_CATEGORIES_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_CATEGORIES_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_REMOVE){

            /*
             * WARNING - void declaration
             */
            public CmsMessageContainer getConfirmationMessage() {
                void var1_1;
                try {
                    Iterator itCategories = ((A_CmsResourceCategoriesList)this.getWp()).getResourceCategories().iterator();
                }
                catch (CmsException e) {
                    e.printStackTrace();
                    return super.getConfirmationMessage();
                }
                while (var1_1.hasNext()) {
                    CmsCategory category = (CmsCategory)var1_1.next();
                    try {
                        if (!((A_CmsResourceCategoriesList)this.getWp()).getResourceCategories().containsAll(((A_CmsResourceCategoriesList)this.getWp()).getCategoryService().readSubCategories(this.getWp().getCms(), category.getPath(), true))) continue;
                        return Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_CONF_MORE_0");
                    }
                    catch (CmsException e) {
                        return super.getConfirmationMessage();
                    }
                }
                return super.getConfirmationMessage();
            }
        };
        stateAction.setName(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_HELP_0"));
        stateAction.setIconPath("list/minus.png");
        stateAction.setConfirmationMessage(Messages.get().container("GUI_CATEGORIES_LIST_DEFACTION_REMOVE_CONF_SINGLE_0"));
        stateCol.addDirectAction(stateAction);
        metadata.addColumn(stateCol);
    }
}

