/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.security.CmsPermissionSet;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsUndelete
extends CmsMultiDialog {
    public static final int ACTION_UNDELETE = 100;
    public static final String DIALOG_TYPE = "undelete";

    public CmsUndelete(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsUndelete(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionUndelete() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            if (this.performDialogOperation()) {
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public String buildConfirmationMessage() {
        if (this.isMultiOperation()) {
            return this.key("GUI_UNDELETE_MULTI_CONFIRMATION_0");
        }
        return this.key("GUI_UNDELETE_CONFIRMATION_0");
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else {
            this.setAction(0);
            this.setDialogTitle("GUI_UNDELETE_RESOURCE_1", "GUI_UNDELETE_MULTI_2");
        }
    }

    protected boolean performDialogOperation() throws CmsException {
        boolean isFolder = this.isOperationOnFolder();
        if ((this.isMultiOperation() || isFolder) && !"wait".equals(this.getParamAction())) {
            return false;
        }
        Iterator i = this.getResourceList().iterator();
        while (i.hasNext()) {
            String resName = (String)i.next();
            try {
                this.checkLock(resName);
                this.getCms().undeleteResource(resName, true);
            }
            catch (CmsException e) {
                if (this.isMultiOperation()) {
                    this.addMultiOperationException(e);
                    continue;
                }
                throw e;
            }
        }
        this.checkMultiOperationException(Messages.get(), "ERR_UNDELETE_MULTI_0");
        return true;
    }
}

