/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDefaultJsAction;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.tools.CmsToolMacroResolver;

public class CmsUserSelectionList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_SELECT = "js";
    public static final String LIST_COLUMN_FULLNAME = "cf";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_LOGIN = "cn";
    public static final String LIST_ID = "lus";
    private String m_paramFlags;
    private String m_paramGroup;

    public CmsUserSelectionList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_USERSELECTION_LIST_NAME_0"), LIST_COLUMN_LOGIN, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_LOGIN);
    }

    public CmsUserSelectionList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String dialogTitle() {
        StringBuffer html = new StringBuffer(512);
        html.append("<div class='screenTitle'>\n");
        html.append("\t<table width='100%' cellspacing='0'>\n");
        html.append("\t\t<tr>\n");
        html.append("\t\t\t<td>\n");
        String param = "";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamGroup())) {
            param = Messages.get().getBundle(this.getLocale()).key("GUI_USERSELECTION_GROUP_BLOCK_1", this.getParamGroup());
        }
        html.append(this.key("GUI_USERSELECTION_INTRO_TITLE_1", new Object[]{param}));
        html.append("\n\t\t\t</td>");
        html.append("\t\t</tr>\n");
        html.append("\t</table>\n");
        html.append("</div>\n");
        return CmsToolMacroResolver.resolveMacros(html.toString(), this);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public String getParamFlags() {
        return this.m_paramFlags;
    }

    public String getParamGroup() {
        return this.m_paramGroup;
    }

    public void setParamFlags(String flags) {
        this.m_paramFlags = flags;
    }

    public void setParamGroup(String groupName) {
        this.m_paramGroup = groupName;
    }

    protected void fillDetails(String detailId) {
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List users = this.getUsers();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsUser user = (CmsUser)itUsers.next();
            CmsListItem item = this.getList().newItem(user.getId().toString());
            item.set(LIST_COLUMN_LOGIN, user.getName());
            item.set(LIST_COLUMN_FULLNAME, user.getFullName());
            ret.add(item);
        }
        return ret;
    }

    protected List getUsers() throws CmsException {
        ArrayList ret = new ArrayList();
        if (this.getParamGroup() != null) {
            ret.addAll(this.getCms().getUsersOfGroup(this.getParamGroup()));
        } else {
            ret.addAll(OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true));
        }
        if (this.getParamFlags() != null) {
            int flags = Integer.parseInt(this.getParamFlags());
            return CmsPrincipal.filterFlag(ret, flags);
        }
        return ret;
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_USERSELECTION_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_USERSELECTION_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON);
        iconAction.setName(Messages.get().container("GUI_USERSELECTION_LIST_ICON_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_USERSELECTION_LIST_ICON_HELP_0"));
        iconAction.setIconPath("buttons/user.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction(iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition loginCol = new CmsListColumnDefinition(LIST_COLUMN_LOGIN);
        loginCol.setName(Messages.get().container("GUI_USERSELECTION_LIST_COLS_LOGIN_0"));
        loginCol.setWidth("60%");
        A_CmsListDefaultJsAction selectAction = new A_CmsListDefaultJsAction(LIST_ACTION_SELECT){

            public String jsCode() {
                return "window.opener.setUserFormValue('" + this.getItem().get(CmsUserSelectionList.LIST_COLUMN_LOGIN) + "'); window.opener.focus(); window.close();";
            }
        };
        selectAction.setName(Messages.get().container("GUI_USERSELECTION_LIST_ACTION_SELECT_NAME_0"));
        selectAction.setHelpText(Messages.get().container("GUI_USERSELECTION_LIST_ACTION_SELECT_HELP_0"));
        loginCol.addDefaultAction(selectAction);
        metadata.addColumn(loginCol);
        CmsListColumnDefinition fullnameCol = new CmsListColumnDefinition(LIST_COLUMN_FULLNAME);
        fullnameCol.setName(Messages.get().container("GUI_USERSELECTION_LIST_COLS_FULLNAME_0"));
        fullnameCol.setWidth("40%");
        fullnameCol.setTextWrapping(true);
        metadata.addColumn(fullnameCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void validateParamaters() throws Exception {
        try {
            this.getCms().readGroup(this.getParamGroup()).getName();
        }
        catch (Exception e) {
            this.setParamGroup(null);
        }
        try {
            Integer.valueOf(this.getParamFlags());
        }
        catch (Throwable e) {
            this.setParamFlags(null);
        }
    }
}

