/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.CmsEditor;
import org.opencms.workplace.editors.I_CmsEditorActionHandler;

public class CmsEditorActionDefault
implements I_CmsEditorActionHandler {
    public void editorAction(CmsEditor editor, CmsJspActionElement jsp) throws IOException, JspException {
        editor.actionSave();
        editor.actionClear(true);
        String publishLink = jsp.link("/system/workplace/commons/publishresource.jsp");
        StringBuffer params = new StringBuffer(64);
        params.append("?resource=");
        params.append(editor.getParamResource());
        params.append("&action=");
        params.append("confirmed");
        params.append("&directpublish=true&publishsiblings=true");
        params.append("&title=");
        params.append(CmsEncoder.escapeWBlanks(editor.key("GUI_MESSAGEBOX_TITLE_PUBLISHRESOURCE_0") + ": " + editor.getParamResource(), "UTF-8"));
        params.append("&").append("redirect").append("=").append(CmsStringUtil.TRUE);
        params.append("&closelink=");
        if (Boolean.valueOf(editor.getParamDirectedit()).booleanValue()) {
            String linkTarget = !"".equals(editor.getParamBacklink()) ? jsp.link(editor.getParamBacklink()) : jsp.link(editor.getParamResource());
            publishLink = publishLink + params.toString() + CmsEncoder.escapeWBlanks(linkTarget, "UTF-8");
        } else {
            publishLink = publishLink + params.toString() + CmsEncoder.escapeWBlanks(jsp.link("/system/workplace/views/workplace.jsp"), "UTF-8");
        }
        jsp.getResponse().sendRedirect(publishLink);
    }

    public String getButtonName() {
        return "GUI_EXPLORER_CONTEXT_PUBLISH_0";
    }

    public String getButtonUrl(CmsJspActionElement jsp, String resourceName) {
        String button = "/system/workplace/resources/buttons/publish.png";
        if (!this.isButtonActive(jsp, resourceName)) {
            button = "/system/workplace/resources/buttons/publish_in.png";
        }
        return jsp.link(button);
    }

    public boolean isButtonActive(CmsJspActionElement jsp, String resourceName) {
        try {
            OpenCms.getPublishManager().getPublishList(jsp.getCmsObject(), jsp.getCmsObject().readResource(resourceName, CmsResourceFilter.IGNORE_EXPIRATION), false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

