/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceException;
import org.opencms.workplace.editors.I_CmsEditorHandler;
import org.opencms.workplace.editors.Messages;

public class CmsEditorSelector {
    private static final Log LOG = CmsLog.getLog(CmsEditorSelector.class);
    private CmsJspActionElement m_jsp;
    private String m_paramResource;

    public CmsEditorSelector(CmsJspActionElement jsp) {
        this.setJsp(jsp);
        this.setParamResource(jsp.getRequest().getParameter("resource"));
    }

    private static void showErrorDialog(CmsJspActionElement jsp, Throwable t) {
        CmsDialog wp = new CmsDialog(jsp);
        wp.setParamMessage(Messages.get().getBundle(wp.getLocale()).key("ERR_NO_EDITOR_FOUND_0"));
        wp.fillParamValues(jsp.getRequest());
        try {
            wp.includeErrorpage(wp, t);
        }
        catch (JspException e) {
            LOG.debug((Object)org.opencms.workplace.commons.Messages.get().getBundle().key("LOG_ERROR_INCLUDE_FAILED_1", "/system/workplace/commons/includes/errorpage.jsp"), (Throwable)e);
        }
    }

    public String getSelectedEditorUri() {
        I_CmsEditorHandler editorClass = OpenCms.getWorkplaceManager().getEditorHandler();
        String resource = this.getParamResource();
        resource = CmsEncoder.unescape(resource, "UTF-8");
        if (editorClass == null) {
            return "/system/workplace/views/explorer/explorer_files.jsp";
        }
        String editorUri = null;
        try {
            editorUri = editorClass.getEditorUri(resource, this.getJsp());
            if (editorUri == null) {
                throw new CmsWorkplaceException(Messages.get().container("ERR_NO_EDITOR_FOUND_0"));
            }
        }
        catch (CmsException e) {
            CmsEditorSelector.showErrorDialog(this.getJsp(), e);
        }
        return editorUri;
    }

    private CmsJspActionElement getJsp() {
        return this.m_jsp;
    }

    private String getParamResource() {
        return this.m_paramResource;
    }

    private void setJsp(CmsJspActionElement jsp) {
        this.m_jsp = jsp;
    }

    private void setParamResource(String resource) {
        this.m_paramResource = resource;
    }
}

