/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.CmsWorkplaceEditorConfiguration;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsWorkplaceEditorManager {
    public static final String EDITOR_CONFIGURATION_FILENAME = "editor_configuration.xml";
    public static final String EDITOR_FILENAME = "editor.jsp";
    private static final Log LOG = CmsLog.getLog(CmsWorkplaceEditorManager.class);
    private List m_editorConfigurations;
    private Map m_preferredEditors;

    public CmsWorkplaceEditorManager(CmsObject cms) {
        ArrayList editorFolders;
        try {
            editorFolders = cms.getSubFolders("/system/workplace/editors/");
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READ_EDITIR_FOLDER_FAILED_1", "/system/workplace/editors/"));
            editorFolders = new ArrayList();
        }
        this.m_editorConfigurations = new ArrayList(editorFolders.size());
        Iterator i = editorFolders.iterator();
        while (i.hasNext()) {
            CmsFolder currentFolder = (CmsFolder)i.next();
            String folderName = "/system/workplace/editors/" + currentFolder.getName();
            if (!folderName.endsWith("/")) {
                folderName = folderName + "/";
            }
            CmsFile configFile = null;
            try {
                configFile = cms.readFile(folderName + EDITOR_CONFIGURATION_FILENAME, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)e);
                continue;
            }
            byte[] xmlData = configFile.getContents();
            CmsWorkplaceEditorConfiguration editorConfig = new CmsWorkplaceEditorConfiguration(xmlData, folderName + EDITOR_FILENAME);
            if (!editorConfig.isValidConfiguration()) continue;
            this.m_editorConfigurations.add(editorConfig);
        }
        this.m_preferredEditors = new HashMap(this.m_editorConfigurations.size());
    }

    public Map getConfigurableEditors() {
        HashMap<String, TreeMap<Float, CmsWorkplaceEditorConfiguration>> configurableEditors = new HashMap<String, TreeMap<Float, CmsWorkplaceEditorConfiguration>>();
        Iterator i = this.m_editorConfigurations.iterator();
        while (i.hasNext()) {
            CmsWorkplaceEditorConfiguration currentConfig = (CmsWorkplaceEditorConfiguration)i.next();
            Iterator k = currentConfig.getResourceTypes().keySet().iterator();
            while (k.hasNext()) {
                String key = (String)k.next();
                CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(key);
                if (settings == null || CmsStringUtil.isNotEmpty(settings.getReference()) || currentConfig.getMappingForResourceType(key) != null) continue;
                TreeMap<Float, CmsWorkplaceEditorConfiguration> editorConfigs = (TreeMap<Float, CmsWorkplaceEditorConfiguration>)configurableEditors.get(key);
                if (editorConfigs == null) {
                    editorConfigs = new TreeMap<Float, CmsWorkplaceEditorConfiguration>();
                }
                editorConfigs.put(new Float(currentConfig.getRankingForResourceType(key)), currentConfig);
                configurableEditors.put(key, editorConfigs);
            }
        }
        return configurableEditors;
    }

    public String getWidgetEditor(CmsRequestContext context, String userAgent) {
        CmsWorkplaceEditorConfiguration preferredConf;
        String resourceType;
        CmsUserSettings settings = new CmsUserSettings(context.currentUser());
        String preferredEditorSetting = settings.getPreferredEditor(resourceType = CmsResourceTypeXmlPage.getStaticTypeName());
        if (preferredEditorSetting == null) {
            Iterator i = this.m_editorConfigurations.iterator();
            while (i.hasNext()) {
                CmsWorkplaceEditorConfiguration currentConfig = (CmsWorkplaceEditorConfiguration)i.next();
                String mapping = currentConfig.getMappingForResourceType(resourceType);
                if (mapping != null) {
                    preferredEditorSetting = settings.getPreferredEditor(mapping);
                }
                if (preferredEditorSetting == null) continue;
                break;
            }
        }
        if (preferredEditorSetting != null && (preferredConf = this.filterPreferredEditor(preferredEditorSetting)) != null && preferredConf.isWidgetEditor() && preferredConf.matchesBrowser(userAgent)) {
            return preferredConf.getWidgetEditor();
        }
        SortedMap filteredEditors = this.filterEditorsForResourceType(resourceType);
        while (filteredEditors.size() > 0) {
            Float key = (Float)filteredEditors.lastKey();
            CmsWorkplaceEditorConfiguration conf = (CmsWorkplaceEditorConfiguration)filteredEditors.get(key);
            if (conf.isWidgetEditor() && conf.matchesBrowser(userAgent)) {
                return conf.getWidgetEditor();
            }
            filteredEditors.remove(key);
        }
        return null;
    }

    protected String getDefaultEditorUri(CmsRequestContext context, String resourceType, String userAgent) {
        SortedMap filteredEditors = this.filterEditorsForResourceType(resourceType);
        while (filteredEditors.size() > 0) {
            Float key = (Float)filteredEditors.firstKey();
            CmsWorkplaceEditorConfiguration conf = (CmsWorkplaceEditorConfiguration)filteredEditors.get(key);
            if (conf.matchesBrowser(userAgent)) {
                return conf.getEditorUri();
            }
            filteredEditors.remove(key);
        }
        if (context == null) {
            return null;
        }
        return null;
    }

    protected List getEditorConfigurations() {
        return this.m_editorConfigurations;
    }

    protected String getEditorUri(CmsRequestContext context, String resourceType, String userAgent) {
        CmsWorkplaceEditorConfiguration preferredConf;
        CmsUserSettings settings = new CmsUserSettings(context.currentUser());
        String preferredEditorSetting = settings.getPreferredEditor(resourceType);
        if (preferredEditorSetting == null) {
            Iterator i = this.m_editorConfigurations.iterator();
            while (i.hasNext()) {
                CmsWorkplaceEditorConfiguration currentConfig = (CmsWorkplaceEditorConfiguration)i.next();
                String mapping = currentConfig.getMappingForResourceType(resourceType);
                if (mapping != null) {
                    preferredEditorSetting = settings.getPreferredEditor(mapping);
                }
                if (preferredEditorSetting == null) continue;
                break;
            }
        }
        if (preferredEditorSetting != null && (preferredConf = this.filterPreferredEditor(preferredEditorSetting)) != null && preferredConf.matchesBrowser(userAgent)) {
            return preferredConf.getEditorUri();
        }
        SortedMap filteredEditors = this.filterEditorsForResourceType(resourceType);
        while (filteredEditors.size() > 0) {
            Float key = (Float)filteredEditors.lastKey();
            CmsWorkplaceEditorConfiguration conf = (CmsWorkplaceEditorConfiguration)filteredEditors.get(key);
            if (conf.matchesBrowser(userAgent)) {
                return conf.getEditorUri();
            }
            filteredEditors.remove(key);
        }
        return null;
    }

    private SortedMap filterEditorsForResourceType(String resourceType) {
        TreeMap<Float, CmsWorkplaceEditorConfiguration> filteredEditors = new TreeMap<Float, CmsWorkplaceEditorConfiguration>();
        Iterator i = this.m_editorConfigurations.iterator();
        while (i.hasNext()) {
            float key;
            CmsWorkplaceEditorConfiguration currentConfig = (CmsWorkplaceEditorConfiguration)i.next();
            if (!currentConfig.matchesResourceType(resourceType) || !((key = currentConfig.getRankingForResourceType(resourceType)) >= 0.0f)) continue;
            filteredEditors.put(new Float(key), currentConfig);
        }
        return filteredEditors;
    }

    private CmsWorkplaceEditorConfiguration filterPreferredEditor(String preferredEditor) {
        if (this.m_preferredEditors.size() == 0) {
            Iterator i = this.m_editorConfigurations.iterator();
            while (i.hasNext()) {
                CmsWorkplaceEditorConfiguration currentConfig = (CmsWorkplaceEditorConfiguration)i.next();
                this.m_preferredEditors.put(currentConfig.getEditorUri(), currentConfig);
            }
        }
        return (CmsWorkplaceEditorConfiguration)this.m_preferredEditors.get(preferredEditor);
    }
}

