/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.galleries.A_CmsGallery;
import org.opencms.workplace.list.I_CmsListResourceCollector;

public class CmsExplorer
extends CmsWorkplace {
    public static final String PARAMETER_MODE = "mode";
    public static final String VIEW_EXPLORER = "explorerview";
    public static final String VIEW_GALLERY = "galleryview";
    public static final String VIEW_LIST = "listview";
    private static final Log LOG = CmsLog.getLog(CmsExplorer.class);
    private static final String PARAMETER_FLATURL = "flaturl";
    private static final String PARAMETER_PAGE = "page";
    private static final String PARAMETER_RESOURCE = "resource";
    private static final String PARAMETER_URI = "uri";
    private String m_uri;

    public CmsExplorer(CmsJspActionElement jsp) {
        super(jsp);
    }

    public String getExplorerBodyUri() {
        String body = "explorer_body_fs.jsp";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_uri)) {
            body = body + "?uri=" + this.m_uri;
        }
        return this.getJsp().link(body);
    }

    public String getExplorerFilesUri() {
        String body = "explorer_files.jsp?mode=explorerview";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_uri)) {
            body = this.m_uri;
        }
        return this.getJsp().link(body);
    }

    public String getFileList() {
        CmsProject referenceProject;
        int preferences;
        boolean galleryView = VIEW_GALLERY.equals(this.getSettings().getExplorerMode());
        boolean listView = VIEW_LIST.equals(this.getSettings().getExplorerMode());
        String currentFolder = this.getSettings().getExplorerResource();
        try {
            this.getCms().readResource(currentFolder, CmsResourceFilter.ALL);
        }
        catch (CmsException e) {
            currentFolder = "/";
        }
        StringBuffer content = new StringBuffer(2048);
        content.append(this.getInitializationHeader());
        List resources = this.getResources(this.getSettings().getExplorerResource());
        int startat = 0;
        int stopat = resources.size();
        int selectedPage = 1;
        int numberOfPages = 0;
        int maxEntrys = this.getSettings().getUserSettings().getExplorerFileEntries();
        if (!galleryView) {
            selectedPage = this.getSettings().getExplorerPage();
            if (stopat > maxEntrys) {
                numberOfPages = (stopat - 1) / maxEntrys + 1;
                if (selectedPage > numberOfPages) {
                    selectedPage = 1;
                }
                if ((startat = (selectedPage - 1) * maxEntrys) + maxEntrys < stopat) {
                    stopat = startat + maxEntrys;
                }
            }
        }
        boolean showTitle = ((preferences = this.getUserPreferences()) & 1) > 0;
        boolean showNavText = (preferences & 0x40) > 0;
        boolean showPermissions = (preferences & 0x80) > 0;
        boolean showDateLastModified = (preferences & 4) > 0;
        boolean showUserWhoLastModified = (preferences & 0x800) > 0;
        boolean showDateCreated = (preferences & 0x400) > 0;
        boolean showUserWhoCreated = (preferences & 0x20) > 0;
        boolean showDateReleased = (preferences & 0x1000) > 0;
        boolean showDateExpired = (preferences & 0x2000) > 0;
        boolean fullPath = galleryView || listView;
        try {
            referenceProject = !listView ? this.getCms().readProject(this.getSettings().getProject()) : this.getCms().readProject(this.getSettings().getExplorerProjectId());
        }
        catch (CmsException ex) {
            referenceProject = this.getCms().getRequestContext().currentProject();
        }
        CmsResourceUtil resUtil = new CmsResourceUtil(this.getCms());
        resUtil.setReferenceProject(referenceProject);
        for (int i = startat; i < stopat; ++i) {
            CmsResource res = (CmsResource)resources.get(i);
            resUtil.setResource(res);
            content.append(this.getInitializationEntry(resUtil, fullPath, showTitle, showNavText, showPermissions, showDateLastModified, showUserWhoLastModified, showDateCreated, showUserWhoCreated, showDateReleased, showDateExpired));
        }
        content.append(this.getInitializationFooter(numberOfPages, selectedPage));
        return content.toString();
    }

    public String getInitializationEntry(CmsResourceUtil resUtil, boolean showPath, boolean showTitle, boolean showNavText, boolean showPermissions, boolean showDateLastModified, boolean showUserWhoLastModified, boolean showDateCreated, boolean showUserWhoCreated, boolean showDateReleased, boolean showDateExpired) {
        CmsResource resource = resUtil.getResource();
        String path = this.getCms().getSitePath(resource);
        StringBuffer content = new StringBuffer(2048);
        content.append("top.aF(");
        content.append("\"");
        content.append(resource.getName());
        content.append("\",");
        if (showPath) {
            content.append("\"");
            content.append(path);
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        if (showTitle) {
            String title = resUtil.getTitle();
            content.append("\"");
            content.append(CmsEncoder.escapeWBlanks(title, "UTF-8"));
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        if (showNavText) {
            String navText = resUtil.getNavText();
            content.append("\"");
            content.append(CmsEncoder.escapeWBlanks(navText, "UTF-8"));
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        content.append(resUtil.getResourceTypeId());
        content.append(",");
        content.append(resUtil.getLinkType());
        content.append(",");
        content.append(resource.getLength());
        content.append(",");
        content.append(resource.getState());
        content.append(",");
        content.append(resUtil.getTimeWindowLayoutType());
        content.append(',');
        if (showDateLastModified) {
            content.append("\"");
            content.append(this.getMessages().getDateTime(resource.getDateLastModified()));
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        if (showUserWhoLastModified) {
            content.append("\"");
            content.append(resUtil.getUserLastModified());
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        if (showDateCreated) {
            content.append("\"");
            content.append(this.getMessages().getDateTime(resource.getDateCreated()));
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        if (showUserWhoCreated) {
            content.append("\"");
            content.append(resUtil.getUserCreated());
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        if (showDateReleased) {
            content.append("\"");
            content.append(resUtil.getDateReleased());
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        if (showDateExpired) {
            content.append("\"");
            content.append(resUtil.getDateExpired());
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        if (showPermissions) {
            content.append("\"");
            content.append(CmsStringUtil.escapeJavaScript(resUtil.getPermissionString()));
            content.append("\",");
        } else {
            content.append("\"\",");
        }
        content.append("\"");
        content.append(CmsStringUtil.escapeJavaScript(resUtil.getLockedByName()));
        content.append("\",");
        content.append("\"");
        content.append(resUtil.getLockedInProjectName());
        content.append("\",");
        int lockState = resUtil.getLockState();
        content.append(lockState);
        content.append(",\"");
        if (resUtil.isInsideProject()) {
            content.append("I");
        } else {
            content.append("O");
        }
        content.append("\",\"");
        content.append(resUtil.getSystemLockInfo(true));
        content.append("\", ");
        content.append(resUtil.getProjectState().getMode());
        content.append(");\n");
        return content.toString();
    }

    public String getInitializationFooter(int numberOfPages, int selectedPage) {
        String message;
        StringBuffer content = new StringBuffer(1024);
        content.append("top.dU(document,");
        content.append(numberOfPages);
        content.append(",");
        content.append(selectedPage);
        content.append("); \n");
        if (this.getSettings().getErrorMessage() != null) {
            content.append("alert(\"");
            content.append(CmsStringUtil.escapeJavaScript(this.getSettings().getErrorMessage().key(this.getLocale())));
            content.append("\");\n");
            this.getSettings().setErrorMessage(null);
        }
        if (CmsStringUtil.isNotEmpty(message = this.getBroadcastMessageString())) {
            content.append("alert(decodeURIComponent(\"");
            content.append(CmsEncoder.escapeWBlanks(message, "UTF-8"));
            content.append("\"));\n");
        }
        content.append("}\n");
        return content.toString();
    }

    public String getInitializationHeader() {
        boolean listView = VIEW_LIST.equals(this.getSettings().getExplorerMode());
        String currentResourceName = this.getSettings().getExplorerResource();
        CmsResource currentResource = null;
        try {
            currentResource = this.getCms().readResource(currentResourceName, CmsResourceFilter.ALL);
        }
        catch (CmsException e) {
            // empty catch block
        }
        if (currentResource == null) {
            currentResourceName = "/";
            try {
                currentResource = this.getCms().readResource(currentResourceName, CmsResourceFilter.ALL);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
            }
        }
        StringBuffer content = new StringBuffer(1024);
        content.append("function initialize() {\n");
        content.append("top.setRootFolder(\"");
        String rootFolder = this.getRootFolder();
        content.append(rootFolder);
        content.append("\");\n");
        content.append("top.mode=\"");
        content.append(this.getSettings().getExplorerMode());
        content.append("\";\n");
        content.append("top.plainresid=");
        content.append(CmsResourceTypePlain.getStaticTypeId());
        content.append(";\n");
        content.append("top.autolock=");
        content.append(OpenCms.getWorkplaceManager().autoLockResources());
        content.append(";\n");
        content.append("top.buttonType=");
        content.append(this.getSettings().getUserSettings().getExplorerButtonStyle());
        content.append(";\n");
        content.append("top.head.helpUrl='explorer/index.html';\n");
        content.append("top.setProject('");
        if (!listView) {
            content.append(this.getSettings().getProject());
        } else {
            content.append(this.getSettings().getExplorerProjectId());
        }
        content.append("');\n");
        content.append("top.setOnlineProject('");
        content.append(CmsProject.ONLINE_PROJECT_ID);
        content.append("');\n");
        boolean writeAccess = VIEW_EXPLORER.equals(this.getSettings().getExplorerMode());
        if (writeAccess) {
            writeAccess = this.getCms().isInsideCurrentProject(currentResourceName);
        }
        content.append("top.enableNewButton(");
        content.append(writeAccess);
        content.append(");\n");
        content.append("top.setDirectory(\"");
        content.append(CmsResource.getFolderPath(currentResource.getRootPath()));
        content.append("\",\"");
        content.append(CmsResource.getFolderPath(this.getCms().getRequestContext().removeSiteRoot(currentResource.getRootPath())));
        content.append("\");\n");
        content.append("top.rD();\n");
        List reloadTreeFolders = (List)this.getJsp().getRequest().getAttribute("__CmsWorkplace.RELOADTREE");
        if (reloadTreeFolders != null) {
            String reloadFolder = "";
            for (int i = 0; i < reloadTreeFolders.size(); ++i) {
                reloadFolder = (String)reloadTreeFolders.get(i);
                if (this.getSettings().getUserSettings().getRestrictExplorerView() && reloadFolder.length() >= rootFolder.length()) {
                    reloadFolder = reloadFolder.substring(rootFolder.length() - 1);
                }
                content.append("top.addNodeToLoad(\"" + reloadFolder + "\");\n");
            }
            content.append("top.reloadNodeList();\n");
        }
        content.append("\n");
        return content.toString();
    }

    public String getRootFolder() {
        String folder = "/";
        if (this.getSettings().getUserSettings().getRestrictExplorerView()) {
            folder = this.getSettings().getUserSettings().getStartFolder();
        }
        try {
            this.getCms().readFolder(folder, CmsResourceFilter.IGNORE_EXPIRATION);
            return folder;
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e);
            }
            return "/";
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        String currentResource = request.getParameter(PARAMETER_RESOURCE);
        String mode = request.getParameter(PARAMETER_MODE);
        if (CmsStringUtil.isNotEmpty(mode)) {
            settings.setExplorerMode(mode);
        } else if (!VIEW_GALLERY.equals(settings.getExplorerMode()) && !VIEW_LIST.equals(settings.getExplorerMode())) {
            settings.setExplorerMode(VIEW_EXPLORER);
        }
        this.m_uri = request.getParameter(PARAMETER_URI);
        if (CmsStringUtil.isNotEmpty(currentResource) && this.folderExists(this.getCms(), currentResource)) {
            settings.setExplorerResource(currentResource, this.getCms());
        } else {
            currentResource = settings.getExplorerResource();
            if (!this.resourceExists(this.getCms(), currentResource)) {
                settings.setExplorerResource("/", this.getCms());
            }
        }
        String selectedPage = request.getParameter(PARAMETER_PAGE);
        if (selectedPage != null) {
            int page;
            block11: {
                page = 1;
                try {
                    page = Integer.parseInt(selectedPage);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isInfoEnabled()) break block11;
                    LOG.info((Object)e);
                }
            }
            settings.setExplorerPage(page);
        }
        if (this.getSettings().getExplorerMode().equals(VIEW_EXPLORER)) {
            this.getSettings().setViewStartup(null);
        }
        if (this.getSettings().getExplorerMode().equals(VIEW_LIST) && this.getSettings().getViewStartup() == null && this.getSettings().getViewUri().indexOf("/system/workplace/views/admin") < 0) {
            String uri = "/system/workplace/views/admin/admin-main.jsp";
            uri = CmsRequestUtil.appendParameter("/system/workplace/views/explorer/explorer_fs.jsp", PARAMETER_URI, CmsEncoder.encode(CmsEncoder.encode(uri)));
            this.getSettings().setViewStartup(this.getJsp().link(uri));
        }
        settings.setExplorerFlaturl(request.getParameter(PARAMETER_FLATURL));
    }

    private boolean folderExists(CmsObject cms, String folder) {
        try {
            CmsFolder test = cms.readFolder(folder, CmsResourceFilter.IGNORE_EXPIRATION);
            return !test.isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    private List getResources(String resource) {
        if (VIEW_LIST.equals(this.getSettings().getExplorerMode())) {
            block9: {
                I_CmsResourceCollector collector = this.getSettings().getCollector();
                if (collector != null) {
                    if (collector instanceof I_CmsListResourceCollector) {
                        ((I_CmsListResourceCollector)collector).setPage(this.getSettings().getExplorerPage());
                    }
                    try {
                        return collector.getResults(this.getCms());
                    }
                    catch (CmsException e) {
                        if (!LOG.isInfoEnabled()) break block9;
                        LOG.info((Object)e);
                    }
                }
            }
            return Collections.EMPTY_LIST;
        }
        if (VIEW_GALLERY.equals(this.getSettings().getExplorerMode())) {
            A_CmsGallery gallery = A_CmsGallery.createInstance(this.getSettings().getGalleryType(), this.getJsp());
            return gallery.getGalleries();
        }
        try {
            return this.getCms().getResourcesInFolder(resource, CmsResourceFilter.ONLY_VISIBLE);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e);
            }
            return Collections.EMPTY_LIST;
        }
    }

    private int getUserPreferences() {
        CmsUserSettings settings = new CmsUserSettings(this.getCms());
        return settings.getExplorerSettings();
    }

    private boolean resourceExists(CmsObject cms, String resource) {
        try {
            cms.readResource(resource, CmsResourceFilter.ALL);
            return true;
        }
        catch (CmsException e) {
            return false;
        }
    }
}

