/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.workplace.explorer.CmsExplorerContextMenu;
import org.opencms.workplace.explorer.CmsExplorerContextMenuItem;
import org.opencms.workplace.explorer.CmsExplorerTypeAccess;
import org.opencms.workplace.explorer.Messages;

public class CmsExplorerTypeSettings
implements Comparable {
    public static final int ORDER_VALUE_DEFAULT_START = 100000;
    public static final String ORDER_VALUE_SEPARATOR_DEFAULT = "999999";
    private static final Log LOG = CmsLog.getLog(CmsExplorerTypeSettings.class);
    private CmsExplorerTypeAccess m_access = new CmsExplorerTypeAccess();
    private boolean m_addititionalModuleExplorerType = false;
    private boolean m_autoSetNavigation;
    private boolean m_autoSetTitle;
    private CmsExplorerContextMenu m_contextMenu;
    private List m_contextMenuEntries;
    private String m_descriptionImage;
    private boolean m_hasEditOptions = false;
    private String m_icon;
    private String m_info;
    private String m_key;
    private String m_name;
    private String m_newResourceHandlerClassName;
    private Integer m_newResourceOrder;
    private String m_newResourcePage;
    private String m_newResourceUri;
    private List m_properties = new ArrayList();
    private boolean m_propertiesEnabled = false;
    private String m_reference;
    private boolean m_showNavigation = false;
    private String m_titleKey;

    public CmsExplorerTypeSettings() {
        this.m_contextMenuEntries = new ArrayList();
        this.m_contextMenu = new CmsExplorerContextMenu();
        this.m_newResourceOrder = new Integer(0);
    }

    public void addContextMenuEntry(CmsExplorerContextMenuItem item) {
        item.setType("entry");
        this.m_contextMenuEntries.add(item);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_MENU_ENTRY_2", item.getKey(), item.getUri()));
        }
    }

    public void addContextMenuSeparator(CmsExplorerContextMenuItem item) {
        item.setType("sep");
        this.m_contextMenuEntries.add(item);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_MENU_SEPARATOR_1", item.getType()));
        }
    }

    public boolean addProperty(String propertyName) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(propertyName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_PROP_1", propertyName));
            }
            return this.m_properties.add(propertyName);
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsExplorerTypeSettings) {
            int result;
            CmsExplorerTypeSettings other = (CmsExplorerTypeSettings)obj;
            String myPage = this.getNewResourcePage();
            String otherPage = other.getNewResourcePage();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(myPage)) {
                myPage = "";
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(otherPage)) {
                otherPage = "";
            }
            if ((result = myPage.compareTo(otherPage)) == 0) {
                result = this.m_newResourceOrder.compareTo(other.m_newResourceOrder);
            }
            return result;
        }
        return 0;
    }

    public void createContextMenu() {
        this.m_contextMenu.addEntries(this.getContextMenuEntries());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_CONTEXT_MENU_1", this.getName()));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmsExplorerTypeSettings)) {
            return false;
        }
        CmsExplorerTypeSettings other = (CmsExplorerTypeSettings)o;
        return this.getName().equals(other.getName());
    }

    public CmsExplorerTypeAccess getAccess() {
        CmsWorkplaceManager workplaceManager;
        if (this.m_access.isEmpty() && (workplaceManager = OpenCms.getWorkplaceManager()) != null) {
            this.m_access = workplaceManager.getDefaultAccess();
        }
        return this.m_access;
    }

    public CmsExplorerContextMenu getContextMenu() {
        if (this.m_reference != null && this.m_contextMenu.isEmpty()) {
            this.m_contextMenu = (CmsExplorerContextMenu)OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_reference).getContextMenu().clone();
        }
        return this.m_contextMenu;
    }

    public List getContextMenuEntries() {
        return this.m_contextMenuEntries;
    }

    public String getDescriptionImage() {
        return this.m_descriptionImage;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public String getInfo() {
        return this.m_info;
    }

    public String getJSEntries(CmsExplorerTypeSettings settings, int resTypeId, CmsMessages messages) {
        StringBuffer result = new StringBuffer(4096);
        result.append("\nvi.resource[").append(resTypeId).append("]=new res(\"").append(settings.getName()).append("\", ");
        result.append("\"");
        result.append(messages.key(settings.getKey()));
        result.append("\", vi.skinPath + \"filetypes/");
        result.append(settings.getIcon());
        result.append("\", \"");
        result.append(settings.getNewResourceUri());
        result.append("\", true);\n");
        return result.toString();
    }

    public String getKey() {
        return this.m_key;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNewResourceHandlerClassName() {
        return this.m_newResourceHandlerClassName;
    }

    public String getNewResourceOrder() {
        return String.valueOf(this.m_newResourceOrder);
    }

    public String getNewResourcePage() {
        return this.m_newResourcePage;
    }

    public String getNewResourceUri() {
        return this.m_newResourceUri;
    }

    public List getProperties() {
        return this.m_properties;
    }

    public String getReference() {
        return this.m_reference;
    }

    public String getTitleKey() {
        return this.m_titleKey;
    }

    public boolean hasEditOptions() {
        return this.m_hasEditOptions;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isAddititionalModuleExplorerType() {
        return this.m_addititionalModuleExplorerType;
    }

    public boolean isAutoSetNavigation() {
        return this.m_autoSetNavigation;
    }

    public boolean isAutoSetTitle() {
        return this.m_autoSetTitle;
    }

    public boolean isEditable(CmsObject cms, CmsResource resource) {
        CmsPermissionSet permissions = this.getAccess().getPermissions(cms, resource);
        return permissions.requiresWritePermission();
    }

    public boolean isPropertiesEnabled() {
        return this.m_propertiesEnabled;
    }

    public boolean isShowNavigation() {
        return this.m_showNavigation;
    }

    public void setAccess(CmsExplorerTypeAccess access) {
        this.m_access = access;
    }

    public void setAddititionalModuleExplorerType(boolean addititionalModuleExplorerType) {
        this.m_addititionalModuleExplorerType = addititionalModuleExplorerType;
    }

    public void setAutoSetNavigation(String autoSetNavigation) {
        this.m_autoSetNavigation = Boolean.valueOf(autoSetNavigation);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_AUTO_NAV_1", autoSetNavigation));
        }
    }

    public void setAutoSetTitle(String autoSetTitle) {
        this.m_autoSetTitle = Boolean.valueOf(autoSetTitle);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_AUTO_TITLE_1", autoSetTitle));
        }
    }

    public void setContextMenuEntries(List entries) {
        this.m_contextMenuEntries = entries;
    }

    public void setDescriptionImage(String descriptionImage) {
        this.m_descriptionImage = descriptionImage;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_NEW_RESOURCE_DESCRIPTION_IMAGE_1", descriptionImage));
        }
    }

    public void setEditOptions() {
        this.m_hasEditOptions = true;
    }

    public void setIcon(String icon) {
        this.m_icon = icon;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_ICON_1", icon));
        }
    }

    public void setInfo(String info) {
        this.m_info = info;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_INFO_1", info));
        }
    }

    public void setKey(String key) {
        this.m_key = key;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_KEY_1", key));
        }
    }

    public void setName(String name) {
        this.m_name = name;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_NAME_1", name));
        }
    }

    public void setNewResourceHandlerClassName(String newResourceHandlerClassName) {
        this.m_newResourceHandlerClassName = newResourceHandlerClassName;
    }

    public void setNewResourceOrder(String newResourceOrder) {
        try {
            this.m_newResourceOrder = Integer.valueOf(newResourceOrder);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_NEW_RESOURCE_ORDER_1", newResourceOrder));
            }
        }
        catch (Exception e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e);
            }
            this.m_newResourceOrder = new Integer(0);
        }
    }

    public void setNewResourcePage(String page) {
        this.m_newResourcePage = page;
    }

    public void setNewResourceUri(String newResourceUri) {
        this.m_newResourceUri = newResourceUri;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_NEW_RESOURCE_URI_1", newResourceUri));
        }
    }

    public void setProperties(List properties) {
        this.m_properties = properties;
    }

    public void setPropertiesEnabled(boolean enabled) {
        this.m_propertiesEnabled = enabled;
    }

    public void setPropertyDefaults(String enabled, String showNavigation) {
        this.setPropertiesEnabled(Boolean.valueOf(enabled));
        this.setShowNavigation(Boolean.valueOf(showNavigation));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_PROP_DEFAULTS_2", enabled, showNavigation));
        }
    }

    public void setReference(String reference) {
        this.m_reference = reference;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_REFERENCE_1", this.m_reference));
        }
    }

    public void setShowNavigation(boolean navigation) {
        this.m_showNavigation = navigation;
    }

    public void setTitleKey(String titleKey) {
        this.m_titleKey = titleKey;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_TITLE_KEY_1", titleKey));
        }
    }

    public void setTypeAttributes(String name, String key, String icon) {
        this.setName(name);
        this.setKey(key);
        this.setIcon(icon);
    }

    public void setTypeAttributes(String name, String key, String icon, String reference) {
        this.setName(name);
        this.setKey(key);
        this.setIcon(icon);
        this.setReference(reference);
    }
}

