/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsXsltUtil;
import org.opencms.workplace.CmsWorkplaceException;
import org.opencms.workplace.explorer.CmsNewResourceUpload;
import org.opencms.workplace.explorer.Messages;

public class CmsNewCsvFile
extends CmsNewResourceUpload {
    public static final String BEST_DELIMITER = "best";
    public static final String FRAMEHEIGHT = "450";
    public static final String PARAM_CSVCONTENT = "csvcontent";
    public static final String PARAM_DELIMITER = "delimiter";
    public static final String PARAM_XSLTFILE = "xsltfile";
    public static final String TABLE_XSLT_SUFFIX = ".table.xslt";
    public static final String TABULATOR = "tab";
    private static final Log LOG = CmsLog.getLog(CmsNewCsvFile.class);
    private String m_paramCsvContent;
    private String m_paramDelimiter;
    private String m_paramXsltFile;

    public CmsNewCsvFile(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsNewCsvFile(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    static String toXmlBody(String content) {
        StringBuffer xmlBody = new StringBuffer(1024);
        if ((content = content.trim()).startsWith("<") && content.endsWith(">")) {
            return content;
        }
        xmlBody.append("<![CDATA[");
        xmlBody.append(content);
        xmlBody.append("]]>");
        return xmlBody.toString();
    }

    public void actionUpload() throws JspException {
        String newResname = "";
        try {
            if (CmsStringUtil.isNotEmpty(this.getParamCsvContent())) {
                newResname = "csvcontent.html";
                this.setParamNewResourceName("");
            } else {
                this.setParamCsvContent(new String(this.getFileContentFromUpload(), "ISO-8859-1"));
                newResname = this.getCms().getRequestContext().getFileTranslator().translateResource(CmsResource.getName(this.getParamResource().replace('\\', '/')));
                newResname = CmsStringUtil.changeFileNameSuffixTo(newResname, "html");
                this.setParamNewResourceName(newResname);
            }
            this.setParamResource(newResname);
            this.setParamResource(this.computeFullResourceName());
            int resTypeId = OpenCms.getResourceManager().getDefaultTypeForName(newResname).getTypeId();
            String xmlContent = CmsXsltUtil.transformCsvContent(this.getCms(), this.getParamXsltFile(), this.getParamCsvContent(), BEST_DELIMITER.equals(this.getParamDelimiter()) ? null : this.getParamDelimiter());
            byte[] content = xmlContent.getBytes();
            CmsProperty styleProp = CmsProperty.getNullProperty();
            if (CmsStringUtil.isNotEmpty(this.getParamXsltFile())) {
                styleProp = this.getCms().readPropertyObject(this.getParamXsltFile(), "stylesheet", true);
            }
            try {
                this.getCms().createResource(this.getParamResource(), resTypeId, content, Collections.EMPTY_LIST);
            }
            catch (CmsException e) {
                this.getCms().lockResource(this.getParamResource());
                this.getCms().replaceResource(this.getParamResource(), resTypeId, content, null);
            }
            if (!styleProp.isNullProperty()) {
                this.getCms().writePropertyObject(this.getParamResource(), styleProp);
            }
        }
        catch (Throwable e) {
            this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_TABLE_IMPORT_FAILED_0"));
            this.includeErrorpage(this, e);
        }
    }

    public String buildDelimiterSelect() {
        Object[] optionStrings = new Object[]{this.key("GUI_NEWRESOURCE_CONVERSION_DELIM_BEST_0"), this.key("GUI_NEWRESOURCE_CONVERSION_DELIM_SEMICOLON_0"), this.key("GUI_NEWRESOURCE_CONVERSION_DELIM_COMMA_0"), this.key("GUI_NEWRESOURCE_CONVERSION_DELIM_TAB_0")};
        ArrayList<Object> options = new ArrayList<Object>(Arrays.asList(optionStrings));
        ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(BEST_DELIMITER, ";", ",", TABULATOR));
        String parameters = "name=\"delimiter\" class=\"maxwidth\"";
        return this.buildSelect(parameters, options, values, 0);
    }

    public String buildXsltSelect() {
        List xsltFiles = this.getXsltFiles();
        if (xsltFiles.size() > 0) {
            ArrayList<String> options = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            options.add(this.key("GUI_NEWRESOURCE_CONVERSION_NOSTYLE_0"));
            values.add("");
            CmsProperty titleProp = CmsProperty.getNullProperty();
            Iterator i = xsltFiles.iterator();
            while (i.hasNext()) {
                CmsResource resource;
                block5: {
                    resource = (CmsResource)i.next();
                    try {
                        titleProp = this.getCms().readPropertyObject(resource.getRootPath(), "Title", false);
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) break block5;
                        LOG.warn((Object)e);
                    }
                }
                values.add(resource.getRootPath());
                if (titleProp.isNullProperty()) {
                    options.add("[" + resource.getName() + "]");
                    continue;
                }
                options.add(titleProp.getValue());
            }
            StringBuffer result = new StringBuffer(512);
            result.append("<tr><td style=\"white-space: nowrap;\" unselectable=\"on\">");
            result.append(this.key("GUI_NEWRESOURCE_CONVERSION_XSLTFILE_0"));
            result.append("</td><td class=\"maxwidth\">");
            String parameters = "class=\"maxwidth\" name=\"xsltfile\"";
            result.append(this.buildSelect(parameters, options, values, 0));
            result.append("</td><tr>");
            return result.toString();
        }
        return "";
    }

    public byte[] getFileContentFromUpload() throws CmsWorkplaceException {
        Iterator i = this.getMultiPartFileItems().iterator();
        FileItem fi = null;
        while (i.hasNext() && (fi = (FileItem)i.next()).getName() == null) {
        }
        if (fi != null) {
            long size = fi.getSize();
            if (size == 0L) {
                throw new CmsWorkplaceException(Messages.get().container("ERR_UPLOAD_FILE_NOT_FOUND_0"));
            }
            long maxFileSizeBytes = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCms());
            if (maxFileSizeBytes > 0L && size > maxFileSizeBytes) {
                throw new CmsWorkplaceException(Messages.get().container("ERR_UPLOAD_FILE_SIZE_TOO_HIGH_1", new Long(maxFileSizeBytes / 1024L)));
            }
        } else {
            throw new CmsWorkplaceException(Messages.get().container("ERR_UPLOAD_FILE_NOT_FOUND_0"));
        }
        byte[] content = fi.get();
        fi.delete();
        this.setParamResource(fi.getName());
        return content;
    }

    public String getHeadFrameSetHeight() {
        return FRAMEHEIGHT;
    }

    public String getParamCsvContent() {
        return this.m_paramCsvContent;
    }

    public String getParamDelimiter() {
        return this.m_paramDelimiter;
    }

    public String getParamXsltFile() {
        return this.m_paramXsltFile;
    }

    public List getXsltFiles() {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        try {
            Iterator xmlFiles = this.getCms().readResources("/system/modules/", CmsResourceFilter.DEFAULT_FILES.addRequireType(CmsResourceTypePlain.getStaticTypeId()), true).iterator();
            while (xmlFiles.hasNext()) {
                CmsResource xmlFile = (CmsResource)xmlFiles.next();
                if (!xmlFile.getName().endsWith(TABLE_XSLT_SUFFIX)) continue;
                result.add(xmlFile);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public void setParamCsvContent(String csvContent) {
        this.m_paramCsvContent = csvContent;
    }

    public void setParamDelimiter(String delimiter) {
        this.m_paramDelimiter = delimiter;
    }

    public void setParamXsltFile(String xsltFile) {
        this.m_paramXsltFile = xsltFile;
    }
}

