/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUriSplitter;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.Messages;
import org.opencms.workplace.list.A_CmsListResourceTypeDialog;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemSelectionCustomAction;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;

public class CmsNewResource
extends A_CmsListResourceTypeDialog {
    public static final int ACTION_NEWFORM = 100;
    public static final int ACTION_SUBMITFORM = 110;
    public static final int BUTTON_NEXT = 20;
    public static final String DEFAULT_SUFFIX = ".html";
    public static final char DELIM_PROPERTYVALUES = ',';
    public static final String DIALOG_ADVANCED = "advanced";
    public static final String DIALOG_NEWFORM = "newform";
    public static final String DIALOG_SUBMITFORM = "submitform";
    public static final String DIALOG_TYPE = "newresource";
    public static final String LIST_COLUMN_URI = "nrcu";
    public static final String PARAM_APPENDSUFFIXHTML = "appendsuffixhtml";
    public static final String PARAM_CURRENTFOLDER = "currentfolder";
    public static final String PARAM_NEWFORMURI = "newformuri";
    public static final String PARAM_NEWRESOURCEEDITPROPS = "newresourceeditprops";
    public static final String PARAM_NEWRESOURCETYPE = "newresourcetype";
    public static final String PARAM_NEWRESOURCEURI = "newresourceuri";
    public static final String SESSION_ATTR_ADVANCED = "ocms_newres_adv";
    public static final String SESSION_ATTR_PAGE = "ocms_newres_page";
    public static final String VALUE_DEFAULT = "default";
    private static final Log LOG = CmsLog.getLog(CmsNewResource.class);
    private String m_availableResTypes;
    private boolean m_limitedRestypes;
    private String m_page;
    private String m_paramAppendSuffixHtml;
    private String m_paramCurrentFolder;
    private String m_paramDialogMode;
    private String m_paramNewFormUri;
    private String m_paramNewResourceEditProps;
    private String m_paramNewResourceType;
    private String m_paramNewResourceUri;
    private String m_paramPage;
    private boolean m_resourceCreated;

    public CmsNewResource(CmsJspActionElement jsp) {
        super(jsp, "nrt", Messages.get().container("GUI_NEWRESOURCE_SELECT_TYPE_0"), null, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsNewResource(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String computeNewTitleProperty(String name) {
        String title = name;
        int lastDot = title.lastIndexOf(46);
        if (lastDot > 0 && lastDot < title.length() - 1) {
            title = title.substring(0, lastDot);
        }
        return title;
    }

    public static Object getNewResourceHandler(String type, String defaultClassName, PageContext context, HttpServletRequest req, HttpServletResponse res) throws CmsRuntimeException {
        if (CmsStringUtil.isEmpty(type)) {
            type = req.getParameter(PARAM_NEWRESOURCETYPE);
        }
        String className = null;
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type);
        className = CmsStringUtil.isNotEmpty(settings.getNewResourceHandlerClassName()) ? settings.getNewResourceHandlerClassName() : defaultClassName;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_NEW_RES_HANDLER_CLASS_NOT_FOUND_1", className), (Throwable)e);
            }
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_NEW_RES_HANDLER_CLASS_NOT_FOUND_1", className));
        }
        Object handler = null;
        try {
            Constructor<?> constructor = clazz.getConstructor(PageContext.class, HttpServletRequest.class, HttpServletResponse.class);
            handler = constructor.newInstance(context, req, res);
        }
        catch (Exception e) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_NEW_RES_CONSTRUCTOR_NOT_FOUND_1", className));
        }
        return handler;
    }

    protected static CmsProperty createPropertyObject(String name, String value) {
        CmsProperty prop = new CmsProperty();
        prop.setAutoCreatePropertyDefinition(true);
        prop.setName(name);
        if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
            prop.setValue(value, "individual");
        } else {
            prop.setValue(value, "shared");
        }
        return prop;
    }

    protected static List createResourceProperties(CmsObject cms, String resourceName, String resTypeName, String title) {
        ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(3);
        CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resTypeName);
        if (settings.isAutoSetTitle()) {
            properties.add(CmsNewResource.createPropertyObject("Title", title));
        }
        if (settings.isAutoSetNavigation()) {
            properties.add(CmsNewResource.createPropertyObject("NavText", title));
            List navList = CmsJspNavBuilder.getNavigationForFolder(cms, resourceName);
            float navPos = 1.0f;
            if (navList.size() > 0) {
                CmsJspNavElement nav = (CmsJspNavElement)navList.get(navList.size() - 1);
                navPos = nav.getNavPosition() + 1.0f;
            }
            properties.add(CmsNewResource.createPropertyObject("NavPos", String.valueOf(navPos)));
        }
        return properties;
    }

    public void actionCloseDialog() throws JspException {
        if (this.isCreateIndexMode()) {
            String updateFolder = CmsResource.getParentFolder(this.getSettings().getExplorerResource());
            this.getSettings().setExplorerResource(updateFolder, this.getCms());
            ArrayList<String> folderList = new ArrayList<String>(1);
            if (updateFolder != null) {
                folderList.add(updateFolder);
            }
            this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
        }
        super.actionCloseDialog();
    }

    public void actionCreateResource() throws JspException {
        try {
            String title = this.computeNewTitleProperty();
            String fullResourceName = this.computeFullResourceName();
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(this.getParamNewResourceType());
            List properties = this.createResourceProperties(fullResourceName, resType.getTypeName(), title);
            this.getCms().createResource(fullResourceName, resType.getTypeId(), null, properties);
            this.setParamResource(fullResourceName);
            this.setResourceCreated(true);
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public void actionDialog() throws JspException, ServletException, IOException {
        super.actionDialog();
        switch (this.getAction()) {
            case 110: {
                this.actionCreateResource();
                if (!this.isResourceCreated()) break;
                this.actionEditProperties();
                break;
            }
            case 3: {
                this.actionSelect();
                break;
            }
            case 100: {
                this.setParamAction(DIALOG_SUBMITFORM);
                break;
            }
            default: {
                this.setParamAction("ok");
            }
        }
    }

    public void actionEditProperties() throws IOException, JspException, ServletException {
        boolean editProps = Boolean.valueOf(this.getParamNewResourceEditProps());
        if (editProps) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("resource", this.getParamResource());
            if (this.isCreateIndexMode()) {
                params.put("dialogmode", "wizardindexcreated");
            } else {
                params.put("dialogmode", "wizard");
            }
            this.sendForward("/system/workplace/commons/property.jsp", params);
        } else {
            this.actionCloseDialog();
        }
    }

    public void actionSelect() throws IOException, ServletException {
        String nextUri = this.getParamNewResourceUri();
        if (!nextUri.startsWith("/")) {
            nextUri = "/system/workplace/commons/" + nextUri;
        }
        this.setParamAction(DIALOG_NEWFORM);
        CmsUriSplitter splitter = new CmsUriSplitter(nextUri);
        Map params = CmsRequestUtil.createParameterMap(splitter.getQuery());
        params.putAll(this.paramsAsParameterMap());
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_page) && params.containsKey("page") && this.m_page.equals(params.get("page"))) {
            params.remove("page");
        }
        if (!params.containsKey("page")) {
            this.clearSession();
        }
        this.sendForward(splitter.getPrefix(), params);
    }

    public String computeNewTitleProperty() {
        return CmsNewResource.computeNewTitleProperty(this.getParamResource());
    }

    public String dialogButtons() {
        return this.dialogButtonsAdvancedNextCancel(" onclick=\"submitAdvanced();\"", "id=\"nextButton\" disabled=\"disabled\"", null);
    }

    public String dialogButtonsAdvancedNextCancel(String advancedAttrs, String nextAttrs, String cancelAttrs) {
        if (this.m_limitedRestypes && OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.VFS_MANAGER)) {
            return this.dialogButtons(new int[]{20, 3, 1}, new String[]{nextAttrs, advancedAttrs, cancelAttrs});
        }
        return this.dialogButtons(new int[]{20, 1}, new String[]{nextAttrs, cancelAttrs});
    }

    public String dialogButtonsNextCancel(String nextAttrs, String cancelAttrs) {
        return this.dialogButtons(new int[]{20, 1}, new String[]{nextAttrs, cancelAttrs});
    }

    public String getParamAppendSuffixHtml() {
        return this.m_paramAppendSuffixHtml;
    }

    public String getParamCurrentFolder() {
        if (CmsStringUtil.isEmpty(this.m_paramCurrentFolder)) {
            return this.computeCurrentFolder();
        }
        return this.m_paramCurrentFolder;
    }

    public String getParamDialogmode() {
        return this.m_paramDialogMode;
    }

    public String getParamNewFormUri() {
        return this.m_paramNewFormUri;
    }

    public String getParamNewResourceEditProps() {
        return this.m_paramNewResourceEditProps;
    }

    public String getParamNewResourceType() {
        return this.m_paramNewResourceType;
    }

    public String getParamNewResourceUri() {
        return this.m_paramNewResourceUri;
    }

    public String getParamPage() {
        return this.m_paramPage;
    }

    public String getSuffixHtml() {
        String defaultfile;
        int index;
        String result = "";
        if (OpenCms.getDefaultFiles().size() > 0 && (index = (defaultfile = (String)OpenCms.getDefaultFiles().get(0)).indexOf(46)) >= 0) {
            result = defaultfile.substring(index, defaultfile.length());
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = DEFAULT_SUFFIX;
        }
        return result;
    }

    public boolean isCreateIndexMode() {
        return "wizardcreateindex".equals(this.getParamDialogmode());
    }

    public boolean isResourceCreated() {
        return this.m_resourceCreated;
    }

    public String paramsAsHidden() {
        String resourceName = this.getParamResource();
        this.setParamResource(null);
        String params = super.paramsAsHidden();
        this.setParamResource(resourceName);
        return params;
    }

    public void setParamAppendSuffixHtml(String paramAppendSuffixHtml) {
        this.m_paramAppendSuffixHtml = paramAppendSuffixHtml;
    }

    public void setParamCurrentFolder(String paramCurrentFolder) {
        this.m_paramCurrentFolder = paramCurrentFolder;
    }

    public void setParamDialogmode(String value) {
        this.m_paramDialogMode = value;
    }

    public void setParamNewFormUri(String paramNewFormUri) {
        this.m_paramNewFormUri = paramNewFormUri;
    }

    public void setParamNewResourceEditProps(String newResourceEditProps) {
        this.m_paramNewResourceEditProps = newResourceEditProps;
    }

    public void setParamNewResourceType(String newResourceType) {
        this.m_paramNewResourceType = newResourceType;
    }

    public void setParamNewResourceUri(String newResourceUri) {
        this.m_paramNewResourceUri = newResourceUri;
    }

    public void setParamPage(String paramPage) {
        this.m_paramPage = paramPage;
    }

    public void setResourceCreated(boolean successfullyCreated) {
        this.m_resourceCreated = successfullyCreated;
    }

    protected String appendSuffixHtml(String resourceName, boolean forceSuffix) {
        if ((forceSuffix || Boolean.valueOf(this.getParamAppendSuffixHtml()).booleanValue()) && OpenCms.getResourceManager().getMimeType(resourceName, null, null) == null) {
            resourceName = resourceName + this.getSuffixHtml();
        }
        return resourceName;
    }

    protected void clearSession() {
        this.getJsp().getRequest().getSession(true).removeAttribute(SESSION_ATTR_ADVANCED);
        this.getJsp().getRequest().getSession(true).removeAttribute(SESSION_ATTR_PAGE);
    }

    protected String computeFullResourceName() {
        String currentFolder = this.getParamCurrentFolder();
        if (CmsStringUtil.isEmpty(currentFolder)) {
            currentFolder = this.computeCurrentFolder();
        }
        return currentFolder + this.getParamResource();
    }

    protected List createResourceProperties(String resourceName, String resTypeName, String title) {
        return CmsNewResource.createResourceProperties(this.getCms(), resourceName, resTypeName, title);
    }

    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(256);
        result.append(super.customHtmlStart());
        result.append("<script type='text/javascript'>\n");
        result.append("function enableButton() {\n");
        result.append("\tvar theButton = document.getElementById(\"nextButton\");\n");
        result.append("\tif (theButton.disabled == true) {\n");
        result.append("\t\ttheButton.disabled = false;\n");
        result.append("\t}\n");
        result.append("}\n");
        result.append("function submitAdvanced() {\n");
        result.append("\tdocument.forms[\"" + this.getList().getId() + "-form\"].action.value = \"" + DIALOG_ADVANCED + "\";\n");
        result.append("\tdocument.forms[\"" + this.getList().getId() + "-form\"].submit();\n");
        result.append("}\n");
        result.append("</script>");
        return result.toString();
    }

    protected void dialogButtonsHtml(StringBuffer result, int button, String attribute) {
        attribute = this.appendDelimiter(attribute);
        switch (button) {
            case 20: {
                result.append("<input name=\"next\" type=\"submit\" value=\"");
                result.append(this.key("GUI_BUTTON_NEXTSCREEN_0"));
                result.append("\" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            default: {
                super.dialogButtonsHtml(result, button, attribute);
            }
        }
    }

    protected List getListItems() {
        Iterator i;
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        if (this.m_limitedRestypes) {
            List newResTypes = this.m_availableResTypes.indexOf(44) > -1 ? CmsStringUtil.splitAsList(this.m_availableResTypes, ',', true) : CmsStringUtil.splitAsList(this.m_availableResTypes, '|', true);
            Iterator k = newResTypes.iterator();
            ArrayList<CmsExplorerTypeSettings> settings = new ArrayList<CmsExplorerTypeSettings>(newResTypes.size());
            while (k.hasNext()) {
                String resType = (String)k.next();
                CmsExplorerTypeSettings set = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resType);
                if (set == null) continue;
                settings.add(set);
            }
            Collections.sort(settings);
            i = settings.iterator();
        } else {
            i = OpenCms.getWorkplaceManager().getExplorerTypeSettings().iterator();
        }
        CmsResource resource = null;
        try {
            resource = this.getCms().readResource(this.getParamCurrentFolder());
        }
        catch (CmsException e) {
            // empty catch block
        }
        while (i.hasNext()) {
            CmsExplorerTypeSettings settings = (CmsExplorerTypeSettings)i.next();
            if (!this.m_limitedRestypes && (this.m_page != null ? !this.m_page.equals(settings.getNewResourcePage()) : CmsStringUtil.isNotEmpty(settings.getNewResourcePage()))) continue;
            if (CmsStringUtil.isEmpty(settings.getNewResourceUri()) || !settings.isEditable(this.getCms(), resource) || !settings.getAccess().getPermissions(this.getCms(), resource).requiresControlPermission()) continue;
            CmsListItem item = this.getList().newItem(settings.getName());
            item.set("nrcn", this.key(settings.getKey()));
            item.set("nrci", "<img src=\"" + CmsNewResource.getSkinUri() + "filetypes/" + settings.getIcon() + "\" style=\"width: 16px; height: 16px;\" />");
            item.set(LIST_COLUMN_URI, CmsEncoder.encode(settings.getNewResourceUri()));
            ret.add(item);
        }
        return ret;
    }

    protected String getTitle() {
        String title = null;
        CmsExplorerTypeSettings set = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.getParamNewResourceType());
        if (set != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(set.getTitleKey())) {
            title = this.getMessages().key(set.getTitleKey(), true);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(title)) {
            title = CmsStringUtil.isNotEmpty(this.getParamNewResourceType()) ? CmsWorkplaceMessages.getNewResourceTitle(this, this.getParamNewResourceType()) : this.getParamTitle();
        }
        return title;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        this.setAction(0);
        super.initWorkplaceRequestValues(settings, request);
        this.setParamTitle(this.key("GUI_NEWRESOURCE_0"));
        String page = (String)request.getSession(true).getAttribute(SESSION_ATTR_PAGE);
        if (CmsStringUtil.isNotEmpty(this.getParamPage())) {
            this.m_page = this.getParamPage();
            request.getSession(true).setAttribute(SESSION_ATTR_PAGE, (Object)this.m_page);
            this.setParamPage(null);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.getParamNewFormUri()) || this.getParamNewResourceUri().indexOf("?page") != -1) {
                this.setParamNewFormUri(this.getParamNewResourceUri());
                this.setParamNewResourceUri(null);
            }
            if (DIALOG_NEWFORM.equals(this.getParamAction()) || "listindependentaction".equals(this.getParamAction())) {
                this.setParamAction(null);
            }
        } else if (page != null) {
            this.m_page = page;
        }
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if (DIALOG_SUBMITFORM.equals(this.getParamAction())) {
            this.setAction(110);
            this.clearSession();
        } else if (DIALOG_NEWFORM.equals(this.getParamAction())) {
            this.clearSession();
            this.setInitialResourceName();
            this.setAction(100);
            this.setParamTitle(this.getTitle());
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
            this.clearSession();
        }
        String advAttr = (String)request.getSession(true).getAttribute(SESSION_ATTR_ADVANCED);
        if (DIALOG_ADVANCED.equals(this.getParamAction()) || advAttr != null) {
            if (advAttr == null) {
                request.getSession(true).setAttribute(SESSION_ATTR_ADVANCED, (Object)"true");
            }
        } else {
            String newResTypesProperty = "";
            try {
                newResTypesProperty = this.getCms().readPropertyObject(this.getParamCurrentFolder(), "restypes.available", true).getValue();
            }
            catch (CmsException e) {
                // empty catch block
            }
            if (CmsStringUtil.isNotEmpty(newResTypesProperty) && !newResTypesProperty.equals(VALUE_DEFAULT)) {
                this.m_limitedRestypes = true;
                this.m_availableResTypes = newResTypesProperty;
            }
        }
    }

    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        CmsListColumnDefinition uriCol = new CmsListColumnDefinition(LIST_COLUMN_URI);
        uriCol.setName(Messages.get().container("GUI_NEWRESOURCE_LIST_COLS_URI_0"));
        uriCol.setVisible(false);
        metadata.addColumn(uriCol);
        CmsListItemSelectionCustomAction action = (CmsListItemSelectionCustomAction)metadata.getColumnDefinition("nrcs").getDirectAction("rs");
        action.setFieldName(PARAM_NEWRESOURCEURI);
        action.setColumn(LIST_COLUMN_URI);
        action.setAttributes(" onclick=\"enableButton();\"");
    }

    protected void setInitialResourceName() {
        if (this.isCreateIndexMode()) {
            String defaultFile = "";
            try {
                defaultFile = (String)OpenCms.getDefaultFiles().get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (CmsStringUtil.isEmpty(defaultFile)) {
                defaultFile = "index.html";
            }
            this.setParamResource(defaultFile);
        } else {
            this.setParamResource("");
        }
    }
}

