/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer.menu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.menu.CmsMenuRule;
import org.opencms.workplace.explorer.menu.CmsMirActiveNonDeleted;
import org.opencms.workplace.explorer.menu.CmsMirDirectPublish;
import org.opencms.workplace.explorer.menu.CmsMirPrOnlineActive;
import org.opencms.workplace.explorer.menu.CmsMirPrOnlineInactive;
import org.opencms.workplace.explorer.menu.CmsMirPrOnlineInvisible;
import org.opencms.workplace.explorer.menu.CmsMirPrOtherActive;
import org.opencms.workplace.explorer.menu.CmsMirPrOtherInactive;
import org.opencms.workplace.explorer.menu.CmsMirPrOtherInvisible;
import org.opencms.workplace.explorer.menu.CmsMirPrSameLockedActive;
import org.opencms.workplace.explorer.menu.CmsMirPrSameLockedActiveChangedAl;
import org.opencms.workplace.explorer.menu.CmsMirPrSameLockedActiveDeletedAl;
import org.opencms.workplace.explorer.menu.CmsMirPrSameLockedActiveNotDeletedAl;
import org.opencms.workplace.explorer.menu.CmsMirPrSameLockedInvisible;
import org.opencms.workplace.explorer.menu.CmsMirPrSameOtherlockActive;
import org.opencms.workplace.explorer.menu.CmsMirPrSameOtherlockInvisible;
import org.opencms.workplace.explorer.menu.CmsMirPrSameUnlockedActive;
import org.opencms.workplace.explorer.menu.CmsMirPrSameUnlockedActiveDeletedNoAl;
import org.opencms.workplace.explorer.menu.CmsMirPrSameUnlockedActiveNotDeletedNoAl;
import org.opencms.workplace.explorer.menu.CmsMirPrSameUnlockedActiveUnchanged;
import org.opencms.workplace.explorer.menu.CmsMirPrSameUnlockedInactiveNoAl;
import org.opencms.workplace.explorer.menu.CmsMirPrSameUnlockedInactiveNotDeletedNoAl;
import org.opencms.workplace.explorer.menu.CmsMirPrSameUnlockedInvisible;
import org.opencms.workplace.explorer.menu.CmsMirShowSiblings;
import org.opencms.workplace.explorer.menu.I_CmsMenuItemRule;

public class CmsMenuRuleTranslator {
    private static final String MENURULE_LEGACY_DP_FILE = "d d iaaa iaaa dddd";
    private static final String MENURULE_LEGACY_SHOWSIBLINGS = "a a aaaa aaaa aaaa";
    private static final String[] MENURULES = new String[]{"copytoproject", "lock", "changelock", "unlock", "directpublish", "directpublish", "showlocks", "undochanges", "undochanges", "undelete", "copy", "standard", "permissions", "nondeleted", "showsiblings"};
    private static final String[] MENURULES_LEGACY_STRINGS = new String[]{"d a dddd dddd dddd", "d d aaaa dddd dddd", "d d dddd dddd aaaa", "d d dddd aaaa dddd", "d d aaaa aaaa dddd", "d d iaaa iaaa dddd", "d d aaaa aaaa aaaa", "d d iiid aaid dddd", "d d iiid iaid dddd", "d d ddda ddda dddd", "d d aaai aaai dddd", "d d iiii aaai dddd", "a a iiii aaai dddd", "a a aaai aaai aaai", "a a aaaa aaaa aaaa"};
    private static final Object[] TRANS_LOCKEDLOCKRULES = new Object[]{new CmsMirPrSameLockedActive(), new CmsMirPrSameLockedInvisible(), new CmsMirPrSameLockedActiveNotDeletedAl(), new CmsMirPrSameLockedActiveChangedAl(), new CmsMirPrSameLockedActiveDeletedAl()};
    private static final String[] TRANS_LOCKEDLOCKRULES_LEGACY = new String[]{"aaaa", "dddd", "aaai", "aaid", "ddda"};
    private static final List TRANS_LOCKEDLOCKRULES_LEGACY_LIST = Arrays.asList(TRANS_LOCKEDLOCKRULES_LEGACY);
    private static final Object[] TRANS_ONLINERULES = new Object[]{new CmsMirPrOnlineActive(), new CmsMirPrOnlineInactive(), new CmsMirPrOnlineInvisible()};
    private static final String[] TRANS_ONLINERULES_LEGACY = new String[]{"a", "i", "d"};
    private static final List TRANS_ONLINERULES_LEGACY_LIST = Arrays.asList(TRANS_ONLINERULES_LEGACY);
    private static final Object[] TRANS_OTHERLOCKRULES = new Object[]{new CmsMirPrSameOtherlockActive(), new CmsMirPrSameOtherlockInvisible(), new CmsMirActiveNonDeleted()};
    private static final String[] TRANS_OTHERLOCKRULES_LEGACY = new String[]{"aaaa", "dddd", "aaai"};
    private static final List TRANS_OTHERLOCKRULES_LEGACY_LIST = Arrays.asList(TRANS_OTHERLOCKRULES_LEGACY);
    private static final Object[] TRANS_OTHERPROJECTRULES = new Object[]{new CmsMirPrOtherActive(), new CmsMirPrOtherInactive(), new CmsMirPrOtherInvisible()};
    private static final String[] TRANS_OTHERPROJECTRULES_LEGACY = new String[]{"a", "i", "d"};
    private static final List TRANS_OTHERPROJECTRULES_LEGACY_LIST = Arrays.asList(TRANS_OTHERPROJECTRULES_LEGACY);
    private static final Object[] TRANS_UNLOCKEDRULES = new Object[]{new CmsMirPrSameUnlockedActive(), new CmsMirPrSameUnlockedInactiveNoAl(), new CmsMirPrSameUnlockedInvisible(), new CmsMirPrSameUnlockedActiveNotDeletedNoAl(), new CmsMirPrSameUnlockedActiveUnchanged(), new CmsMirPrSameUnlockedInactiveNotDeletedNoAl(), new CmsMirPrSameUnlockedActiveDeletedNoAl()};
    private static final String[] TRANS_UNLOCKEDRULES_LEGACY = new String[]{"aaaa", "iiii", "dddd", "aaai", "iaaa", "iiid", "ddda"};
    private static final List TRANS_UNLOCKEDRULES_LEGACY_LIST = Arrays.asList(TRANS_UNLOCKEDRULES_LEGACY);
    private Map m_ruleMappings;

    public CmsMenuRule createMenuRule(String legacyRules) {
        legacyRules = this.substituteLegacyRules(legacyRules);
        CmsMenuRule menuRule = new CmsMenuRule();
        if (legacyRules.equals(this.substituteLegacyRules(MENURULE_LEGACY_DP_FILE))) {
            menuRule.addMenuItemRule((I_CmsMenuItemRule)TRANS_ONLINERULES[2]);
            menuRule.addMenuItemRule((I_CmsMenuItemRule)TRANS_OTHERPROJECTRULES[2]);
            menuRule.addMenuItemRule(new CmsMirDirectPublish());
        } else if (legacyRules.equals(this.substituteLegacyRules(MENURULE_LEGACY_SHOWSIBLINGS))) {
            menuRule.addMenuItemRule(new CmsMirShowSiblings());
        } else {
            String currentRuleString = legacyRules.substring(0, 1);
            int ruleIndex = TRANS_ONLINERULES_LEGACY_LIST.indexOf(currentRuleString);
            if (ruleIndex != -1) {
                menuRule.addMenuItemRule((I_CmsMenuItemRule)TRANS_ONLINERULES[ruleIndex]);
            }
            if ((ruleIndex = TRANS_OTHERPROJECTRULES_LEGACY_LIST.indexOf(currentRuleString = legacyRules.substring(1, 2))) != -1) {
                menuRule.addMenuItemRule((I_CmsMenuItemRule)TRANS_OTHERPROJECTRULES[ruleIndex]);
            }
            if ((ruleIndex = TRANS_UNLOCKEDRULES_LEGACY_LIST.indexOf(currentRuleString = legacyRules.substring(2, 6))) != -1) {
                menuRule.addMenuItemRule((I_CmsMenuItemRule)TRANS_UNLOCKEDRULES[ruleIndex]);
            }
            if ((ruleIndex = TRANS_LOCKEDLOCKRULES_LEGACY_LIST.indexOf(currentRuleString = legacyRules.substring(6, 10))) != -1) {
                menuRule.addMenuItemRule((I_CmsMenuItemRule)TRANS_LOCKEDLOCKRULES[ruleIndex]);
            }
            if ((ruleIndex = TRANS_OTHERLOCKRULES_LEGACY_LIST.indexOf(currentRuleString = legacyRules.substring(10))) != -1) {
                menuRule.addMenuItemRule((I_CmsMenuItemRule)TRANS_OTHERLOCKRULES[ruleIndex]);
            }
        }
        menuRule.setName("rule_" + legacyRules.hashCode());
        return menuRule;
    }

    public String getMenuRuleName(String legacyRules) {
        return (String)this.getRuleMappings().get(this.substituteLegacyRules(legacyRules));
    }

    public boolean hasMenuRule(String legacyRules) {
        String ruleName = (String)this.getRuleMappings().get(this.substituteLegacyRules(legacyRules));
        if (CmsStringUtil.isNotEmpty(ruleName) && OpenCms.getWorkplaceManager() != null) {
            return OpenCms.getWorkplaceManager().getMenuRule(ruleName) != null;
        }
        return false;
    }

    protected Map getRuleMappings() {
        if (this.m_ruleMappings == null) {
            this.m_ruleMappings = new HashMap(MENURULES_LEGACY_STRINGS.length);
            for (int i = 0; i < MENURULES_LEGACY_STRINGS.length; ++i) {
                try {
                    String ruleName = MENURULES[i];
                    String legacyRule = this.substituteLegacyRules(MENURULES_LEGACY_STRINGS[i]);
                    this.m_ruleMappings.put(legacyRule, ruleName);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.m_ruleMappings;
    }

    protected String substituteLegacyRules(String legacyRules) {
        return CmsStringUtil.substitute(legacyRules, " ", "");
    }
}

