/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.db.Messages;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.galleries.A_CmsGallery;

public class CmsHtmlGallery
extends A_CmsGallery {
    public static final String URI_GALLERY = "/system/workplace/galleries/html_fs.jsp";
    private static final Log LOG = CmsLog.getLog(CmsHtmlGallery.class);
    private static final Integer ORDER_GALLERY = new Integer(40);

    public CmsHtmlGallery() {
    }

    public CmsHtmlGallery(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsHtmlGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String applyButton() {
        if ("view".equals(this.getParamDialogMode())) {
            return this.button(null, null, "apply_in.png", "button.paste", 0);
        }
        if ("widget".equals(this.getParamDialogMode())) {
            String content;
            block4: {
                content = "";
                try {
                    CmsResource res = this.getCms().readResource(this.getParamResourcePath());
                    CmsFile file = this.getCms().readFile(this.getCms().getSitePath(res));
                    content = new String(file.getContents());
                    content = CmsStringUtil.escapeJavaScript(content);
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_READ_RESOURCE_1", this.getParamResourcePath()));
                }
            }
            content = CmsEncoder.escapeXml(content);
            return this.button("javascript:pasteContent('" + content + "')", null, "apply.png", "GUI_BUTTON_PASTE_0", 0);
        }
        return this.button("javascript:pasteContent()", null, "apply.png", "GUI_BUTTON_PASTE_0", 0);
    }

    public String buildGalleryItemPreview() {
        StringBuffer html = new StringBuffer(16);
        try {
            CmsResource res;
            if (CmsStringUtil.isNotEmpty(this.getParamResourcePath()) && (res = this.getCms().readResource(this.getParamResourcePath())) != null) {
                html.append("<p><div id=\"icontent\" width=\"100%\" height=\"100%\">");
                html.append(this.getJsp().getContent(this.getParamResourcePath()));
                html.append("</div></p>");
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return html.toString();
    }

    public int getGalleryItemsTypeId() {
        return CmsResourceTypePlain.getStaticTypeId();
    }

    public Integer getOrder() {
        return ORDER_GALLERY;
    }

    public String getPreviewBodyStyle() {
        return " class=\"dialog\" unselectable=\"on\"";
    }

    public String getPreviewDivStyle() {
        return "style=\"width: 100%; margin-top: 5px\"";
    }

    public String previewButton() {
        return "";
    }

    public String targetSelectBox() {
        return "";
    }
}

