/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import java.awt.Color;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsImageLoader;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.galleries.A_CmsGallery;

public class CmsImageGallery
extends A_CmsGallery {
    public static final String URI_GALLERY = "/system/workplace/galleries/img_fs.jsp";
    private static final Integer ORDER_GALLERY = new Integer(10);
    private CmsImageScaler m_defaultScaleParams;

    public CmsImageGallery() {
    }

    public CmsImageGallery(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsImageGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String applyButton() {
        String width = null;
        String height = null;
        if ("view".equals(this.getParamDialogMode())) {
            return this.button(null, null, "apply_in.png", "GUI_BUTTON_PASTE_0", 0);
        }
        String uri = this.getParamResourcePath();
        if (CmsStringUtil.isEmpty(this.getParamDialogMode())) {
            uri = this.getJsp().link(uri);
            if (CmsImageLoader.isEnabled()) {
                try {
                    CmsProperty imageSize = this.getJsp().getCmsObject().readPropertyObject(this.getParamResourcePath(), "image.size", false);
                    if (!imageSize.isNullProperty()) {
                        CmsImageScaler scaler = new CmsImageScaler(imageSize.getValue());
                        if (scaler.getWidth() > 0) {
                            width = String.valueOf(scaler.getWidth());
                        }
                        if (scaler.getHeight() > 0) {
                            height = String.valueOf(scaler.getHeight());
                        }
                    }
                }
                catch (CmsException e) {
                    // empty catch block
                }
            }
        }
        return this.button("javascript:pasteImage('" + uri + "',document.form.title.value, document.form.title.value," + width + "," + height + ");", null, "apply.png", "GUI_BUTTON_PASTE_0", 0);
    }

    public String buildGalleryItemPreview() {
        StringBuffer html = new StringBuffer(16);
        try {
            CmsResource res;
            if (CmsStringUtil.isNotEmpty(this.getParamResourcePath()) && (res = this.getCms().readResource(this.getParamResourcePath())) != null) {
                html.append("<img alt=\"\" src=\"");
                html.append(this.getJsp().link(this.getParamResourcePath()));
                html.append("\" border=\"0\">");
            }
        }
        catch (CmsException e) {
            CmsLog.getLog(CmsImageGallery.class).error((Object)e);
        }
        return html.toString();
    }

    public CmsImageScaler getDefaultScaleParams() {
        return this.m_defaultScaleParams;
    }

    public int getGalleryItemsTypeId() {
        return CmsResourceTypeImage.getStaticTypeId();
    }

    public Integer getOrder() {
        return ORDER_GALLERY;
    }

    public String getPreviewBodyStyle() {
        return "";
    }

    public void init() {
        if (CmsImageLoader.isEnabled()) {
            this.m_defaultScaleParams = new CmsImageScaler(this.getGalleryTypeParams());
            if (!this.m_defaultScaleParams.isValid()) {
                this.m_defaultScaleParams.setType(0);
                this.m_defaultScaleParams.setPosition(0);
                this.m_defaultScaleParams.setWidth(120);
                this.m_defaultScaleParams.setHeight(90);
                this.m_defaultScaleParams.setColor(new Color(221, 221, 221));
            }
        } else {
            this.m_defaultScaleParams = null;
        }
    }

    public String previewButton() {
        return "";
    }

    public String targetSelectBox() {
        return "";
    }

    protected String buildGalleryItemListCustomEndCols(CmsResource res, String tdClass) {
        if (!CmsImageLoader.isEnabled()) {
            return super.buildGalleryItemListCustomEndCols(res, tdClass);
        }
        StringBuffer result = new StringBuffer(128);
        CmsImageScaler scaler = new CmsImageScaler(this.getCms(), res);
        result.append("\t<td class=\"");
        result.append(tdClass);
        result.append("\" style=\"text-align: right;\">");
        if (scaler.isValid()) {
            result.append(scaler.getWidth());
            result.append("*");
            result.append(scaler.getHeight());
            result.append(" ");
            result.append(this.key("GUI_LABEL_PIXELS_0"));
            result.append(" / ");
        }
        result.append(res.getLength() / 1024);
        result.append(" ");
        result.append(this.key("GUI_LABEL_KILOBYTES_0"));
        result.append("</td>\n");
        return result.toString();
    }

    protected String buildGalleryItemListCustomStartCols(CmsResource res, String tdClass) {
        if (!CmsImageLoader.isEnabled()) {
            return super.buildGalleryItemListCustomStartCols(res, tdClass);
        }
        CmsProperty sizeProp = CmsProperty.getNullProperty();
        try {
            sizeProp = this.getCms().readPropertyObject(res, "image.size", false);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sizeProp.isNullProperty()) {
            return super.buildGalleryItemListCustomStartCols(res, tdClass);
        }
        StringBuffer result = new StringBuffer(128);
        if (this.m_defaultScaleParams != null && this.m_defaultScaleParams.isValid()) {
            String resPath = this.getCms().getSitePath(res);
            result.append("\t<td class=\"");
            result.append(tdClass);
            result.append("\">");
            result.append("<a class=\"");
            result.append(tdClass);
            result.append("\" href=\"javascript: preview('");
            result.append(resPath);
            result.append("');\" title=\"");
            result.append(this.key("GUI_BUTTON_PREVIEW_0"));
            result.append("\">");
            result.append("<img src=\"");
            result.append(this.getJsp().link(resPath + this.m_defaultScaleParams.toRequestParam()));
            result.append("\" border=\"0\" width=\"");
            result.append(this.m_defaultScaleParams.getWidth());
            result.append("\" height=\"");
            result.append(this.m_defaultScaleParams.getHeight());
            result.append("\"></a></td>\n");
            result.append("</td>\n");
        } else {
            result.append(super.buildGalleryItemListCustomStartCols(res, tdClass));
        }
        return result.toString();
    }
}

