/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.galleries.Messages;

public class CmsOpenGallery
extends CmsDialog {
    public static final String DIALOG_TYPE = "opengallery";
    private static final Log LOG = CmsLog.getLog(CmsOpenGallery.class);

    public CmsOpenGallery(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsOpenGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String openGallery() {
        StringBuffer jsOpener = new StringBuffer(32);
        String galleryType = null;
        try {
            CmsResource res = this.getCms().readResource(this.getParamResource());
            if (res != null) {
                String galleryPath = this.getParamResource();
                if (!galleryPath.endsWith("/")) {
                    galleryPath = galleryPath + "/";
                }
                galleryType = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
                String galleryUri = "/system/workplace/galleries/gallery_fs.jsp?gallerytypename=" + galleryType;
                jsOpener.append("window.open('");
                jsOpener.append(this.getJsp().link(galleryUri));
                jsOpener.append("&");
                jsOpener.append("dialogmode");
                jsOpener.append("=");
                jsOpener.append("view");
                jsOpener.append("&");
                jsOpener.append("gallerypath");
                jsOpener.append("=");
                jsOpener.append(galleryPath);
                jsOpener.append("', '");
                jsOpener.append(galleryType);
                jsOpener.append("','width=650, height=700, resizable=yes, top=100, left=270, status=yes');");
            }
        }
        catch (CmsException e) {
            CmsMessageContainer message = Messages.get().container("ERR_OPEN_GALLERY_1", galleryType);
            LOG.error((Object)message.key(), (Throwable)e);
            throw new CmsRuntimeException(message, (Throwable)e);
        }
        return jsOpener.toString();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
    }
}

