/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsUserSettings;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsMultiSelectWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.search.CmsSearchResultsList;
import org.opencms.workplace.search.CmsSearchWorkplaceBean;
import org.opencms.workplace.search.Messages;

public class CmsSearchDialog
extends CmsWidgetDialog {
    public static final String LABEL_FIELD_INFIX = "field.";
    private static final String DIALOG_TYPE = "search";
    private static final String[] PAGES = new String[]{"page1"};
    private CmsSearchWorkplaceBean m_search;

    public CmsSearchDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSearchDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("action", "listselectpage");
            params.put("page", "1");
            params.put("root", "explorer");
            if (this.getSettings().getUserSettings().getWorkplaceSearchViewStyle() == CmsUserSettings.CmsSearchResultStyle.STYLE_EXPLORER) {
                this.getSettings().setExplorerPage(1);
                params.put("showexplorer", Boolean.TRUE);
            } else {
                boolean withExcerpts;
                CmsListMetadata metadata = A_CmsListDialog.getMetadata(CmsSearchResultsList.class.getName());
                boolean bl = withExcerpts = this.getSettings().getUserSettings().getWorkplaceSearchViewStyle() == CmsUserSettings.CmsSearchResultStyle.STYLE_LIST_WITH_EXCERPTS;
                if (metadata == null) {
                    if (!withExcerpts) {
                        params.put("action", "listindependentaction");
                        params.put("listaction", "de");
                    }
                } else {
                    metadata.getItemDetailDefinition("de").setVisible(withExcerpts);
                }
                params.put("showexplorer", Boolean.FALSE);
            }
            this.getToolManager().jspForwardTool(this, "/search/results", params);
        }
        catch (Exception e) {
            errors.add(e);
        }
        this.setCommitErrors(errors);
    }

    public List getFields() {
        CmsSearchIndex index = OpenCms.getSearchManager().getIndex(this.getSettings().getUserSettings().getWorkplaceSearchIndexName());
        ArrayList<CmsSearchField> result = new ArrayList<CmsSearchField>();
        Iterator i = index.getFieldConfiguration().getFields().iterator();
        while (i.hasNext()) {
            CmsSearchField field = (CmsSearchField)i.next();
            if (!field.isIndexed() || !field.isDisplayed()) continue;
            result.add(field);
        }
        return result;
    }

    protected String createDialogHtml(String dialog) {
        CmsSearchIndex index = OpenCms.getSearchManager().getIndex(this.getSettings().getUserSettings().getWorkplaceSearchIndexName());
        if (index == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_INVALID_1", this.getSettings().getUserSettings().getWorkplaceSearchIndexName()));
        }
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.createWidgetBlockStart(this.key("GUI_SEARCH_QUERY_TITLE_0")));
            result.append(this.createDialogRowsHtml(0, 3));
            result.append(this.createWidgetBlockEnd());
            result.append(this.createWidgetBlockStart(this.key("GUI_SEARCH_FIELDS_TITLE_0")));
            result.append(this.createDialogRowsHtml(8, 8));
            result.append(this.createWidgetBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initParams();
        this.addWidget(new CmsWidgetDialogParameter(this, "settings.userSettings.workplaceSearchIndexName", PAGES[0], new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "query", PAGES[0], new CmsInputWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "sortOrder", PAGES[0], new CmsSelectWidget(this.getSortNamesConf())));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "restrictSearch", PAGES[0], new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "minDateCreated", PAGES[0], new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "maxDateCreated", PAGES[0], new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "minDateLastModified", PAGES[0], new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "maxDateLastModified", PAGES[0], new CmsCalendarWidget()));
        this.addWidget(new CmsWidgetDialogParameter(this.m_search, "fields", PAGES[0], new CmsMultiSelectWidget(this.getFieldList(), true)));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_search);
    }

    private List getFieldList() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        try {
            Iterator i = this.getFields().iterator();
            while (i.hasNext()) {
                CmsSearchField field = (CmsSearchField)i.next();
                retVal.add(new CmsSelectWidgetOption(field.getName(), true, this.getMacroResolver().resolveMacros(field.getDisplayName())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private List getSortNamesConf() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        try {
            String[] names = CmsSearchParameters.SORT_NAMES;
            for (int i = 0; i < names.length; ++i) {
                retVal.add(new CmsSelectWidgetOption(names[i], i == 0, this.key("label." + names[i].toLowerCase())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private void initParams() {
        Object o = CmsStringUtil.isEmpty(this.getParamAction()) || "initial".equals(this.getParamAction()) ? null : this.getDialogObject();
        this.m_search = !(o instanceof CmsSearchWorkplaceBean) ? new CmsSearchWorkplaceBean(this.getSettings().getExplorerResource()) : (CmsSearchWorkplaceBean)o;
    }
}

