/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.workplace.threads.CmsDatabaseImportThread;
import org.opencms.workplace.threads.CmsModuleDeleteThread;
import org.opencms.workplace.threads.Messages;

public class CmsModuleReplaceThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsModuleReplaceThread.class);
    private A_CmsReportThread m_deleteThread;
    private A_CmsReportThread m_importThread;
    private String m_moduleName;
    private int m_phase;
    private String m_reportContent;
    private String m_zipName;

    public CmsModuleReplaceThread(CmsObject cms, String moduleName, String zipName) {
        super(cms, Messages.get().getBundle().key("GUI_REPLACE_MODULE_THREAD_NAME_1", moduleName));
        this.m_moduleName = moduleName;
        this.m_zipName = zipName;
        ArrayList<String> modules = new ArrayList<String>();
        modules.add(this.m_moduleName);
        this.m_deleteThread = new CmsModuleDeleteThread(this.getCms(), modules, true);
        this.m_importThread = new CmsDatabaseImportThread(this.getCms(), this.m_zipName, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_REPLACE_THREAD_CONSTRUCTED_0"));
        }
        this.m_phase = 0;
    }

    public static Vector getModuleResources(String moduleName) {
        Vector resNames = new Vector(OpenCms.getModuleManager().getModule(moduleName).getResources());
        return resNames;
    }

    public String getReportUpdate() {
        switch (this.m_phase) {
            case 1: {
                return this.m_deleteThread.getReportUpdate();
            }
            case 2: {
                String content;
                if (this.m_reportContent != null) {
                    content = this.m_reportContent;
                    this.m_reportContent = null;
                } else {
                    content = "";
                }
                return content + this.m_importThread.getReportUpdate();
            }
        }
        return "";
    }

    public void run() {
        block8: {
            block7: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_REPLACE_THREAD_START_DELETE_0"));
                }
                this.m_phase = 1;
                this.m_deleteThread.start();
                try {
                    this.m_deleteThread.join();
                }
                catch (InterruptedException e) {
                    if (!LOG.isErrorEnabled()) break block7;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.m_reportContent = this.m_deleteThread.getReportUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_REPLACE_THREAD_START_IMPORT_0"));
            }
            this.m_phase = 2;
            this.m_importThread.start();
            try {
                this.m_importThread.join();
            }
            catch (InterruptedException e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_REPLACE_THREAD_FINISHED_0"));
        }
    }
}

