/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReportThread;
import org.opencms.workplace.threads.CmsXmlContentRepairSettings;
import org.opencms.workplace.threads.Messages;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsXmlContentRepairThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsXmlContentRepairThread.class);
    private CmsXmlContentRepairSettings m_settings;

    public CmsXmlContentRepairThread(CmsObject cms, CmsXmlContentRepairSettings settings) {
        super(cms, Messages.get().getBundle().key("GUI_XMLCONTENTREPAIR_THREAD_NAME_0"));
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_settings = settings;
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        block2: {
            this.getReport().println(Messages.get().container("RPT_XMLCONTENTREPAIR_BEGIN_2", this.m_settings.getResourceType(), this.m_settings.getVfsFolder()), 2);
            try {
                this.repairXmlContents();
            }
            catch (Throwable f) {
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                this.getReport().println(f);
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)f);
            }
        }
        this.getReport().print(org.opencms.report.Messages.get().container("RPT_STAT_0"));
        this.getReport().println(org.opencms.report.Messages.get().container("RPT_STAT_DURATION_1", this.getReport().formatRuntime()));
        this.getReport().println(Messages.get().container("RPT_XMLCONTENTREPAIR_END_0"), 2);
    }

    private void repairXmlContents() throws CmsException {
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(this.m_settings.getResourceTypeId());
        String path = CmsResource.getFolderPath(this.m_settings.getVfsFolder());
        List resources = this.getCms().readResources(path, filter, this.m_settings.isIncludeSubFolders());
        int count = 0;
        int resSize = resources.size();
        CmsXmlEntityResolver resolver = new CmsXmlEntityResolver(this.getCms());
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            CmsResource res = (CmsResource)i.next();
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(++count), String.valueOf(resSize)), 3);
            this.getReport().print(Messages.get().container("RPT_PROCESSING_XMLCONTENT_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.getCms().getSitePath(res)));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                CmsFile file = this.getCms().readFile(res);
                CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.getCms(), file);
                boolean fixFile = this.m_settings.isForce();
                if (!fixFile) {
                    try {
                        xmlContent.validateXmlStructure(resolver);
                    }
                    catch (CmsXmlException e) {
                        fixFile = true;
                    }
                }
                if (fixFile) {
                    CmsLock lock = this.getCms().getLock(res);
                    boolean isLocked = false;
                    boolean canWrite = false;
                    if (lock.isNullLock()) {
                        this.getCms().lockResource(this.getCms().getSitePath(res));
                        isLocked = true;
                        canWrite = true;
                    } else if (lock.isOwnedBy(this.getCms().getRequestContext().currentUser())) {
                        canWrite = true;
                    }
                    if (canWrite) {
                        xmlContent.setAutoCorrectionEnabled(true);
                        xmlContent.correctXmlStructure(this.getCms());
                        file.setContents(xmlContent.marshal());
                        this.getCms().writeFile(file);
                    } else {
                        this.getReport().println(Messages.get().container("RPT_XMLCONTENTREPAIR_NOTLOCKED_0"), 3);
                    }
                    if (isLocked) {
                        this.getCms().unlockResource(this.getCms().getSitePath(res));
                    }
                    if (!canWrite) continue;
                    this.getReport().println(Messages.get().container("RPT_XMLCONTENTREPAIR_REPAIRED_0"), 4);
                    continue;
                }
                this.getReport().println(Messages.get().container("RPT_XMLCONTENTREPAIR_SKIPFILE_0"), 3);
            }
            catch (CmsException e) {
                this.getReport().println(e);
            }
        }
    }
}

