/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.util.Iterator;
import java.util.List;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;
import org.opencms.workplace.tools.CmsToolGroup;
import org.opencms.workplace.tools.CmsToolMacroResolver;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.I_CmsToolHandler;

public class CmsTool {
    private final CmsIdentifiableObjectContainer m_container = new CmsIdentifiableObjectContainer(true, true);
    private I_CmsToolHandler m_handler;
    private final String m_id;

    public CmsTool(String id, I_CmsToolHandler handler) {
        this.m_id = id;
        this.m_handler = handler;
    }

    public void addToolGroup(CmsToolGroup group) {
        this.m_container.addIdentifiableObject(group.getName(), group);
    }

    public void addToolGroup(CmsToolGroup group, float position) {
        this.m_container.addIdentifiableObject(group.getName(), group, position);
    }

    public String buttonHtml(CmsWorkplace wp) {
        if (!this.m_handler.isVisible(wp)) {
            return "";
        }
        String link = CmsToolManager.linkForToolPath(wp.getJsp(), this.getHandler().getPath(), this.getHandler().getParameters(wp));
        String onClic = "openPage('" + link + "');";
        return A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.BIG_ICON_TEXT, this.getId(), this.m_handler.getShortName(), this.m_handler.isEnabled(wp) ? this.m_handler.getHelpText() : this.m_handler.getDisabledHelpText(), this.m_handler.isEnabled(wp), this.m_handler.getIconPath(), this.m_handler.getConfirmationMessage(), onClic);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsTool) {
            return ((CmsTool)obj).m_id.equals(this.m_id);
        }
        return false;
    }

    public I_CmsToolHandler getHandler() {
        return this.m_handler;
    }

    public String getId() {
        return this.m_id;
    }

    public CmsToolGroup getToolGroup(String name) {
        return (CmsToolGroup)this.m_container.getObject(name);
    }

    public List getToolGroups() {
        return this.m_container.elementList();
    }

    public String groupHtml(CmsWorkplace wp) {
        List subTools = OpenCms.getWorkplaceManager().getToolManager().getToolsForPath(wp, this.getHandler().getPath(), false);
        Iterator itSubTools = subTools.iterator();
        this.m_container.clear();
        while (itSubTools.hasNext()) {
            CmsTool subTool = (CmsTool)itSubTools.next();
            CmsToolGroup group = null;
            String groupName = CmsToolMacroResolver.resolveMacros(subTool.getHandler().getGroup(), wp);
            group = this.getToolGroup(groupName);
            if (group == null) {
                String gid = "group" + this.getToolGroups().size();
                group = new CmsToolGroup(gid, groupName);
                this.addToolGroup(group, subTool.getHandler().getPosition());
            }
            group.addAdminTool(subTool, subTool.getHandler().getPosition());
        }
        StringBuffer html = new StringBuffer(512);
        Iterator itHtml = this.getToolGroups().iterator();
        while (itHtml.hasNext()) {
            CmsToolGroup group = (CmsToolGroup)itHtml.next();
            html.append(group.groupHtml(wp));
        }
        return CmsToolMacroResolver.resolveMacros(html.toString(), wp);
    }

    public int hashCode() {
        return this.m_handler.getName().hashCode();
    }
}

