/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.Messages;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;

public abstract class A_CmsXmlDocument
implements I_CmsXmlDocument {
    protected String m_conversion;
    protected Document m_document;
    protected Map m_elementLocales;
    protected Map m_elementNames;
    protected String m_encoding;
    protected CmsFile m_file;
    protected Set m_locales;
    private Map m_bookmarks = new HashMap();

    protected A_CmsXmlDocument() {
        this.m_locales = new HashSet();
    }

    protected static final String getBookmarkName(String name, Locale locale) {
        StringBuffer result = new StringBuffer(64);
        result.append('/');
        result.append(locale.toString());
        result.append('/');
        result.append(name);
        return result.toString();
    }

    public void copyLocale(List possibleSources, Locale destination) throws CmsXmlException {
        if (this.hasLocale(destination)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_ALREADY_EXISTS_1", destination));
        }
        Iterator i = possibleSources.iterator();
        Locale source = null;
        while (i.hasNext() && source == null) {
            Locale candidate = (Locale)i.next();
            if (!this.hasLocale(candidate)) continue;
            source = candidate;
        }
        if (source == null) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", CmsLocaleManager.getLocaleNames(possibleSources)));
        }
        this.copyLocale(source, destination);
    }

    public void copyLocale(Locale source, Locale destination) throws CmsXmlException {
        if (!this.hasLocale(source)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", source));
        }
        if (this.hasLocale(destination)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_ALREADY_EXISTS_1", destination));
        }
        Element sourceElement = null;
        Element rootNode = this.m_document.getRootElement();
        Iterator i = rootNode.elementIterator();
        String localeStr = source.toString();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String language = element.attributeValue("language", null);
            if (language == null || !localeStr.equals(language)) continue;
            sourceElement = element.createCopy();
            break;
        }
        if (sourceElement == null) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", source));
        }
        sourceElement.addAttribute("language", destination.toString());
        rootNode.add(sourceElement);
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    public CmsFile correctXmlStructure(CmsObject cms) throws CmsXmlException {
        Iterator i = this.m_locales.iterator();
        while (i.hasNext()) {
            Locale locale = (Locale)i.next();
            List names = this.getNames(locale);
            ArrayList<I_CmsXmlContentValue> validValues = new ArrayList<I_CmsXmlContentValue>();
            Iterator j = names.iterator();
            while (j.hasNext()) {
                String name = (String)j.next();
                I_CmsXmlContentValue value = this.getValue(name, locale);
                if (value.isSimpleType()) {
                    String content = value.getStringValue(cms);
                    value.setStringValue(cms, content);
                }
                validValues.add(value);
            }
            if (!this.isAutoCorrectionEnabled()) continue;
            ArrayList<Element> roots = new ArrayList<Element>();
            ArrayList<CmsXmlContentDefinition> rootCds = new ArrayList<CmsXmlContentDefinition>();
            ArrayList<Element> validElements = new ArrayList<Element>();
            Iterator it = validValues.iterator();
            while (it.hasNext()) {
                Element root;
                I_CmsXmlContentValue value = (I_CmsXmlContentValue)it.next();
                Element element = value.getElement();
                validElements.add(element);
                if (!element.supportsParent() || (root = element.getParent()) == null || roots.contains(root)) continue;
                CmsXmlContentDefinition rcd = value.getContentDefinition();
                if (rcd != null) {
                    roots.add(root);
                    rootCds.add(rcd);
                    continue;
                }
                throw new CmsXmlException(Messages.get().container("ERR_CORRECT_NO_CONTENT_DEF_3", value.getName(), value.getTypeName(), value.getPath()));
            }
            for (int le = 0; le < roots.size(); ++le) {
                List elements;
                Element root = (Element)roots.get(le);
                CmsXmlContentDefinition cd = (CmsXmlContentDefinition)rootCds.get(le);
                ArrayList<List> nodeLists = new ArrayList<List>();
                Iterator is = cd.getTypeSequence().iterator();
                while (is.hasNext()) {
                    I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)is.next();
                    String name = type.getName();
                    elements = root.elements(name);
                    if (elements.size() > type.getMaxOccurs()) {
                        for (int lo = elements.size() - 1; lo >= type.getMaxOccurs(); --lo) {
                            elements.remove(lo);
                        }
                    }
                    nodeLists.add(elements);
                }
                List nodeList = root.elements();
                nodeList.clear();
                Iterator in = nodeLists.iterator();
                while (in.hasNext()) {
                    elements = (List)in.next();
                    nodeList.addAll(elements);
                }
                cd.addDefaultXml(cms, this, root, locale);
            }
        }
        if (this.m_file != null) {
            this.m_file.setContents(this.marshal());
        }
        return this.m_file;
    }

    public String getConversion() {
        return this.m_conversion;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public CmsFile getFile() {
        return this.m_file;
    }

    public int getIndexCount(String path, Locale locale) {
        List elements = this.getValues(path, locale);
        if (elements == null) {
            return 0;
        }
        return elements.size();
    }

    public List getLocales() {
        return new ArrayList(this.m_locales);
    }

    public List getLocales(String path) {
        Object result = this.m_elementLocales.get(CmsXmlUtils.createXpath(path, 1));
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList((Set)result);
    }

    public List getNames(Locale locale) {
        Object o = this.m_elementNames.get(locale);
        if (o != null) {
            return new ArrayList((Set)o);
        }
        return Collections.EMPTY_LIST;
    }

    public String getStringValue(CmsObject cms, String path, Locale locale) {
        I_CmsXmlContentValue value = this.getValueInternal(CmsXmlUtils.createXpath(path, 1), locale);
        if (value != null) {
            return value.getStringValue(cms);
        }
        return null;
    }

    public String getStringValue(CmsObject cms, String path, Locale locale, int index) {
        I_CmsXmlContentValue value = this.getValueInternal(CmsXmlUtils.createXpath(path, index + 1), locale);
        if (value != null) {
            return value.getStringValue(cms);
        }
        return null;
    }

    public I_CmsXmlContentValue getValue(String path, Locale locale) {
        return this.getValueInternal(CmsXmlUtils.createXpath(path, 1), locale);
    }

    public I_CmsXmlContentValue getValue(String path, Locale locale, int index) {
        return this.getValueInternal(CmsXmlUtils.createXpath(path, index + 1), locale);
    }

    public List getValues(Locale locale) {
        ArrayList result = new ArrayList();
        String prefix = '/' + locale.toString() + '/';
        Iterator i = this.m_bookmarks.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(prefix)) continue;
            result.add(this.m_bookmarks.get(key));
        }
        Collections.sort(result);
        return result;
    }

    public List getValues(String path, Locale locale) {
        Object o;
        ArrayList<Object> result = new ArrayList<Object>();
        int count = 1;
        String xpath = CmsXmlUtils.createXpath(path, 1);
        xpath = CmsXmlUtils.removeXpathIndex(xpath);
        do {
            String subpath;
            if ((o = this.getBookmark(subpath = CmsXmlUtils.createXpathElement(xpath, count), locale)) == null) continue;
            result.add(o);
            ++count;
        } while (o != null);
        return result;
    }

    public boolean hasLocale(Locale locale) {
        if (locale == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_NULL_LOCALE_0"));
        }
        return this.m_locales.contains(locale);
    }

    public boolean hasValue(String path, Locale locale) {
        return null != this.getBookmark(CmsXmlUtils.createXpath(path, 1), locale);
    }

    public boolean hasValue(String path, Locale locale, int index) {
        return null != this.getBookmark(CmsXmlUtils.createXpath(path, index + 1), locale);
    }

    public void initDocument() {
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    public boolean isEnabled(String path, Locale locale) {
        return this.hasValue(path, locale);
    }

    public boolean isEnabled(String path, Locale locale, int index) {
        return this.hasValue(path, locale, index);
    }

    public byte[] marshal() throws CmsXmlException {
        return ((ByteArrayOutputStream)this.marshal(new ByteArrayOutputStream(), this.m_encoding)).toByteArray();
    }

    public void moveLocale(Locale source, Locale destination) throws CmsXmlException {
        this.copyLocale(source, destination);
        this.removeLocale(source);
    }

    public void removeLocale(Locale locale) throws CmsXmlException {
        if (!this.hasLocale(locale)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", locale));
        }
        Element rootNode = this.m_document.getRootElement();
        Iterator i = rootNode.elementIterator();
        String localeStr = locale.toString();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String language = element.attributeValue("language", null);
            if (language == null || !localeStr.equals(language)) continue;
            element.detach();
            break;
        }
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    public void setConversion(String conversion) {
        this.m_conversion = conversion;
    }

    public String toString() {
        try {
            return CmsXmlUtils.marshal(this.m_document, this.m_encoding);
        }
        catch (CmsXmlException e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_WRITE_XML_DOC_TO_STRING_0"), (Throwable)e);
        }
    }

    public void validateXmlStructure(EntityResolver resolver) throws CmsXmlException {
        if (this.m_file != null) {
            byte[] xmlData = null;
            xmlData = this.m_file.getContents();
            CmsXmlUtils.validateXmlStructure(xmlData, resolver);
        } else {
            CmsXmlUtils.validateXmlStructure(this.m_document, this.m_encoding, resolver);
        }
    }

    protected void addBookmark(String path, Locale locale, boolean enabled, Object value) {
        HashSet<Object> set;
        Object o;
        this.addLocale(locale);
        this.m_bookmarks.put(A_CmsXmlDocument.getBookmarkName(path, locale), value);
        if (enabled) {
            o = this.m_elementLocales.get(path);
            if (o != null) {
                ((Set)o).add(locale);
            } else {
                set = new HashSet<Object>();
                set.add(locale);
                this.m_elementLocales.put(path, set);
            }
        }
        if ((o = this.m_elementNames.get(locale)) != null) {
            ((Set)o).add(path);
        } else {
            set = new HashSet();
            set.add(path);
            this.m_elementNames.put(locale, set);
        }
    }

    protected void addLocale(Locale locale) {
        this.m_locales.add(locale);
    }

    protected void clearBookmarks() {
        this.m_bookmarks.clear();
    }

    protected Element createDeepElementCopy(Element element, Set copyElements) {
        return this.createDeepElementCopyInternal(null, null, element, copyElements);
    }

    protected Object getBookmark(String bookmark) {
        return this.m_bookmarks.get(bookmark);
    }

    protected Object getBookmark(String path, Locale locale) {
        return this.m_bookmarks.get(A_CmsXmlDocument.getBookmarkName(path, locale));
    }

    protected Set getBookmarks() {
        return this.m_bookmarks.keySet();
    }

    protected abstract void initDocument(Document var1, String var2, CmsXmlContentDefinition var3);

    protected boolean isAutoCorrectionEnabled() {
        return false;
    }

    protected OutputStream marshal(OutputStream out, String encoding) throws CmsXmlException {
        return CmsXmlUtils.marshal(this.m_document, out, encoding);
    }

    protected I_CmsXmlContentValue removeBookmark(String path, Locale locale) {
        Object o = this.m_elementLocales.get(path);
        if (o != null) {
            ((Set)o).remove(locale);
        }
        if ((o = this.m_elementNames.get(locale)) != null) {
            ((Set)o).remove(path);
        }
        return (I_CmsXmlContentValue)this.m_bookmarks.remove(A_CmsXmlDocument.getBookmarkName(path, locale));
    }

    private Element createDeepElementCopyInternal(String parentPath, Element parent, Element element, Set copyElements) {
        String elName = element.getName();
        if (parentPath != null) {
            Element first = element.getParent().element(elName);
            int elIndex = element.getParent().indexOf((Node)element) - first.getParent().indexOf((Node)first) + 1;
            elName = parentPath + (parentPath.length() > 0 ? "/" : "") + elName.concat("[" + elIndex + "]");
        }
        if (parentPath == null || copyElements.contains(elName)) {
            Element copy = element.createCopy();
            if (parentPath != null) {
                parent.add(copy);
            }
            boolean copyNested = parentPath == null;
            Iterator i = copyElements.iterator();
            while (!copyNested && i.hasNext()) {
                String path = (String)i.next();
                copyNested = !elName.equals(path) && path.startsWith(elName);
            }
            if (copyNested) {
                copy.clearContent();
                i = element.elementIterator();
                while (i.hasNext()) {
                    Element el = (Element)i.next();
                    this.createDeepElementCopyInternal(parentPath == null ? "" : elName, copy, el, copyElements);
                }
            }
            return copy;
        }
        return null;
    }

    private I_CmsXmlContentValue getValueInternal(String path, Locale locale) {
        Object value = this.getBookmark(path, locale);
        if (value != null) {
            return (I_CmsXmlContentValue)value;
        }
        return null;
    }
}

