/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlComplexTypeSequence;
import org.opencms.xml.CmsXmlContentTypeManager;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.Messages;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CmsXmlContentDefinition
implements Cloneable {
    public static final String XSD_ATTRIBUTE_DEFAULT = "default";
    public static final String XSD_ATTRIBUTE_ELEMENT_FORM_DEFAULT = "elementFormDefault";
    public static final String XSD_ATTRIBUTE_MAX_OCCURS = "maxOccurs";
    public static final String XSD_ATTRIBUTE_MIN_OCCURS = "minOccurs";
    public static final String XSD_ATTRIBUTE_NAME = "name";
    public static final String XSD_ATTRIBUTE_SCHEMA_LOCATION = "schemaLocation";
    public static final String XSD_ATTRIBUTE_TYPE = "type";
    public static final String XSD_ATTRIBUTE_USE = "use";
    public static final String XSD_ATTRIBUTE_VALUE_LANGUAGE = "language";
    public static final String XSD_ATTRIBUTE_VALUE_OPTIONAL = "optional";
    public static final String XSD_ATTRIBUTE_VALUE_QUALIFIED = "qualified";
    public static final String XSD_ATTRIBUTE_VALUE_REQUIRED = "required";
    public static final String XSD_ATTRIBUTE_VALUE_UNBOUNDED = "unbounded";
    public static final String XSD_ATTRIBUTE_VALUE_ZERO = "0";
    public static final String XSD_INCLUDE_OPENCMS = "opencms://opencms-xmlcontent.xsd";
    public static final Namespace XSD_NAMESPACE = Namespace.get((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    public static final QName XSD_NODE_ANNOTATION = QName.get((String)"annotation", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_APPINFO = QName.get((String)"appinfo", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_ATTRIBUTE = QName.get((String)"attribute", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_COMPLEXTYPE = QName.get((String)"complexType", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_ELEMENT = QName.get((String)"element", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_INCLUDE = QName.get((String)"include", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_SCHEMA = QName.get((String)"schema", (Namespace)XSD_NAMESPACE);
    public static final QName XSD_NODE_SEQUENCE = QName.get((String)"sequence", (Namespace)XSD_NAMESPACE);
    private I_CmsXmlContentHandler m_contentHandler;
    private Set m_includes;
    private String m_innerName;
    private String m_outerName;
    private String m_schemaLocation;
    private String m_typeName;
    private Map m_types;
    private List m_typeSequence;

    public CmsXmlContentDefinition(String innerName, String schemaLocation) {
        this(innerName + "s", innerName, schemaLocation);
    }

    public CmsXmlContentDefinition(String outerName, String innerName, String schemaLocation) {
        this.m_outerName = outerName;
        this.m_innerName = innerName;
        this.setInnerName(innerName);
        this.m_typeSequence = new ArrayList();
        this.m_types = new HashMap();
        this.m_includes = new HashSet();
        this.m_schemaLocation = schemaLocation;
        this.m_contentHandler = new CmsDefaultXmlContentHandler();
    }

    protected CmsXmlContentDefinition() {
    }

    public static CmsXmlContentDefinition unmarshal(byte[] xmlData, String schemaLocation, EntityResolver resolver) throws CmsXmlException {
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation, resolver);
        if (result == null) {
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(xmlData, resolver), schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(CmsObject cms, String resourcename) throws CmsXmlException {
        CmsXmlEntityResolver resolver = new CmsXmlEntityResolver(cms);
        String schemaLocation = "opencms://".concat(resourcename.substring(1));
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation, resolver);
        if (result == null) {
            InputSource source = resolver.resolveEntity(null, schemaLocation);
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(source, (EntityResolver)resolver), schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(Document document, String schemaLocation) throws CmsXmlException {
        EntityResolver resolver = document.getEntityResolver();
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation, resolver);
        if (result == null) {
            result = CmsXmlContentDefinition.unmarshalInternal(document, schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(InputSource source, String schemaLocation, EntityResolver resolver) throws CmsXmlException {
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation, resolver);
        if (result == null) {
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(source, resolver), schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(String schemaLocation, EntityResolver resolver) throws CmsXmlException, SAXException, IOException {
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation, resolver);
        if (result == null) {
            InputSource source = resolver.resolveEntity(null, schemaLocation);
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(source, resolver), schemaLocation, resolver);
        }
        return result;
    }

    public static CmsXmlContentDefinition unmarshal(String xmlData, String schemaLocation, EntityResolver resolver) throws CmsXmlException {
        CmsXmlContentDefinition result = CmsXmlContentDefinition.getCachedContentDefinition(schemaLocation, resolver);
        if (result == null) {
            result = CmsXmlContentDefinition.unmarshalInternal(CmsXmlUtils.unmarshalHelper(xmlData, resolver), schemaLocation, resolver);
        }
        return result;
    }

    protected static String createTypeName(String name) {
        StringBuffer result = new StringBuffer(32);
        result.append("OpenCms");
        result.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            result.append(name.substring(1));
        }
        return result.toString();
    }

    protected static String validateAttribute(Element element, String attributeName, String requiredValue) throws CmsXmlException {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_MISSING_ATTRIBUTE_2", element.getUniquePath(), attributeName));
        }
        String value = attribute.getValue();
        if (requiredValue == null) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(value) || !value.equals(value.trim())) {
                throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_WS_3", element.getUniquePath(), attributeName, value));
            }
        } else if (!requiredValue.equals(value)) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_BAD_ATTRIBUTE_VALUE_4", new Object[]{element.getUniquePath(), attributeName, requiredValue, value}));
        }
        return value;
    }

    protected static void validateAttributesExists(Element element, String[] requiredAttributes, String[] optionalAttributes) throws CmsXmlException {
        if (element.attributeCount() < requiredAttributes.length) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_ATTRIBUTE_TOOFEW_3", element.getUniquePath(), new Integer(requiredAttributes.length), new Integer(element.attributeCount())));
        }
        if (element.attributeCount() > requiredAttributes.length + optionalAttributes.length) {
            throw new CmsXmlException(Messages.get().container("ERR_EL_ATTRIBUTE_TOOMANY_3", element.getUniquePath(), new Integer(requiredAttributes.length + optionalAttributes.length), new Integer(element.attributeCount())));
        }
        List attributes = element.attributes();
        for (int i = 0; i < requiredAttributes.length; ++i) {
            String attributeName = requiredAttributes[i];
            if (element.attribute(attributeName) != null) continue;
            throw new CmsXmlException(Messages.get().container("ERR_EL_MISSING_ATTRIBUTE_2", element.getUniquePath(), attributeName));
        }
        List<String> rA = Arrays.asList(requiredAttributes);
        List<String> oA = Arrays.asList(optionalAttributes);
        for (int i = 0; i < attributes.size(); ++i) {
            String attributeName = element.attribute(i).getName();
            if (rA.contains(attributeName) || oA.contains(attributeName)) continue;
            throw new CmsXmlException(Messages.get().container("ERR_EL_INVALID_ATTRIBUTE_2", element.getUniquePath(), attributeName));
        }
    }

    protected static CmsXmlComplexTypeSequence validateComplexTypeSequence(Element element, Set includes) throws CmsXmlException {
        Element typeSequence;
        CmsXmlContentDefinition.validateAttributesExists(element, new String[]{XSD_ATTRIBUTE_NAME}, new String[0]);
        String name = CmsXmlContentDefinition.validateAttribute(element, XSD_ATTRIBUTE_NAME, null);
        List mainElements = element.elements();
        if (mainElements.size() != 1 && mainElements.size() != 2) {
            throw new CmsXmlException(Messages.get().container("ERR_TS_SUBELEMENT_COUNT_2", element.getUniquePath(), new Integer(mainElements.size())));
        }
        boolean hasLanguageAttribute = false;
        if (mainElements.size() == 2) {
            Element typeAttribute = (Element)mainElements.get(1);
            if (!XSD_NODE_ATTRIBUTE.equals((Object)typeAttribute.getQName())) {
                throw new CmsXmlException(Messages.get().container("ERR_CD_ELEMENT_NAME_3", typeAttribute.getUniquePath(), XSD_NODE_ATTRIBUTE.getQualifiedName(), typeAttribute.getQName().getQualifiedName()));
            }
            CmsXmlContentDefinition.validateAttribute(typeAttribute, XSD_ATTRIBUTE_NAME, XSD_ATTRIBUTE_VALUE_LANGUAGE);
            CmsXmlContentDefinition.validateAttribute(typeAttribute, XSD_ATTRIBUTE_TYPE, "OpenCmsLocale");
            try {
                CmsXmlContentDefinition.validateAttribute(typeAttribute, XSD_ATTRIBUTE_USE, XSD_ATTRIBUTE_VALUE_REQUIRED);
            }
            catch (CmsXmlException e) {
                CmsXmlContentDefinition.validateAttribute(typeAttribute, XSD_ATTRIBUTE_USE, XSD_ATTRIBUTE_VALUE_OPTIONAL);
            }
            hasLanguageAttribute = true;
        }
        if (!XSD_NODE_SEQUENCE.equals((Object)(typeSequence = (Element)mainElements.get(0)).getQName())) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_ELEMENT_NAME_3", typeSequence.getUniquePath(), XSD_NODE_SEQUENCE.getQualifiedName(), typeSequence.getQName().getQualifiedName()));
        }
        List typeSequenceElements = typeSequence.elements();
        if (typeSequenceElements.size() < 1) {
            throw new CmsXmlException(Messages.get().container("ERR_TS_SUBELEMENT_TOOFEW_3", typeSequence.getUniquePath(), new Integer(1), new Integer(typeSequenceElements.size())));
        }
        ArrayList<I_CmsXmlSchemaType> sequence = new ArrayList<I_CmsXmlSchemaType>();
        if (hasLanguageAttribute) {
            CmsXmlContentTypeManager typeManager = OpenCms.getXmlContentTypeManager();
            Iterator i = typeSequenceElements.iterator();
            while (i.hasNext()) {
                sequence.add(typeManager.getContentType((Element)i.next(), includes));
            }
        } else {
            Element e = (Element)typeSequenceElements.get(0);
            String typeName = CmsXmlContentDefinition.validateAttribute(e, XSD_ATTRIBUTE_NAME, null);
            String minOccurs = CmsXmlContentDefinition.validateAttribute(e, XSD_ATTRIBUTE_MIN_OCCURS, XSD_ATTRIBUTE_VALUE_ZERO);
            String maxOccurs = CmsXmlContentDefinition.validateAttribute(e, XSD_ATTRIBUTE_MAX_OCCURS, XSD_ATTRIBUTE_VALUE_UNBOUNDED);
            CmsXmlContentDefinition.validateAttribute(e, XSD_ATTRIBUTE_TYPE, CmsXmlContentDefinition.createTypeName(typeName));
            CmsXmlNestedContentDefinition cd = new CmsXmlNestedContentDefinition(null, typeName, minOccurs, maxOccurs);
            sequence.add(cd);
        }
        return new CmsXmlComplexTypeSequence(name, sequence, hasLanguageAttribute);
    }

    private static CmsXmlContentDefinition getCachedContentDefinition(String schemaLocation, EntityResolver resolver) {
        if (resolver instanceof CmsXmlEntityResolver) {
            CmsXmlEntityResolver cmsResolver = (CmsXmlEntityResolver)resolver;
            return cmsResolver.getCachedContentDefinition(schemaLocation);
        }
        return null;
    }

    private static CmsXmlContentDefinition unmarshalInternal(Document document, String schemaLocation, EntityResolver resolver) throws CmsXmlException {
        String className;
        Element handlerElement;
        List appinfos;
        List elements;
        Element root = document.getRootElement();
        if (!XSD_NODE_SCHEMA.equals((Object)root.getQName())) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_NO_SCHEMA_NODE_0"));
        }
        List includes = root.elements(XSD_NODE_INCLUDE);
        if (includes.size() < 1) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_ONE_INCLUDE_REQUIRED_0"));
        }
        Element include = (Element)includes.get(0);
        String target = CmsXmlContentDefinition.validateAttribute(include, XSD_ATTRIBUTE_SCHEMA_LOCATION, null);
        if (!XSD_INCLUDE_OPENCMS.equals(target)) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_FIRST_INCLUDE_2", XSD_INCLUDE_OPENCMS, target));
        }
        HashSet<CmsXmlContentDefinition> nestedDefinitions = new HashSet<CmsXmlContentDefinition>();
        if (includes.size() > 1) {
            for (int i = 1; i < includes.size(); ++i) {
                Element inc = (Element)includes.get(i);
                String schemaLoc = CmsXmlContentDefinition.validateAttribute(inc, XSD_ATTRIBUTE_SCHEMA_LOCATION, null);
                InputSource source = null;
                try {
                    source = resolver.resolveEntity(null, schemaLoc);
                }
                catch (Exception e) {
                    throw new CmsXmlException(Messages.get().container("ERR_CD_BAD_INCLUDE_1", schemaLoc));
                }
                CmsXmlContentDefinition xmlContentDefinition = CmsXmlContentDefinition.unmarshal(source, schemaLoc, resolver);
                nestedDefinitions.add(xmlContentDefinition);
            }
        }
        if ((elements = root.elements(XSD_NODE_ELEMENT)).size() != 1) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_ROOT_ELEMENT_COUNT_1", XSD_INCLUDE_OPENCMS, new Integer(elements.size())));
        }
        Element main = (Element)elements.get(0);
        String name = CmsXmlContentDefinition.validateAttribute(main, XSD_ATTRIBUTE_NAME, null);
        List complexTypes = root.elements(XSD_NODE_COMPLEXTYPE);
        if (complexTypes.size() != 2) {
            throw new CmsXmlException(Messages.get().container("ERR_CD_COMPLEX_TYPE_COUNT_1", new Integer(complexTypes.size())));
        }
        CmsXmlContentDefinition result = new CmsXmlContentDefinition(name, null, schemaLocation);
        result.m_includes = nestedDefinitions;
        ArrayList<CmsXmlComplexTypeSequence> complexTypeData = new ArrayList<CmsXmlComplexTypeSequence>();
        Iterator ct = complexTypes.iterator();
        while (ct.hasNext()) {
            Element e = (Element)ct.next();
            CmsXmlComplexTypeSequence sequence = CmsXmlContentDefinition.validateComplexTypeSequence(e, nestedDefinitions);
            complexTypeData.add(sequence);
        }
        CmsXmlComplexTypeSequence outerSequence = (CmsXmlComplexTypeSequence)complexTypeData.get(0);
        CmsXmlNestedContentDefinition outer = (CmsXmlNestedContentDefinition)outerSequence.m_sequence.get(0);
        String outerTypeName = CmsXmlContentDefinition.createTypeName(name);
        String innerTypeName = CmsXmlContentDefinition.createTypeName(outer.getName());
        CmsXmlContentDefinition.validateAttribute((Element)complexTypes.get(0), XSD_ATTRIBUTE_NAME, outerTypeName);
        CmsXmlContentDefinition.validateAttribute((Element)complexTypes.get(1), XSD_ATTRIBUTE_NAME, innerTypeName);
        CmsXmlContentDefinition.validateAttribute(main, XSD_ATTRIBUTE_TYPE, outerTypeName);
        result.setInnerName(outer.getName());
        CmsXmlComplexTypeSequence innerSequence = (CmsXmlComplexTypeSequence)complexTypeData.get(1);
        Iterator it = innerSequence.m_sequence.iterator();
        while (it.hasNext()) {
            result.addType((I_CmsXmlSchemaType)it.next());
        }
        List annotations = root.elements(XSD_NODE_ANNOTATION);
        I_CmsXmlContentHandler contentHandler = null;
        Element appInfoElement = null;
        if (annotations.size() > 0 && (appinfos = ((Element)annotations.get(0)).elements(XSD_NODE_APPINFO)).size() > 0 && (handlerElement = (appInfoElement = (Element)appinfos.get(0)).element("handler")) != null && (className = handlerElement.attributeValue("class")) != null) {
            contentHandler = OpenCms.getXmlContentTypeManager().getContentHandler(className, schemaLocation);
        }
        if (contentHandler == null) {
            contentHandler = OpenCms.getXmlContentTypeManager().getContentHandler(CmsDefaultXmlContentHandler.class.getName(), name);
        }
        contentHandler.initialize(appInfoElement, result);
        result.m_contentHandler = contentHandler;
        result.freeze();
        if (resolver instanceof CmsXmlEntityResolver) {
            ((CmsXmlEntityResolver)resolver).cacheContentDefinition(schemaLocation, result);
        }
        return result;
    }

    public Element addDefaultXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Iterator i = this.m_typeSequence.iterator();
        int currentPos = 0;
        List allElements = root.elements();
        while (i.hasNext()) {
            I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)i.next();
            String elementName = type.getName();
            List elements = root.elements(elementName);
            currentPos += elements.size();
            for (int j = elements.size(); j < type.getMinOccurs(); ++j) {
                Element typeElement = type.generateXml(cms, document, root, locale);
                I_CmsXmlContentValue value = type.createValue(document, typeElement, locale);
                String defaultValue = document.getContentDefinition().getContentHandler().getDefault(cms, value, locale);
                if (defaultValue != null) {
                    value.setStringValue(cms, defaultValue);
                }
                typeElement.detach();
                allElements.add(currentPos, typeElement);
                ++currentPos;
            }
        }
        return root;
    }

    public void addInclude(CmsXmlContentDefinition nestedSchema) {
        this.m_includes.add(nestedSchema);
    }

    public void addType(I_CmsXmlSchemaType type) throws CmsXmlException {
        CmsXmlContentTypeManager typeManager = OpenCms.getXmlContentTypeManager();
        if (type.isSimpleType() && typeManager.getContentType(type.getTypeName()) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_UNREGISTERED_TYPE_1", type.getTypeName()));
        }
        this.m_typeSequence.add(type);
        this.m_types.put(type.getName(), type);
        type.setContentDefinition(this);
    }

    public Object clone() {
        CmsXmlContentDefinition result = new CmsXmlContentDefinition();
        result.m_innerName = this.m_innerName;
        result.m_schemaLocation = this.m_schemaLocation;
        result.m_typeSequence = this.m_typeSequence;
        result.m_types = this.m_types;
        result.m_contentHandler = this.m_contentHandler;
        result.m_typeName = this.m_typeName;
        result.m_includes = this.m_includes;
        return result;
    }

    public Element createDefaultXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Iterator i = this.m_typeSequence.iterator();
        while (i.hasNext()) {
            I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)i.next();
            for (int j = 0; j < type.getMinOccurs(); ++j) {
                Element typeElement = type.generateXml(cms, document, root, locale);
                I_CmsXmlContentValue value = type.createValue(document, typeElement, locale);
                String defaultValue = document.getContentDefinition().getContentHandler().getDefault(cms, value, locale);
                if (defaultValue == null) continue;
                value.setStringValue(cms, defaultValue);
            }
        }
        return root;
    }

    public Document createDocument(CmsObject cms, I_CmsXmlDocument document, Locale locale) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement(this.getOuterName());
        root.add(I_CmsXmlSchemaType.XSI_NAMESPACE);
        root.addAttribute(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION, this.getSchemaLocation());
        this.createLocale(cms, document, root, locale);
        return doc;
    }

    public Element createLocale(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getInnerName());
        element.addAttribute(XSD_ATTRIBUTE_VALUE_LANGUAGE, locale.toString());
        return this.createDefaultXml(cms, document, element, locale);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CmsXmlContentDefinition)) {
            return false;
        }
        CmsXmlContentDefinition other = (CmsXmlContentDefinition)obj;
        if (!this.getInnerName().equals(other.getInnerName())) {
            return false;
        }
        if (!this.getOuterName().equals(other.getOuterName())) {
            return false;
        }
        return ((Object)this.m_typeSequence).equals(other.m_typeSequence);
    }

    public void freeze() {
        this.m_types = Collections.unmodifiableMap(this.m_types);
        this.m_typeSequence = Collections.unmodifiableList(this.m_typeSequence);
    }

    public I_CmsXmlContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public Set getIncludes() {
        return this.m_includes;
    }

    public String getInnerName() {
        return this.m_innerName;
    }

    public String getOuterName() {
        return this.m_outerName;
    }

    public Document getSchema() {
        Document schema = DocumentHelper.createDocument();
        Element root = schema.addElement(XSD_NODE_SCHEMA);
        root.addAttribute(XSD_ATTRIBUTE_ELEMENT_FORM_DEFAULT, XSD_ATTRIBUTE_VALUE_QUALIFIED);
        Element include = root.addElement(XSD_NODE_INCLUDE);
        include.addAttribute(XSD_ATTRIBUTE_SCHEMA_LOCATION, XSD_INCLUDE_OPENCMS);
        if (this.m_includes.size() > 0) {
            Iterator i = this.m_includes.iterator();
            while (i.hasNext()) {
                CmsXmlContentDefinition definition = (CmsXmlContentDefinition)i.next();
                root.addElement(XSD_NODE_INCLUDE).addAttribute(XSD_ATTRIBUTE_SCHEMA_LOCATION, definition.m_schemaLocation);
            }
        }
        String outerTypeName = CmsXmlContentDefinition.createTypeName(this.getOuterName());
        String innerTypeName = CmsXmlContentDefinition.createTypeName(this.getInnerName());
        Element content = root.addElement(XSD_NODE_ELEMENT);
        content.addAttribute(XSD_ATTRIBUTE_NAME, this.getOuterName());
        content.addAttribute(XSD_ATTRIBUTE_TYPE, outerTypeName);
        Element list = root.addElement(XSD_NODE_COMPLEXTYPE);
        list.addAttribute(XSD_ATTRIBUTE_NAME, outerTypeName);
        Element listSequence = list.addElement(XSD_NODE_SEQUENCE);
        Element listElement = listSequence.addElement(XSD_NODE_ELEMENT);
        listElement.addAttribute(XSD_ATTRIBUTE_NAME, this.getInnerName());
        listElement.addAttribute(XSD_ATTRIBUTE_TYPE, innerTypeName);
        listElement.addAttribute(XSD_ATTRIBUTE_MIN_OCCURS, XSD_ATTRIBUTE_VALUE_ZERO);
        listElement.addAttribute(XSD_ATTRIBUTE_MAX_OCCURS, XSD_ATTRIBUTE_VALUE_UNBOUNDED);
        Element main = root.addElement(XSD_NODE_COMPLEXTYPE);
        main.addAttribute(XSD_ATTRIBUTE_NAME, innerTypeName);
        Element mainSequence = main.addElement(XSD_NODE_SEQUENCE);
        Iterator i = this.m_typeSequence.iterator();
        while (i.hasNext()) {
            I_CmsXmlSchemaType schemaType = (I_CmsXmlSchemaType)i.next();
            schemaType.appendXmlSchema(mainSequence);
        }
        Element language = main.addElement(XSD_NODE_ATTRIBUTE);
        language.addAttribute(XSD_ATTRIBUTE_NAME, XSD_ATTRIBUTE_VALUE_LANGUAGE);
        language.addAttribute(XSD_ATTRIBUTE_TYPE, "OpenCmsLocale");
        language.addAttribute(XSD_ATTRIBUTE_USE, XSD_ATTRIBUTE_VALUE_REQUIRED);
        return schema;
    }

    public String getSchemaLocation() {
        return this.m_schemaLocation;
    }

    public I_CmsXmlSchemaType getSchemaType(String elementPath) {
        String path = CmsXmlUtils.getFirstXpathElement(elementPath);
        I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)this.m_types.get(path);
        if (type == null) {
            return null;
        }
        if (type.isSimpleType() || !CmsXmlUtils.isDeepXpath(elementPath)) {
            return type;
        }
        CmsXmlNestedContentDefinition nestedDefinition = (CmsXmlNestedContentDefinition)type;
        path = CmsXmlUtils.removeFirstXpathElement(elementPath);
        return nestedDefinition.getNestedContentDefinition().getSchemaType(path);
    }

    public Set getSchemaTypes() {
        return this.m_types.keySet();
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public List getTypeSequence() {
        return this.m_typeSequence;
    }

    public int hashCode() {
        return this.getInnerName().hashCode();
    }

    protected void setInnerName(String innerName) {
        this.m_innerName = innerName;
        if (this.m_innerName != null) {
            this.m_typeName = CmsXmlContentDefinition.createTypeName(innerName);
        }
    }

    protected void setOuterName(String outerName) {
        this.m_outerName = outerName;
    }
}

