/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.Messages;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CmsXmlEntityResolver
implements EntityResolver,
I_CmsEventListener {
    public static final String OPENCMS_SCHEME = "opencms://";
    private static final Log LOG = CmsLog.getLog(CmsXmlEntityResolver.class);
    private static Map m_cacheContentDefinitions;
    private static Map m_cachePermanent;
    private static Map m_cacheTemporary;
    private static final String XMLPAGE_OLD_DTD_LOCATION = "org/opencms/xml/page/xmlpage.dtd";
    private static final String XMLPAGE_OLD_DTD_SYSTEM_ID_1 = "http://www.opencms.org/dtd/6.0/xmlpage.dtd";
    private static final String XMLPAGE_OLD_DTD_SYSTEM_ID_2 = "/system/shared/page.dtd";
    private static final String XMLPAGE_XSD_LOCATION = "org/opencms/xml/page/xmlpage.xsd";
    private CmsObject m_cms;

    public CmsXmlEntityResolver(CmsObject cms) {
        CmsXmlEntityResolver.initCaches();
        this.m_cms = cms;
    }

    public static void cacheSystemId(String systemId, byte[] content) {
        CmsXmlEntityResolver.initCaches();
        m_cachePermanent.put(systemId, content);
    }

    protected static void initialize(CmsObject adminCms, byte[] typeSchemaBytes) {
        CmsXmlEntityResolver resolver = new CmsXmlEntityResolver(adminCms);
        OpenCms.addCmsEventListener(resolver, new int[]{5, 2, 11, 22, 25});
        CmsXmlEntityResolver.cacheSystemId("opencms://opencms-xmlcontent.xsd", typeSchemaBytes);
    }

    private static void initCaches() {
        LRUMap cacheContentDefinitions;
        HashMap cachePermanent;
        LRUMap cacheTemporary;
        if (m_cacheTemporary == null) {
            cacheTemporary = new LRUMap(128);
            m_cacheTemporary = Collections.synchronizedMap(cacheTemporary);
            cachePermanent = new HashMap(32);
            m_cachePermanent = Collections.synchronizedMap(cachePermanent);
            cacheContentDefinitions = new LRUMap(64);
            m_cacheContentDefinitions = Collections.synchronizedMap(cacheContentDefinitions);
        }
        if (OpenCms.getRunLevel() > 1 && OpenCms.getMemoryMonitor() != null && !OpenCms.getMemoryMonitor().isMonitoring(CmsXmlEntityResolver.class.getName() + ".cacheTemporary")) {
            cacheTemporary = new LRUMap(128);
            cacheTemporary.putAll(m_cacheTemporary);
            m_cacheTemporary = Collections.synchronizedMap(cacheTemporary);
            OpenCms.getMemoryMonitor().register(CmsXmlEntityResolver.class.getName() + ".cacheTemporary", cacheTemporary);
            cachePermanent = new HashMap(32);
            cachePermanent.putAll(m_cachePermanent);
            m_cachePermanent = Collections.synchronizedMap(cachePermanent);
            OpenCms.getMemoryMonitor().register(CmsXmlEntityResolver.class.getName() + ".cachePermanent", cachePermanent);
            cacheContentDefinitions = new LRUMap(64);
            cacheContentDefinitions.putAll(m_cacheContentDefinitions);
            m_cacheContentDefinitions = Collections.synchronizedMap(cacheContentDefinitions);
            OpenCms.getMemoryMonitor().register(CmsXmlEntityResolver.class.getName() + ".cacheContentDefinitions", cacheContentDefinitions);
        }
    }

    public void cacheContentDefinition(String systemId, CmsXmlContentDefinition contentDefinition) {
        String cacheKey = this.getCacheKeyForCurrentProject(systemId);
        m_cacheContentDefinitions.put(cacheKey, contentDefinition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ER_CACHED_SYSTEM_ID_1", cacheKey));
        }
    }

    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 2: 
            case 5: {
                m_cacheTemporary.clear();
                m_cacheContentDefinitions.clear();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ER_FLUSHED_CACHES_0"));
                break;
            }
            case 11: {
                CmsResource resource = (CmsResource)event.getData().get("resource");
                this.uncacheSystemId(resource.getRootPath());
                break;
            }
            case 22: 
            case 25: {
                List resources = (List)event.getData().get("resources");
                for (int i = 0; i < resources.size(); ++i) {
                    CmsResource resource = (CmsResource)resources.get(i);
                    this.uncacheSystemId(resource.getRootPath());
                }
                break;
            }
        }
    }

    public CmsXmlContentDefinition getCachedContentDefinition(String systemId) {
        String cacheKey = this.getCacheKeyForCurrentProject(systemId);
        CmsXmlContentDefinition result = (CmsXmlContentDefinition)m_cacheContentDefinitions.get(cacheKey);
        if (result != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CACHE_LOOKUP_SUCCEEDED_1", cacheKey));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource resolveEntity(String publicId, String systemId) {
        byte[] content = (byte[])m_cachePermanent.get(systemId);
        if (content != null) {
            return new InputSource(new ByteArrayInputStream(content));
        }
        if (systemId.equals("http://www.opencms.org/dtd/6.0/xmlpage.xsd")) {
            try {
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream(XMLPAGE_XSD_LOCATION);
                content = CmsFileUtil.readFully(stream);
                m_cachePermanent.put(systemId, content);
                return new InputSource(new ByteArrayInputStream(content));
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_XMLPAGE_XSD_NOT_FOUND_1", XMLPAGE_XSD_LOCATION), t);
            }
        } else if (systemId.equals(XMLPAGE_OLD_DTD_SYSTEM_ID_1) || systemId.endsWith(XMLPAGE_OLD_DTD_SYSTEM_ID_2)) {
            try {
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream(XMLPAGE_OLD_DTD_LOCATION);
                content = CmsFileUtil.readFully(stream);
                m_cachePermanent.put(systemId, content);
                return new InputSource(new ByteArrayInputStream(content));
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_XMLPAGE_DTD_NOT_FOUND_1", XMLPAGE_OLD_DTD_LOCATION), t);
            }
        } else if (this.m_cms != null && systemId.startsWith(OPENCMS_SCHEME)) {
            String cacheSystemId = systemId.substring(OPENCMS_SCHEME.length() - 1);
            String cacheKey = this.getCacheKey(cacheSystemId, this.m_cms.getRequestContext().currentProject().isOnlineProject());
            content = (byte[])m_cacheTemporary.get(cacheKey);
            if (content != null) {
                return new InputSource(new ByteArrayInputStream(content));
            }
            String storedSiteRoot = this.m_cms.getRequestContext().getSiteRoot();
            try {
                this.m_cms.getRequestContext().setSiteRoot("/");
                CmsFile file = this.m_cms.readFile(cacheSystemId, CmsResourceFilter.IGNORE_EXPIRATION);
                content = file.getContents();
                m_cacheTemporary.put(cacheKey, content);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_ER_CACHED_SYS_ID_1", cacheKey));
                }
                InputSource inputSource = new InputSource(new ByteArrayInputStream(content));
                return inputSource;
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ENTITY_RESOLVE_FAILED_1", systemId), t);
            }
            finally {
                this.m_cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        } else if (systemId.substring(0, systemId.lastIndexOf("/") + 1).equalsIgnoreCase("http://www.opencms.org/dtd/6.0/")) {
            String location = null;
            try {
                String dtdFilename = systemId.substring(systemId.lastIndexOf("/") + 1);
                location = "org/opencms/configuration/" + dtdFilename;
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream(location);
                content = CmsFileUtil.readFully(stream);
                m_cachePermanent.put(systemId, content);
                return new InputSource(new ByteArrayInputStream(content));
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_DTD_NOT_FOUND_1", location), t);
            }
        }
        return null;
    }

    private String getCacheKey(String systemId, boolean online) {
        if (online) {
            return "online_".concat(systemId);
        }
        return "offline_".concat(systemId);
    }

    private String getCacheKeyForCurrentProject(String systemId) {
        boolean project;
        boolean bl = project = this.m_cms != null ? this.m_cms.getRequestContext().currentProject().isOnlineProject() : false;
        if (systemId.startsWith(OPENCMS_SCHEME)) {
            systemId = systemId.substring(OPENCMS_SCHEME.length() - 1);
        }
        return this.getCacheKey(systemId, project);
    }

    private void uncacheSystemId(String systemId) {
        Object o = m_cacheTemporary.remove(this.getCacheKey(systemId, false));
        if (null != o) {
            m_cacheContentDefinitions.clear();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ER_UNCACHED_SYS_ID_1", this.getCacheKey(systemId, false)));
            }
        } else {
            o = m_cacheContentDefinitions.remove(this.getCacheKey(systemId, false));
            if (null != o && LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ER_UNCACHED_CONTENT_DEF_1", this.getCacheKey(systemId, false)));
            }
        }
    }
}

