/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsLinkUpdateUtil;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlVfsFileValue
extends A_CmsXmlContentValue {
    public static final String NO_LINK = "none";
    public static final String TYPE_NAME = "OpenCmsVfsFile";
    private static String m_schemaDefinition;
    private String m_stringValue;

    public CmsXmlVfsFileValue() {
    }

    public CmsXmlVfsFileValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlVfsFileValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlVfsFileValue(document, element, locale, this);
    }

    public Element generateXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getName());
        String defaultValue = document.getContentDefinition().getContentHandler().getDefault(cms, this, locale);
        if (defaultValue != null) {
            I_CmsXmlContentValue value = this.createValue(document, element, locale);
            value.setStringValue(cms, defaultValue);
        }
        return element;
    }

    public CmsLink getLink(CmsObject cms) {
        Element linkElement = this.m_element.element("link");
        if (linkElement == null) {
            String uri = this.m_element.getText();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(uri)) {
                this.setStringValue(cms, uri);
            }
            if ((linkElement = this.m_element.element("link")) == null) {
                return null;
            }
        }
        CmsLinkUpdateUtil.updateType(linkElement, this.getContentDefinition().getContentHandler().getRelationType(this));
        CmsLink link = new CmsLink(linkElement);
        link.checkConsistency(cms);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(link.getTarget())) {
            return null;
        }
        return link;
    }

    public String getPlainText(CmsObject cms) {
        return this.getStringValue(cms);
    }

    public String getSchemaDefinition() {
        if (m_schemaDefinition == null) {
            m_schemaDefinition = this.readSchemaDefinition("org/opencms/xml/types/XmlVfsFileValue.xsd");
        }
        return m_schemaDefinition;
    }

    public String getStringValue(CmsObject cms) throws CmsRuntimeException {
        if (this.m_stringValue == null) {
            this.m_stringValue = this.createStringValue(cms);
        }
        return this.m_stringValue;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isSearchable() {
        return false;
    }

    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlVfsFileValue(name, minOccurs, maxOccurs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringValue(CmsObject cms, String value) throws CmsIllegalArgumentException {
        this.m_element.clearContent();
        this.m_stringValue = null;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
            return;
        }
        String path = value;
        if (cms != null) {
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(value);
            String oldSite = cms.getRequestContext().getSiteRoot();
            try {
                if (siteRoot != null) {
                    cms.getRequestContext().setSiteRoot(siteRoot);
                    path = cms.getRequestContext().removeSiteRoot(value);
                }
                String query = "";
                int pos = path.indexOf("?");
                int anchorPos = path.indexOf(35);
                if (pos == -1 || anchorPos > -1 && pos > anchorPos) {
                    pos = anchorPos;
                }
                if (pos > -1) {
                    query = path.substring(pos);
                    path = path.substring(0, pos);
                }
                path = (path = OpenCms.getLinkManager().getRootPath(cms, path)) == null ? value : path + query;
                Object var10_9 = null;
                if (siteRoot != null) {
                    cms.getRequestContext().setSiteRoot(oldSite);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (siteRoot != null) {
                    cms.getRequestContext().setSiteRoot(oldSite);
                }
                throw throwable;
            }
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(path)) {
            return;
        }
        CmsRelationType type = this.getContentDefinition().getContentHandler().getRelationType(this);
        CmsLink link = new CmsLink("vfsLink", type, path, true);
        link.checkConsistency(cms);
        CmsLinkUpdateUtil.updateXmlForVfsFile(link, this.m_element.addElement("link"));
    }

    private String createStringValue(CmsObject cms) {
        CmsLink link;
        Attribute enabled = this.m_element.attribute("enabled");
        String content = "";
        if ((enabled == null || Boolean.valueOf(enabled.getText()).booleanValue()) && (link = this.getLink(cms)) != null) {
            content = link.getUri();
            if (cms != null) {
                content = cms.getRequestContext().removeSiteRoot(link.getUri());
            }
        }
        return content;
    }
}

