/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.photoalbum;

import java.awt.Color;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.frontend.photoalbum.Messages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.CmsXmlHtmlValue;

public class CmsPhotoAlbumConfiguration {
    public static final String FILTER_DELIMITER = ".";
    public static final String FILTER_NONE = "none";
    public static final String NAVPOS_BOTTOM_ABOVE = "b_a";
    public static final String NAVPOS_BOTTOM_BELOW = "b_b";
    public static final String NAVPOS_TOP_ABOVE = "t_a";
    public static final String NAVPOS_TOP_BELOW = "t_b";
    public static final String NODE_ALIGN_NAVIGATION = "AlignNavigation";
    public static final String NODE_ALIGN_TITLE = "AlignTitle";
    public static final String NODE_BACKGROUND = "Background";
    public static final String NODE_COLS = "Cols";
    public static final String NODE_DETAIL = "Details";
    public static final String NODE_FILTER = "Filter";
    public static final String NODE_HIGHQUALITY = "HighQuality";
    public static final String NODE_NAVIGATION_POSITION = "NavigationPosition";
    public static final String NODE_ROWS = "Rows";
    public static final String NODE_SHOWDESCRIPTION = "ShowDescription";
    public static final String NODE_SHOWLINKORIGINAL = "ShowLinkOriginal";
    public static final String NODE_SHOWRESOURCENAMEASTITLE = "ShowResourceNameAsTitle";
    public static final String NODE_SHOWTITLE = "ShowTitle";
    public static final String NODE_SIZE = "Size";
    public static final String NODE_TEXTBOTTOM = "TextBottom";
    public static final String NODE_TEXTTOP = "TextTop";
    public static final String NODE_THUMBS = "Thumbs";
    public static final String NODE_TITLE = "Title";
    public static final String NODE_VFSFOLDER = "VfsFolder";
    private String m_albumTitle;
    private String m_alignNavigation;
    private String m_detailAlignTitle;
    private CmsImageScaler m_detailImageScaler;
    private String m_navigationPosition;
    private boolean m_showDetailDescription;
    private boolean m_showDetailOriginalLink;
    private boolean m_showDetailTitle;
    private boolean m_showResourceNameAsTitle;
    private boolean m_showThumbTitle;
    private String m_thumbAlignTitle;
    private int m_thumbCols;
    private CmsImageScaler m_thumbNailScaler;
    private int m_thumbRows;
    private String m_thumbTextBottom;
    private String m_thumbTextTop;
    private String m_vfsPathGallery;

    public CmsPhotoAlbumConfiguration() {
        this.initMembers();
    }

    public CmsPhotoAlbumConfiguration(CmsJspActionElement jsp) throws Exception {
        this.init(jsp, null);
    }

    public CmsPhotoAlbumConfiguration(CmsJspActionElement jsp, String configUri) throws Exception {
        this.init(jsp, configUri);
    }

    public String getAlbumTitle() {
        return this.m_albumTitle;
    }

    public String getAlignNavigation() {
        return this.m_alignNavigation;
    }

    public String getDetailAlignTitle() {
        return this.m_detailAlignTitle;
    }

    public CmsImageScaler getDetailImageScaler() {
        return this.m_detailImageScaler;
    }

    public String getNavigationPosition() {
        return this.m_navigationPosition;
    }

    public String getThumbAlignTitle() {
        return this.m_thumbAlignTitle;
    }

    public int getThumbCols() {
        return this.m_thumbCols;
    }

    public CmsImageScaler getThumbNailScaler() {
        return this.m_thumbNailScaler;
    }

    public int getThumbRows() {
        return this.m_thumbRows;
    }

    public String getThumbTextBottom() {
        return this.m_thumbTextBottom;
    }

    public String getThumbTextTop() {
        return this.m_thumbTextTop;
    }

    public String getVfsPathGallery() {
        return this.m_vfsPathGallery;
    }

    public void init(CmsJspActionElement jsp, String configUri) throws Exception {
        this.initMembers();
        if (CmsStringUtil.isEmpty((String)configUri)) {
            configUri = jsp.getRequestContext().getUri();
        }
        CmsFile file = jsp.getCmsObject().readFile(configUri);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal((CmsObject)jsp.getCmsObject(), (CmsFile)file);
        Locale locale = jsp.getRequestContext().getLocale();
        CmsObject cms = jsp.getCmsObject();
        String stringValue = content.getStringValue(cms, NODE_TITLE, locale);
        this.setAlbumTitle(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, NODE_VFSFOLDER, locale);
        this.setVfsPathGallery(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, NODE_ALIGN_NAVIGATION, locale);
        this.setAlignNavigation(this.getConfigurationValue(stringValue, "left"));
        stringValue = content.getStringValue(cms, NODE_NAVIGATION_POSITION, locale);
        this.setNavigationPosition(this.getConfigurationValue(stringValue, NAVPOS_BOTTOM_BELOW));
        stringValue = content.getStringValue(cms, NODE_SHOWRESOURCENAMEASTITLE, locale);
        this.setShowResourceNameAsTitle(Boolean.valueOf(stringValue));
        String nodePrefix = "Thumbs/";
        stringValue = content.getStringValue(cms, nodePrefix + NODE_SHOWTITLE, locale);
        this.setShowThumbTitle(Boolean.valueOf(stringValue));
        stringValue = content.getStringValue(cms, nodePrefix + NODE_ALIGN_TITLE, locale);
        this.setThumbAlignTitle(this.getConfigurationValue(stringValue, "left"));
        stringValue = content.getStringValue(cms, nodePrefix + NODE_COLS, locale);
        this.setThumbCols(Integer.parseInt(this.getConfigurationValue(stringValue, "1")));
        stringValue = content.getStringValue(cms, nodePrefix + NODE_ROWS, locale);
        this.setThumbRows(Integer.parseInt(this.getConfigurationValue(stringValue, "-1")));
        stringValue = content.getStringValue(cms, nodePrefix + NODE_BACKGROUND, locale);
        stringValue = this.getConfigurationValue(stringValue, "#FFFFFF");
        Color color = Color.WHITE;
        try {
            color = Color.decode(stringValue);
        }
        catch (NumberFormatException e) {
            throw new CmsException(Messages.get().container("LOG_ERR_WRONG_THUMB_BGCOLOR_1", (Object)stringValue));
        }
        this.getThumbNailScaler().setColor(color);
        stringValue = content.getStringValue(cms, nodePrefix + NODE_HIGHQUALITY, locale);
        if (Boolean.valueOf(stringValue).booleanValue()) {
            this.getThumbNailScaler().setQuality(85);
        } else {
            this.getThumbNailScaler().setQuality(50);
            this.getThumbNailScaler().setRenderMode(2);
        }
        stringValue = content.getStringValue(cms, nodePrefix + NODE_SIZE, locale);
        this.setImageSize(stringValue, true);
        stringValue = content.getStringValue(cms, nodePrefix + NODE_FILTER, locale);
        this.setImageFilter(stringValue, true);
        CmsXmlHtmlValue textValue = (CmsXmlHtmlValue)content.getValue(nodePrefix + NODE_TEXTTOP, locale);
        if (textValue != null) {
            stringValue = textValue.getStringValue(cms);
            this.setThumbTextTop(this.getConfigurationValue(stringValue, ""));
        } else {
            this.setThumbTextTop("");
        }
        textValue = (CmsXmlHtmlValue)content.getValue(nodePrefix + NODE_TEXTBOTTOM, locale);
        if (textValue != null) {
            stringValue = textValue.getStringValue(cms);
            this.setThumbTextBottom(this.getConfigurationValue(stringValue, ""));
        } else {
            this.setThumbTextBottom("");
        }
        nodePrefix = "Details/";
        stringValue = content.getStringValue(cms, nodePrefix + NODE_SHOWTITLE, locale);
        this.setShowDetailTitle(Boolean.valueOf(stringValue));
        stringValue = content.getStringValue(cms, nodePrefix + NODE_SHOWDESCRIPTION, locale);
        this.setShowDetailDescription(Boolean.valueOf(stringValue));
        stringValue = content.getStringValue(cms, nodePrefix + NODE_ALIGN_TITLE, locale);
        this.setDetailAlignTitle(this.getConfigurationValue(stringValue, "left"));
        stringValue = content.getStringValue(cms, nodePrefix + NODE_SHOWLINKORIGINAL, locale);
        this.setShowDetailOriginalLink(Boolean.valueOf(stringValue));
        stringValue = content.getStringValue(cms, nodePrefix + NODE_SIZE, locale);
        this.setImageSize(stringValue, false);
        stringValue = content.getStringValue(cms, nodePrefix + NODE_FILTER, locale);
        this.setImageFilter(stringValue, false);
        stringValue = content.getStringValue(cms, nodePrefix + NODE_BACKGROUND, locale);
        stringValue = this.getConfigurationValue(stringValue, "#FFFFFF");
        color = Color.WHITE;
        try {
            color = Color.decode(stringValue);
        }
        catch (NumberFormatException e) {
            throw new CmsException(Messages.get().container("LOG_ERR_WRONG_DETAIL_BGCOLOR_1", (Object)stringValue));
        }
        this.getDetailImageScaler().setColor(color);
    }

    public boolean showDetailDescription() {
        return this.m_showDetailDescription;
    }

    public boolean showDetailOriginalLink() {
        return this.m_showDetailOriginalLink;
    }

    public boolean showDetailTitle() {
        return this.m_showDetailTitle;
    }

    public boolean showPageNavigation() {
        return this.getThumbRows() > 0;
    }

    public boolean showResourceNameAsTitle() {
        return this.m_showResourceNameAsTitle;
    }

    public boolean showThumbTextBottom() {
        return CmsStringUtil.isNotEmpty((String)this.getThumbTextBottom());
    }

    public boolean showThumbTextTop() {
        return CmsStringUtil.isNotEmpty((String)this.getThumbTextTop());
    }

    public boolean showThumbTitle() {
        return this.m_showThumbTitle;
    }

    protected String getStyleAlignAttribute(String alignment) {
        StringBuffer result = new StringBuffer(32);
        result.append(" style=\"text-align: ");
        result.append(alignment);
        result.append(";\"");
        return result.toString();
    }

    protected void initMembers() {
        this.setDetailImageScaler(new CmsImageScaler());
        this.setThumbNailScaler(new CmsImageScaler());
        this.setVfsPathGallery("/");
        this.setThumbCols(3);
        this.setThumbRows(3);
        this.setNavigationPosition(NAVPOS_TOP_BELOW);
    }

    protected void setAlbumTitle(String albumTitle) {
        this.m_albumTitle = albumTitle;
    }

    protected void setAlignNavigation(String alignNavigation) {
        this.m_alignNavigation = alignNavigation;
    }

    protected void setDetailAlignTitle(String detailAlignTitle) {
        this.m_detailAlignTitle = detailAlignTitle;
    }

    protected void setDetailImageScaler(CmsImageScaler detailImageScaler) {
        this.m_detailImageScaler = detailImageScaler;
    }

    protected void setNavigationPosition(String navigationPosition) {
        this.m_navigationPosition = navigationPosition;
    }

    protected void setShowDetailDescription(boolean showDetailDescription) {
        this.m_showDetailDescription = showDetailDescription;
    }

    protected void setShowDetailOriginalLink(boolean showDetailOriginalLink) {
        this.m_showDetailOriginalLink = showDetailOriginalLink;
    }

    protected void setShowDetailTitle(boolean showDetailTitle) {
        this.m_showDetailTitle = showDetailTitle;
    }

    protected void setShowResourceNameAsTitle(boolean showResourceNameAsTitle) {
        this.m_showResourceNameAsTitle = showResourceNameAsTitle;
    }

    protected void setShowThumbTitle(boolean showThumbTitle) {
        this.m_showThumbTitle = showThumbTitle;
    }

    protected void setThumbAlignTitle(String thumbAlignTitle) {
        this.m_thumbAlignTitle = thumbAlignTitle;
    }

    protected void setThumbCols(int thumbCols) {
        this.m_thumbCols = thumbCols;
    }

    protected void setThumbNailScaler(CmsImageScaler thumbNailScaler) {
        this.m_thumbNailScaler = thumbNailScaler;
    }

    protected void setThumbRows(int thumbRows) {
        this.m_thumbRows = thumbRows < 1 ? -1 : thumbRows;
    }

    protected void setThumbTextBottom(String thumbTextBottom) {
        this.m_thumbTextBottom = thumbTextBottom;
    }

    protected void setThumbTextTop(String thumbTextTop) {
        this.m_thumbTextTop = thumbTextTop;
    }

    protected void setVfsPathGallery(String vfsPathGallery) {
        this.m_vfsPathGallery = vfsPathGallery;
    }

    private String getConfigurationValue(String value, String defaultValue) {
        if (CmsStringUtil.isNotEmpty((String)value)) {
            return value;
        }
        return defaultValue;
    }

    private void setImageFilter(String configValue, boolean isThumbNail) throws Exception {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)configValue) && !FILTER_NONE.equals(configValue)) {
            List filter = CmsStringUtil.splitAsList((String)configValue, (String)FILTER_DELIMITER);
            for (int i = 0; i < filter.size(); ++i) {
                String currentFilter = (String)filter.get(i);
                if (isThumbNail) {
                    this.getThumbNailScaler().addFilter(currentFilter);
                    continue;
                }
                this.getDetailImageScaler().addFilter(currentFilter);
            }
        }
    }

    private void setImageSize(String configValue, boolean isThumbNail) throws Exception {
        List sizes = CmsStringUtil.splitAsList((String)this.getConfigurationValue(configValue, "200x150"), (char)'x', (boolean)true);
        int width = Integer.parseInt((String)sizes.get(0));
        int height = Integer.parseInt((String)sizes.get(1));
        if (isThumbNail) {
            this.getThumbNailScaler().setWidth(width);
            this.getThumbNailScaler().setHeight(height);
        } else {
            this.getDetailImageScaler().setWidth(width);
            this.getDetailImageScaler().setHeight(height);
        }
    }
}

