/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsUserSettings;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.synchronize.CmsSynchronizeSettings;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.workplace.Messages;

public class CmsSynchronizeSettingsDialog
extends CmsWidgetDialog {
    public static final String[] PAGES = new String[]{"page1"};
    public static final String KEY_PREFIX = "sync";
    private CmsSynchronizeSettings m_synchronizeSettings;

    public CmsSynchronizeSettingsDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSynchronizeSettingsDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            CmsUserSettings userSettings = new CmsUserSettings(this.getCms());
            this.m_synchronizeSettings.checkValues(this.getCms());
            userSettings.setSynchronizeSettings(this.m_synchronizeSettings);
            userSettings.save(this.getCms());
            this.setDialogObject(null);
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        result.append(this.dialogBlockStart(this.key("GUI_EDITOR_LABEL_ACTIVATE_SYNC_BLOCK_0")));
        result.append(this.createWidgetTableStart());
        result.append(this.createDialogRowsHtml(0, 0));
        result.append(this.createWidgetTableEnd());
        result.append(this.dialogBlockEnd());
        result.append(this.dialogBlockStart(this.key("GUI_EDITOR_LABEL_SOURCE_LIST_VFS_BLOCK_0")));
        result.append(this.createWidgetTableStart());
        result.append(this.createDialogRowsHtml(1, 1));
        result.append(this.createWidgetTableEnd());
        result.append(this.dialogBlockEnd());
        result.append(this.dialogBlockStart(this.key("GUI_EDITOR_LABEL_DESTINATION_RFS_BLOCK_0")));
        result.append(this.createWidgetTableStart());
        result.append(this.createDialogRowsHtml(2, 2));
        result.append(this.createWidgetTableEnd());
        result.append(this.dialogBlockEnd());
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initSynchronizeSettingsObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_synchronizeSettings, "enabled", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_synchronizeSettings, "destinationPathInRfs", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_synchronizeSettings, "sourceListInVfs", "/", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(false, ""), 1, 200));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initSynchronizeSettingsObject() {
        Object o = this.getDialogObject();
        if (o == null || !(o instanceof CmsSynchronizeSettings)) {
            CmsUserSettings userSettings = new CmsUserSettings(this.getCms());
            o = userSettings.getSynchronizeSettings();
        }
        this.m_synchronizeSettings = o != null ? (CmsSynchronizeSettings)o : new CmsSynchronizeSettings();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_synchronizeSettings);
    }
}

