/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.broadcast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.workplace.Messages;
import org.opencms.workplace.tools.workplace.broadcast.CmsMessageInfo;

public abstract class A_CmsMessageDialog
extends CmsWidgetDialog {
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_SESSIONIDS = "sessionids";
    private static final Log LOG = CmsLog.getLog((Object)A_CmsMessageDialog.class);
    protected CmsMessageInfo m_msgInfo;
    private String m_paramSessionids;

    public A_CmsMessageDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public String getParamSessionids() {
        return this.m_paramSessionids;
    }

    public void setParamSessionids(String sessionIds) {
        this.m_paramSessionids = sessionIds;
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected String getToNames() {
        ArrayList<String> users = new ArrayList<String>();
        Iterator itIds = this.idsList().iterator();
        while (itIds.hasNext()) {
            String id = itIds.next().toString();
            CmsSessionInfo session = OpenCms.getSessionManager().getSessionInfo(id);
            if (session == null) continue;
            try {
                String userName = this.getCms().readUser(session.getUserId()).getFullName();
                if (users.contains(userName)) continue;
                users.add(userName);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        StringBuffer result = new StringBuffer(256);
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            result.append(itUsers.next().toString());
            if (!itUsers.hasNext()) continue;
            result.append("; ");
        }
        return result.toString();
    }

    protected List idsList() {
        List manageableUsers;
        block6: {
            if (!this.isForAll()) {
                return CmsStringUtil.splitAsList((String)this.getParamSessionids(), (String)"|");
            }
            manageableUsers = new ArrayList();
            try {
                manageableUsers = OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        ArrayList<CmsUUID> ids = new ArrayList<CmsUUID>();
        Iterator itSessions = OpenCms.getSessionManager().getSessionInfos().iterator();
        while (itSessions.hasNext()) {
            CmsUser user;
            CmsSessionInfo sessionInfo = (CmsSessionInfo)itSessions.next();
            try {
                user = this.getCms().readUser(sessionInfo.getUserId());
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            if (!manageableUsers.contains(user)) continue;
            ids.add(sessionInfo.getSessionId());
        }
        return ids;
    }

    protected void initMessageObject() {
        Object o = null;
        try {
            o = this.getDialogObject();
            this.m_msgInfo = (CmsMessageInfo)o;
            this.m_msgInfo.getTo();
        }
        catch (Exception e) {
            this.m_msgInfo = new CmsMessageInfo();
        }
        this.m_msgInfo.setFrom(this.getCms().getRequestContext().currentUser().getFullName());
        this.m_msgInfo.setTo(this.getToNames());
    }

    protected void initMessages() {
        this.addMessages(org.opencms.workplace.tools.workplace.broadcast.Messages.get().getBundleName());
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_msgInfo);
    }

    protected boolean isForAll() {
        return CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getParamSessionids());
    }
}

