/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.broadcast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.workplace.broadcast.A_CmsMessageDialog;

public class CmsBroadcastMessageDialog
extends A_CmsMessageDialog {
    public static final String KEY_PREFIX = "message";

    public CmsBroadcastMessageDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsBroadcastMessageDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (this.isForAll()) {
                OpenCms.getSessionManager().sendBroadcast(this.getCms(), this.m_msgInfo.getMsg());
            } else {
                List ids = CmsStringUtil.splitAsList((String)this.getParamSessionids(), (String)"|");
                Iterator itIds = ids.iterator();
                while (itIds.hasNext()) {
                    String id = itIds.next().toString();
                    OpenCms.getSessionManager().sendBroadcast(this.getCms(), this.m_msgInfo.getMsg(), id);
                }
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_MESSAGE_EDITOR_LABEL_HEADER_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_MESSAGE_EDITOR_LABEL_CONTENT_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(2, 2));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initMessageObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "from", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "to", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "msg", PAGES[0], (I_CmsWidget)new CmsTextareaWidget(12)));
    }
}

