/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.broadcast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.SendFailedException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.opencms.file.CmsObject;
import org.opencms.mail.CmsSimpleMail;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.workplace.broadcast.Messages;

public class CmsMessageInfo {
    private String m_cc = "";
    private String m_from = "";
    private String m_msg = "";
    private String m_subject = "";
    private String m_to = "";

    public String getCc() {
        return this.m_cc;
    }

    public String getFrom() {
        return this.m_from;
    }

    public String getMsg() {
        return this.m_msg;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public String getTo() {
        return this.m_to;
    }

    public void sendEmail(CmsObject cms) throws Exception {
        CmsSimpleMail theMail = new CmsSimpleMail();
        theMail.setCharset(cms.getRequestContext().getEncoding());
        theMail.setFrom(cms.getRequestContext().currentUser().getEmail(), this.getFrom());
        theMail.setTo((Collection)this.createInternetAddresses(this.getTo()));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getCc())) {
            theMail.setCc((Collection)this.createInternetAddresses(this.getCc()));
        }
        theMail.setSubject("[" + OpenCms.getSystemInfo().getServerName() + "] " + this.getSubject());
        theMail.setMsg(this.getMsg());
        try {
            theMail.send();
        }
        catch (SendFailedException sf) {
            int i;
            StringBuffer newTo = new StringBuffer();
            Address[] unsent = sf.getValidUnsentAddresses();
            if (unsent != null) {
                for (i = unsent.length - 1; i >= 0; --i) {
                    newTo.append(unsent[i].toString()).append(';');
                }
            }
            if (unsent != null) {
                unsent = sf.getInvalidAddresses();
                for (i = unsent.length - 1; i >= 0; --i) {
                    newTo.append(unsent[i].toString()).append(';');
                }
            }
            this.setTo(newTo.toString());
            throw (Exception)sf.getCause();
        }
    }

    public void setCc(String cc) {
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)cc)) {
            this.m_cc = cc;
        }
    }

    public void setFrom(String from) {
        this.checkString(from);
        this.m_from = from;
    }

    public void setMsg(String msg) {
        this.checkString(msg);
        this.m_msg = msg;
    }

    public void setSubject(String subject) {
        this.checkString(subject);
        this.m_subject = subject;
    }

    public void setTo(String to) {
        this.m_to = to;
    }

    private void checkString(String string) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)string)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_EMPTY_STRING_0"));
        }
    }

    private List createInternetAddresses(String mailAddresses) throws AddressException {
        if (CmsStringUtil.isNotEmpty((String)mailAddresses)) {
            StringTokenizer T = new StringTokenizer(mailAddresses, ";");
            ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(T.countTokens());
            while (T.hasMoreTokens()) {
                InternetAddress address = new InternetAddress(T.nextToken().trim());
                addresses.add(address);
            }
            return addresses;
        }
        return Collections.EMPTY_LIST;
    }
}

