/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.broadcast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsGroupWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.workplace.Messages;

public class CmsSelectReceiverDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "select";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_MSGTYPE = "msgtype";
    public static final String MSGTYPE_EMAIL = "email";
    public static final String MSGTYPE_POPUP = "popup";
    private List m_groups;
    private String m_paramMsgtype;

    public CmsSelectReceiverDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSelectReceiverDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        boolean isEmail;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        boolean bl = isEmail = this.getParamMsgtype() != null && this.getParamMsgtype().equals(MSGTYPE_EMAIL);
        if (this.m_groups == null || this.m_groups.isEmpty()) {
            this.setCommitErrors(Collections.singletonList(new CmsIllegalStateException(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("ERR_NO_SELECTED_GROUP_0"))));
            return;
        }
        boolean hasUser = false;
        Iterator itGroups = this.getGroups().iterator();
        while (!hasUser && itGroups.hasNext()) {
            String groupName = (String)itGroups.next();
            try {
                Iterator itUsers = this.getCms().getUsersOfGroup(groupName, true).iterator();
                while (!hasUser && itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    if (!isEmail) {
                        if (OpenCms.getSessionManager().getSessionInfos(user.getId()).isEmpty()) continue;
                        hasUser = true;
                        continue;
                    }
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)user.getEmail())) continue;
                    hasUser = true;
                }
            }
            catch (CmsException e) {
            }
        }
        if (!hasUser) {
            this.setCommitErrors(Collections.singletonList(new CmsIllegalStateException(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("ERR_NO_SELECTED_RECEIVERS_0"))));
            return;
        }
        try {
            HashSet groups = new HashSet(this.m_groups);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("style", "new");
            params.put("groups", CmsStringUtil.collectionAsString(groups, (String)"|"));
            params.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/workplace/broadcast"));
            if (isEmail) {
                this.getToolManager().jspForwardPage((CmsWorkplace)this, "/system/workplace/admin/workplace/groups_send_email.jsp", params);
            } else {
                this.getToolManager().jspForwardPage((CmsWorkplace)this, "/system/workplace/admin/workplace/groups_send_popup.jsp", params);
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public List getGroups() {
        return this.m_groups;
    }

    public String getParamMsgtype() {
        return this.m_paramMsgtype;
    }

    public void setGroups(List groups) {
        this.m_groups = groups;
    }

    public void setParamMsgtype(String paramMsgtype) {
        this.m_paramMsgtype = paramMsgtype;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_SELECT_EDITOR_LABEL_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 0));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initMessageObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "groups", "", PAGES[0], (I_CmsWidget)new CmsGroupWidget(), 0, 10));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessageObject() {
        try {
            this.m_groups = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? new ArrayList() : (List)this.getDialogObject();
        }
        catch (Exception e) {
            this.m_groups = new ArrayList();
        }
    }

    protected void initMessages() {
        this.addMessages(org.opencms.workplace.tools.workplace.broadcast.Messages.get().getBundleName());
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_groups);
    }
}

