/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.broadcast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.workplace.broadcast.A_CmsMessageDialog;
import org.opencms.workplace.tools.workplace.broadcast.Messages;

public class CmsSendEmailDialog
extends A_CmsMessageDialog {
    public static final String KEY_PREFIX = "email";
    private static final Log LOG = CmsLog.getLog((Object)CmsSendEmailDialog.class);
    private String m_excludedUsers = "";

    public CmsSendEmailDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSendEmailDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_msgInfo.getTo())) {
            this.setCommitErrors(Collections.singletonList(new CmsIllegalStateException(Messages.get().container("ERR_NO_SELECTED_USER_WITH_EMAIL_0"))));
            return;
        }
        try {
            this.m_msgInfo.setTo(this.getEmailAddresses());
            this.m_msgInfo.sendEmail(this.getCms());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        finally {
            this.m_msgInfo.setTo(this.getToNames());
        }
        this.setCommitErrors(errors);
    }

    public String getExcludedUsers() {
        return this.m_excludedUsers;
    }

    public void setExcludedUsers(String excludedUsers) {
        this.m_excludedUsers = excludedUsers;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        int n = 4;
        this.getToNames();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getExcludedUsers())) {
            ++n;
        }
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_MESSAGE_EDITOR_LABEL_HEADER_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, n - 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_MESSAGE_EDITOR_LABEL_CONTENT_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(n, n));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initMessageObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "from", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getExcludedUsers())) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "excludedUsers", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "to", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "cc", PAGES[0], "", (I_CmsWidget)new CmsInputWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "subject", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "msg", PAGES[0], (I_CmsWidget)new CmsTextareaWidget(12)));
    }

    protected String getToNames() {
        ArrayList<String> excluded = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>();
        Iterator itIds = this.idsList().iterator();
        while (itIds.hasNext()) {
            String id = itIds.next().toString();
            CmsSessionInfo session = OpenCms.getSessionManager().getSessionInfo(id);
            if (session == null) continue;
            try {
                CmsUser user = this.getCms().readUser(session.getUserId());
                String userName = user.getFullName();
                if (users.contains(userName)) continue;
                String emailAddress = user.getEmail();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)emailAddress)) {
                    users.add(userName);
                    continue;
                }
                excluded.add(userName);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!excluded.isEmpty()) {
            StringBuffer text = new StringBuffer(500);
            text.append(Messages.get().container("GUI_EXCLUDED_USERS_WARNING_0").key(this.getLocale()));
            text.append("\n");
            Iterator it = excluded.iterator();
            while (it.hasNext()) {
                text.append("- ");
                text.append(it.next());
                text.append("\n");
            }
            this.setExcludedUsers(text.toString());
        }
        if (users.isEmpty()) {
            this.setCommitErrors(Collections.singletonList(new CmsIllegalStateException(Messages.get().container("ERR_NO_SELECTED_USER_WITH_EMAIL_0"))));
            return "";
        }
        StringBuffer result = new StringBuffer(256);
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            result.append(itUsers.next().toString());
            if (!itUsers.hasNext()) continue;
            result.append("; ");
        }
        return result.toString();
    }

    private String getEmailAddresses() {
        ArrayList<String> emails = new ArrayList<String>();
        Iterator itIds = this.idsList().iterator();
        while (itIds.hasNext()) {
            String id = itIds.next().toString();
            CmsSessionInfo session = OpenCms.getSessionManager().getSessionInfo(id);
            if (session == null) continue;
            try {
                String emailAddress = this.getCms().readUser(session.getUserId()).getEmail();
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)emailAddress) || emails.contains(emailAddress)) continue;
                emails.add(emailAddress);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        StringBuffer result = new StringBuffer(256);
        Iterator itEmails = emails.iterator();
        while (itEmails.hasNext()) {
            result.append(itEmails.next().toString());
            if (!itEmails.hasNext()) continue;
            result.append("; ");
        }
        return result.toString();
    }
}

