/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.broadcast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.workplace.Messages;
import org.opencms.workplace.tools.workplace.broadcast.CmsMessageInfo;

public class CmsSendEmailGroupsDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "email";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_GROUPS = "groups";
    private static final Log LOG = CmsLog.getLog((Object)CmsSendEmailGroupsDialog.class);
    protected CmsMessageInfo m_msgInfo;
    private String m_excludedUsers;
    private String m_paramGroups;

    public CmsSendEmailGroupsDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSendEmailGroupsDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_msgInfo.getTo())) {
            this.setCommitErrors(Collections.singletonList(new CmsIllegalStateException(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("ERR_NO_SELECTED_USER_WITH_EMAIL_0"))));
            return;
        }
        try {
            this.m_msgInfo.setTo(this.getEmailAddresses());
            this.m_msgInfo.sendEmail(this.getCms());
        }
        catch (Throwable t) {
            errors.add(t);
        }
        finally {
            this.m_msgInfo.setTo(this.getToNames());
        }
        this.setCommitErrors(errors);
    }

    public String getExcludedUsers() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_excludedUsers)) {
            this.getToNames();
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_excludedUsers)) {
            return "";
        }
        return this.m_excludedUsers;
    }

    public List getGroups() {
        return CmsStringUtil.splitAsList((String)this.getParamGroups(), (String)"|");
    }

    public String getParamGroups() {
        return this.m_paramGroups;
    }

    public void setExcludedUsers(String excludedUsers) {
        this.m_excludedUsers = excludedUsers;
    }

    public void setParamGroups(String paramGroups) {
        this.m_paramGroups = paramGroups;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            int n = 4;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getExcludedUsers())) {
                ++n;
            }
            result.append(this.dialogBlockStart(this.key("GUI_MESSAGE_EDITOR_LABEL_HEADER_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, n - 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_MESSAGE_EDITOR_LABEL_CONTENT_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(n, n));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initMessageObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "from", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getExcludedUsers())) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "excludedUsers", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "to", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "cc", PAGES[0], "", (I_CmsWidget)new CmsInputWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "subject", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "msg", PAGES[0], (I_CmsWidget)new CmsTextareaWidget(12)));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected String getToNames() {
        Iterator itUsers;
        ArrayList<String> excluded = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>();
        Iterator itGroups = this.getGroups().iterator();
        while (itGroups.hasNext()) {
            String groupName = (String)itGroups.next();
            try {
                itUsers = this.getCms().getUsersOfGroup(groupName, true).iterator();
                while (itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    String userName = user.getFullName();
                    if (users.contains(userName)) continue;
                    String emailAddress = user.getEmail();
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)emailAddress)) {
                        users.add(userName);
                        continue;
                    }
                    excluded.add(userName);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!excluded.isEmpty()) {
            StringBuffer text = new StringBuffer(500);
            text.append(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_EXCLUDED_USERS_WARNING_0").key(this.getLocale()));
            text.append("<br>");
            Iterator it = excluded.iterator();
            while (it.hasNext()) {
                text.append("- ");
                text.append(it.next());
                text.append("<br>");
            }
            this.setExcludedUsers(text.toString());
        }
        if (users.isEmpty()) {
            this.setCommitErrors(Collections.singletonList(new CmsIllegalStateException(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("ERR_NO_SELECTED_USER_WITH_EMAIL_0"))));
            return "";
        }
        StringBuffer result = new StringBuffer(256);
        itUsers = users.iterator();
        while (itUsers.hasNext()) {
            result.append(itUsers.next().toString());
            if (!itUsers.hasNext()) continue;
            result.append("; ");
        }
        return result.toString();
    }

    protected void initMessageObject() {
        try {
            this.m_msgInfo = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? new CmsMessageInfo() : (CmsMessageInfo)this.getDialogObject();
        }
        catch (Exception e) {
            this.m_msgInfo = new CmsMessageInfo();
        }
        this.m_msgInfo.setFrom(this.getCms().getRequestContext().currentUser().getFullName());
        this.m_msgInfo.setTo(this.getToNames());
    }

    protected void initMessages() {
        this.addMessages(org.opencms.workplace.tools.workplace.broadcast.Messages.get().getBundleName());
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_msgInfo);
    }

    protected void validateParamaters() throws Exception {
        if (this.getGroups() == null || this.getGroups().isEmpty()) {
            throw new Exception();
        }
    }

    private String getEmailAddresses() {
        ArrayList<String> emails = new ArrayList<String>();
        Iterator itGroups = this.getGroups().iterator();
        while (itGroups.hasNext()) {
            String groupName = (String)itGroups.next();
            try {
                Iterator itUsers = this.getCms().getUsersOfGroup(groupName, true).iterator();
                while (itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    String emailAddress = user.getEmail();
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)emailAddress) || emails.contains(emailAddress)) continue;
                    emails.add(emailAddress);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        StringBuffer result = new StringBuffer(256);
        Iterator itEmails = emails.iterator();
        while (itEmails.hasNext()) {
            result.append(itEmails.next().toString());
            if (!itEmails.hasNext()) continue;
            result.append("; ");
        }
        return result.toString();
    }
}

