/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templatetwo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.frontend.templatetwo.CmsListBoxContentMapping;
import org.opencms.frontend.templatetwo.CmsListBoxEntry;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsListBox
extends CmsJspActionElement {
    public static final String MACRO_LINK_PREFIX = "link";
    public static final String NODE_LINKS = "Links";
    public static final String NODE_MAPPING = "Mapping";
    public static final String NODE_PARAMETER = "Parameter";
    public static final String PARAM_FILE = "file";
    private static final Log LOG = CmsLog.getLog((Object)CmsListBox.class);
    private CmsXmlContent m_content;
    private Map m_mappedEntries;
    private CmsListBoxContentMapping m_mapping;

    public CmsListBox() {
    }

    public CmsListBox(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public Map getMappedEntry() {
        if (this.m_mappedEntries == null) {
            this.m_mappedEntries = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    CmsListBoxEntry entry = null;
                    try {
                        CmsXmlContent content;
                        if (input instanceof CmsXmlContent) {
                            content = (CmsXmlContent)input;
                        } else {
                            CmsResource resource = (CmsResource)input;
                            content = CmsXmlContentFactory.unmarshal((CmsObject)CmsListBox.this.getCmsObject(), (CmsFile)CmsListBox.this.getCmsObject().readFile(resource));
                        }
                        if (CmsListBox.this.getMapping() != null) {
                            entry = CmsListBox.this.getMapping().getEntryFromXmlContent(CmsListBox.this.getCmsObject(), content, CmsListBox.this.getRequestContext().getLocale());
                        }
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                    return entry;
                }
            });
        }
        return this.m_mappedEntries;
    }

    public String getParameter() {
        Locale locale = this.getRequestContext().getLocale();
        String params = this.m_content.getStringValue(this.getCmsObject(), NODE_PARAMETER, locale);
        List links = this.m_content.getValues(NODE_LINKS, locale);
        CmsMacroResolver macroResolver = CmsMacroResolver.newInstance();
        macroResolver.setKeepEmptyMacros(true);
        for (int i = 0; i < links.size(); ++i) {
            I_CmsXmlContentValue xmlValue = (I_CmsXmlContentValue)links.get(i);
            String value = xmlValue.getStringValue(this.getCmsObject());
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)value)) continue;
            StringBuffer macro = new StringBuffer(10);
            macro.append(MACRO_LINK_PREFIX).append(i + 1);
            macroResolver.addMacro(macro.toString(), this.getRequestContext().removeSiteRoot(value));
        }
        return macroResolver.resolveMacros(params);
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        block6: {
            super.init(context, req, res);
            try {
                String path = req.getParameter(PARAM_FILE);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)path)) {
                    // empty if block
                }
                CmsFile file = this.getCmsObject().readFile(this.getCmsObject().getRequestContext().removeSiteRoot(path), CmsResourceFilter.IGNORE_EXPIRATION);
                this.m_content = CmsXmlContentFactory.unmarshal((CmsObject)this.getCmsObject(), (CmsFile)file);
                this.m_mapping = null;
                int mapsize = this.m_content.getValues(NODE_MAPPING, this.getRequestContext().getLocale()).size();
                if (mapsize > 0) {
                    this.m_mapping = new CmsListBoxContentMapping();
                    for (int i = 1; i <= mapsize; ++i) {
                        String basePath = CmsXmlUtils.createXpath((String)NODE_MAPPING, (int)i);
                        String field = this.m_content.getStringValue(this.getCmsObject(), CmsXmlUtils.concatXpath((String)basePath, (String)"Field"), this.getRequestContext().getLocale());
                        String defaultValue = this.m_content.getStringValue(this.getCmsObject(), CmsXmlUtils.concatXpath((String)basePath, (String)"Default"), this.getRequestContext().getLocale());
                        String maxLenghtStr = this.m_content.getStringValue(this.getCmsObject(), CmsXmlUtils.concatXpath((String)basePath, (String)"MaxLength"), this.getRequestContext().getLocale());
                        List xmlNodes = this.m_content.getValues(CmsXmlUtils.concatXpath((String)basePath, (String)"XmlNode"), this.getRequestContext().getLocale());
                        ArrayList<String> nodes = new ArrayList<String>(xmlNodes.size());
                        for (int j = 0; j < xmlNodes.size(); ++j) {
                            nodes.add(((I_CmsXmlContentValue)xmlNodes.get(j)).getStringValue(this.getCmsObject()));
                        }
                        this.m_mapping.addListBoxFieldMapping(nodes, field, maxLenghtStr, defaultValue);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected CmsListBoxContentMapping getMapping() {
        return this.m_mapping;
    }
}

