/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templatetwo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

public class CmsPresetSelectWidget
extends CmsSelectWidget {
    public static final int PRESET_TYPE_ID = 70;

    public CmsPresetSelectWidget() {
        super("");
    }

    public CmsPresetSelectWidget(String configuration) {
        super(configuration);
    }

    public I_CmsWidget newInstance() {
        return new CmsPresetSelectWidget(this.getConfiguration());
    }

    protected List parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        try {
            List resources = cms.readResources("/", CmsResourceFilter.DEFAULT.addRequireType(70), true);
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                CmsResource res = (CmsResource)iter.next();
                String title = cms.readPropertyObject(res, "Title", false).getValue();
                result.add(new CmsSelectWidgetOption(cms.getSitePath(res), false, title, ""));
            }
        }
        catch (CmsException e) {
            // empty catch block
        }
        return result;
    }
}

